/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.ml.dataframe.SourceDestValidator;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;

public class TransportPutDataFrameAnalyticsAction
extends HandledTransportAction<PutDataFrameAnalyticsAction.Request, PutDataFrameAnalyticsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutDataFrameAnalyticsAction.class);
    private final XPackLicenseState licenseState;
    private final DataFrameAnalyticsConfigProvider configProvider;
    private final ThreadPool threadPool;
    private final SecurityContext securityContext;
    private final Client client;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private volatile ByteSizeValue maxModelMemoryLimit;

    @Inject
    public TransportPutDataFrameAnalyticsAction(Settings settings, TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState, Client client, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, DataFrameAnalyticsConfigProvider configProvider) {
        super("cluster:admin/xpack/ml/data_frame/analytics/put", transportService, actionFilters, PutDataFrameAnalyticsAction.Request::new);
        this.licenseState = licenseState;
        this.configProvider = configProvider;
        this.threadPool = threadPool;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = Objects.requireNonNull(indexNameExpressionResolver);
        this.maxModelMemoryLimit = (ByteSizeValue)MachineLearningField.MAX_MODEL_MEMORY_LIMIT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearningField.MAX_MODEL_MEMORY_LIMIT, this::setMaxModelMemoryLimit);
    }

    private void setMaxModelMemoryLimit(ByteSizeValue maxModelMemoryLimit) {
        this.maxModelMemoryLimit = maxModelMemoryLimit;
    }

    protected void doExecute(Task task, PutDataFrameAnalyticsAction.Request request, ActionListener<PutDataFrameAnalyticsAction.Response> listener) {
        if (!this.licenseState.isMachineLearningAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        this.validateConfig(request.getConfig());
        DataFrameAnalyticsConfig memoryCappedConfig = new DataFrameAnalyticsConfig.Builder(request.getConfig(), this.maxModelMemoryLimit).setCreateTime(Instant.now()).setVersion(Version.CURRENT).build();
        if (this.licenseState.isAuthAllowed()) {
            String username = this.securityContext.getUser().principal();
            RoleDescriptor.IndicesPrivileges sourceIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(memoryCappedConfig.getSource().getIndex()).privileges(new String[]{"read"}).build();
            RoleDescriptor.IndicesPrivileges destIndexPrivileges = RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{memoryCappedConfig.getDest().getIndex()}).privileges(new String[]{"read", "index", "create_index"}).build();
            HasPrivilegesRequest privRequest = new HasPrivilegesRequest();
            privRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
            privRequest.username(username);
            privRequest.clusterPrivileges(Strings.EMPTY_ARRAY);
            privRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[]{sourceIndexPrivileges, destIndexPrivileges});
            ActionListener privResponseListener = ActionListener.wrap(r -> this.handlePrivsResponse(username, memoryCappedConfig, (HasPrivilegesResponse)r, listener), arg_0 -> listener.onFailure(arg_0));
            this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)privRequest, privResponseListener);
        } else {
            this.updateDocMappingAndPutConfig(memoryCappedConfig, this.threadPool.getThreadContext().getHeaders(), (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(memoryCappedConfig)), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private void handlePrivsResponse(String username, DataFrameAnalyticsConfig memoryCappedConfig, HasPrivilegesResponse response, ActionListener<PutDataFrameAnalyticsAction.Response> listener) throws IOException {
        if (response.isCompleteMatch()) {
            this.updateDocMappingAndPutConfig(memoryCappedConfig, this.threadPool.getThreadContext().getHeaders(), (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> listener.onResponse((Object)new PutDataFrameAnalyticsAction.Response(memoryCappedConfig)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.startObject();
            for (ResourcePrivileges index : response.getIndexPrivileges()) {
                builder.field(index.getResource());
                builder.map(index.getPrivileges());
            }
            builder.endObject();
            listener.onFailure((Exception)Exceptions.authorizationError((String)"Cannot create data frame analytics [{}] because user {} lacks permissions on the indices: {}", (Object[])new Object[]{memoryCappedConfig.getId(), username, Strings.toString((XContentBuilder)builder)}));
        }
    }

    private void updateDocMappingAndPutConfig(DataFrameAnalyticsConfig config, Map<String, String> headers, ActionListener<IndexResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState == null) {
            logger.warn("Cannot update doc mapping because clusterState == null");
            this.configProvider.put(config, headers, listener);
            return;
        }
        ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.configIndexName(), ElasticsearchMappings::configMapping, (Client)this.client, (ClusterState)clusterState, (ActionListener)ActionListener.wrap(unused -> this.configProvider.put(config, headers, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateConfig(DataFrameAnalyticsConfig config) {
        if (!MlStrings.isValidId((String)config.getId())) {
            throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", (Object[])new Object[]{DataFrameAnalyticsConfig.ID, config.getId()}), (Object[])new Object[0]);
        }
        if (!MlStrings.hasValidLengthForId((String)config.getId())) {
            throw ExceptionsHelper.badRequestException((String)"id [{}] is too long; must not contain more than {} characters", (Object[])new Object[]{config.getId(), 64});
        }
        config.getDest().validate();
        new SourceDestValidator(this.clusterService.state(), this.indexNameExpressionResolver).check(config);
    }
}

