/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;
import org.elasticsearch.xpack.ml.action.TransportStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.dataframe.StoredProgress;

public class TransportGetDataFrameAnalyticsStatsAction
extends TransportTasksAction<TransportStartDataFrameAnalyticsAction.DataFrameAnalyticsTask, GetDataFrameAnalyticsStatsAction.Request, GetDataFrameAnalyticsStatsAction.Response, QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats>> {
    private static final Logger LOGGER = LogManager.getLogger(TransportGetDataFrameAnalyticsStatsAction.class);
    private final Client client;

    @Inject
    public TransportGetDataFrameAnalyticsStatsAction(TransportService transportService, ClusterService clusterService, Client client, ActionFilters actionFilters) {
        super("cluster:monitor/xpack/ml/data_frame/analytics/stats/get", clusterService, transportService, actionFilters, GetDataFrameAnalyticsStatsAction.Request::new, GetDataFrameAnalyticsStatsAction.Response::new, in -> new QueryPage(in, GetDataFrameAnalyticsStatsAction.Response.Stats::new), "management");
        this.client = client;
    }

    protected GetDataFrameAnalyticsStatsAction.Response newResponse(GetDataFrameAnalyticsStatsAction.Request request, List<QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats>> tasks, List<TaskOperationFailure> taskFailures, List<FailedNodeException> nodeFailures) {
        ArrayList stats = new ArrayList();
        for (QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats> task : tasks) {
            stats.addAll(task.results());
        }
        Collections.sort(stats, Comparator.comparing(GetDataFrameAnalyticsStatsAction.Response.Stats::getId));
        return new GetDataFrameAnalyticsStatsAction.Response(taskFailures, nodeFailures, new QueryPage(stats, (long)stats.size(), GetDataFrameAnalyticsAction.Response.RESULTS_FIELD));
    }

    protected void taskOperation(GetDataFrameAnalyticsStatsAction.Request request, TransportStartDataFrameAnalyticsAction.DataFrameAnalyticsTask task, ActionListener<QueryPage<GetDataFrameAnalyticsStatsAction.Response.Stats>> listener) {
        LOGGER.debug("Get stats for running task [{}]", (Object)task.getParams().getId());
        ActionListener progressListener = ActionListener.wrap(progress -> {
            GetDataFrameAnalyticsStatsAction.Response.Stats stats = this.buildStats(task.getParams().getId(), (List<PhaseProgress>)progress);
            listener.onResponse((Object)new QueryPage(Collections.singletonList(stats), 1L, GetDataFrameAnalyticsAction.Response.RESULTS_FIELD));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener reindexingProgressListener = ActionListener.wrap(aVoid -> progressListener.onResponse(task.getProgressTracker().report()), arg_0 -> listener.onFailure(arg_0));
        task.updateReindexTaskProgress((ActionListener<Void>)reindexingProgressListener);
    }

    protected void doExecute(Task task, GetDataFrameAnalyticsStatsAction.Request request, ActionListener<GetDataFrameAnalyticsStatsAction.Response> listener) {
        LOGGER.debug("Get stats for data frame analytics [{}]", (Object)request.getId());
        ActionListener getResponseListener = ActionListener.wrap(getResponse -> {
            List expandedIds = getResponse.getResources().results().stream().map(DataFrameAnalyticsConfig::getId).collect(Collectors.toList());
            request.setExpandedIds(expandedIds);
            ActionListener runningTasksStatsListener = ActionListener.wrap(runningTasksStatsResponse -> this.gatherStatsForStoppedTasks(request.getExpandedIds(), (GetDataFrameAnalyticsStatsAction.Response)runningTasksStatsResponse, (ActionListener<GetDataFrameAnalyticsStatsAction.Response>)ActionListener.wrap(finalResponse -> {
                QueryPage finalStats = new QueryPage(finalResponse.getResponse().results(), getResponse.getResources().count(), GetDataFrameAnalyticsAction.Response.RESULTS_FIELD);
                listener.onResponse((Object)new GetDataFrameAnalyticsStatsAction.Response(finalStats));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            super.doExecute(task, (BaseTasksRequest)request, runningTasksStatsListener);
        }, arg_0 -> listener.onFailure(arg_0));
        GetDataFrameAnalyticsAction.Request getRequest = new GetDataFrameAnalyticsAction.Request();
        getRequest.setResourceId(request.getId());
        getRequest.setAllowNoResources(request.isAllowNoMatch());
        getRequest.setPageParams(request.getPageParams());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetDataFrameAnalyticsAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)getResponseListener);
    }

    void gatherStatsForStoppedTasks(List<String> expandedIds, GetDataFrameAnalyticsStatsAction.Response runningTasksResponse, ActionListener<GetDataFrameAnalyticsStatsAction.Response> listener) {
        List<String> stoppedTasksIds = TransportGetDataFrameAnalyticsStatsAction.determineStoppedTasksIds(expandedIds, runningTasksResponse.getResponse().results());
        if (stoppedTasksIds.isEmpty()) {
            listener.onResponse((Object)runningTasksResponse);
            return;
        }
        this.searchStoredProgresses(stoppedTasksIds, (ActionListener<List<StoredProgress>>)ActionListener.wrap(storedProgresses -> {
            ArrayList<GetDataFrameAnalyticsStatsAction.Response.Stats> stoppedStats = new ArrayList<GetDataFrameAnalyticsStatsAction.Response.Stats>(stoppedTasksIds.size());
            for (int i = 0; i < stoppedTasksIds.size(); ++i) {
                String configId = (String)stoppedTasksIds.get(i);
                StoredProgress storedProgress = (StoredProgress)storedProgresses.get(i);
                stoppedStats.add(this.buildStats(configId, storedProgress.get()));
            }
            ArrayList<GetDataFrameAnalyticsStatsAction.Response.Stats> allTasksStats = new ArrayList<GetDataFrameAnalyticsStatsAction.Response.Stats>(runningTasksResponse.getResponse().results());
            allTasksStats.addAll(stoppedStats);
            Collections.sort(allTasksStats, Comparator.comparing(GetDataFrameAnalyticsStatsAction.Response.Stats::getId));
            listener.onResponse((Object)new GetDataFrameAnalyticsStatsAction.Response(new QueryPage(allTasksStats, (long)allTasksStats.size(), GetDataFrameAnalyticsAction.Response.RESULTS_FIELD)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static List<String> determineStoppedTasksIds(List<String> expandedIds, List<GetDataFrameAnalyticsStatsAction.Response.Stats> runningTasksStats) {
        Set startedTasksIds = runningTasksStats.stream().map(GetDataFrameAnalyticsStatsAction.Response.Stats::getId).collect(Collectors.toSet());
        return expandedIds.stream().filter(id -> !startedTasksIds.contains(id)).collect(Collectors.toList());
    }

    private void searchStoredProgresses(List<String> configIds, ActionListener<List<StoredProgress>> listener) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (String configId : configIds) {
            SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()});
            searchRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
            searchRequest.source().size(1);
            searchRequest.source().query((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{TransportStartDataFrameAnalyticsAction.DataFrameAnalyticsTask.progressDocId(configId)}));
            multiSearchRequest.add(searchRequest);
        }
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)MultiSearchAction.INSTANCE, (ActionRequest)multiSearchRequest, (ActionListener)ActionListener.wrap(multiSearchResponse -> {
            ArrayList<StoredProgress> progresses = new ArrayList<StoredProgress>(configIds.size());
            for (MultiSearchResponse.Item itemResponse : multiSearchResponse.getResponses()) {
                if (itemResponse.isFailure()) {
                    listener.onFailure((Exception)ExceptionsHelper.serverError((String)itemResponse.getFailureMessage(), (Throwable)itemResponse.getFailure()));
                    return;
                }
                SearchHit[] hits = itemResponse.getResponse().getHits().getHits();
                if (hits.length == 0) {
                    progresses.add(new StoredProgress(new TransportStartDataFrameAnalyticsAction.DataFrameAnalyticsTask.ProgressTracker().report()));
                    continue;
                }
                progresses.add(this.parseStoredProgress(hits[0]));
            }
            listener.onResponse(progresses);
        }, e -> listener.onFailure((Exception)ExceptionsHelper.serverError((String)"Error searching for stored progresses", (Throwable)e))));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private StoredProgress parseStoredProgress(SearchHit hit) {
        BytesReference source = hit.getSourceRef();
        try (StreamInput stream = source.streamInput();){
            StoredProgress storedProgress;
            block14: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    StoredProgress storedProgress2;
                    storedProgress = storedProgress2 = (StoredProgress)StoredProgress.PARSER.apply(parser, null);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return storedProgress;
        }
        catch (IOException e) {
            LOGGER.error((Message)new ParameterizedMessage("failed to parse progress from doc with it [{}]", (Object)hit.getId()), (Throwable)e);
            return new StoredProgress(Collections.emptyList());
        }
    }

    private GetDataFrameAnalyticsStatsAction.Response.Stats buildStats(String concreteAnalyticsId, List<PhaseProgress> progress) {
        ClusterState clusterState = this.clusterService.state();
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask analyticsTask = MlTasks.getDataFrameAnalyticsTask((String)concreteAnalyticsId, (PersistentTasksCustomMetaData)tasks);
        DataFrameAnalyticsState analyticsState = MlTasks.getDataFrameAnalyticsState((String)concreteAnalyticsId, (PersistentTasksCustomMetaData)tasks);
        String failureReason = null;
        if (analyticsState == DataFrameAnalyticsState.FAILED) {
            DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)analyticsTask.getState();
            failureReason = taskState.getReason();
        }
        DiscoveryNode node = null;
        String assignmentExplanation = null;
        if (analyticsTask != null) {
            node = clusterState.nodes().get(analyticsTask.getExecutorNode());
            assignmentExplanation = analyticsTask.getAssignment().getExplanation();
        }
        return new GetDataFrameAnalyticsStatsAction.Response.Stats(concreteAnalyticsId, analyticsState, failureReason, progress, node, assignmentExplanation);
    }
}

