/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;

public class TransportEvaluateDataFrameAction
extends HandledTransportAction<EvaluateDataFrameAction.Request, EvaluateDataFrameAction.Response> {
    private final ThreadPool threadPool;
    private final Client client;

    @Inject
    public TransportEvaluateDataFrameAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client) {
        super("cluster:monitor/xpack/ml/data_frame/evaluate", transportService, actionFilters, EvaluateDataFrameAction.Request::new);
        this.threadPool = threadPool;
        this.client = client;
    }

    protected void doExecute(Task task, EvaluateDataFrameAction.Request request, ActionListener<EvaluateDataFrameAction.Response> listener) {
        Evaluation evaluation = request.getEvaluation();
        SearchRequest searchRequest = new SearchRequest(request.getIndices());
        searchRequest.source(evaluation.buildSearch(request.getParsedQuery()));
        ActionListener resultsListener = ActionListener.wrap(results -> listener.onResponse((Object)new EvaluateDataFrameAction.Response(evaluation.getName(), results)), arg_0 -> listener.onFailure(arg_0));
        this.client.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, ActionListener.wrap(searchResponse -> this.threadPool.generic().execute(() -> {
            try {
                evaluation.evaluate(searchResponse, resultsListener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }), arg_0 -> listener.onFailure(arg_0)));
    }
}

