/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.ml.MlConfigMigrator;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class MlAssignmentNotifier
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MlAssignmentNotifier.class);
    private final AnomalyDetectionAuditor auditor;
    private final MlConfigMigrator mlConfigMigrator;
    private final ThreadPool threadPool;

    MlAssignmentNotifier(Settings settings, AnomalyDetectionAuditor auditor, ThreadPool threadPool, Client client, ClusterService clusterService) {
        this.auditor = auditor;
        this.mlConfigMigrator = new MlConfigMigrator(settings, client, clusterService);
        this.threadPool = threadPool;
        clusterService.addListener((ClusterStateListener)this);
    }

    MlAssignmentNotifier(AnomalyDetectionAuditor auditor, ThreadPool threadPool, MlConfigMigrator mlConfigMigrator, ClusterService clusterService) {
        this.auditor = auditor;
        this.mlConfigMigrator = mlConfigMigrator;
        this.threadPool = threadPool;
        clusterService.addListener((ClusterStateListener)this);
    }

    private String executorName() {
        return "generic";
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        this.mlConfigMigrator.migrateConfigs(event.state(), (ActionListener<Boolean>)ActionListener.wrap(response -> this.threadPool.executor(this.executorName()).execute(() -> this.auditChangesToMlTasks(event)), e -> {
            logger.error("error migrating ml configurations", (Throwable)e);
            this.threadPool.executor(this.executorName()).execute(() -> this.auditChangesToMlTasks(event));
        }));
    }

    private void auditChangesToMlTasks(ClusterChangedEvent event) {
        PersistentTasksCustomMetaData current;
        if (!event.metaDataChanged()) {
            return;
        }
        PersistentTasksCustomMetaData previous = (PersistentTasksCustomMetaData)event.previousState().getMetaData().custom("persistent_tasks");
        if (Objects.equals(previous, current = (PersistentTasksCustomMetaData)event.state().getMetaData().custom("persistent_tasks"))) {
            return;
        }
        for (PersistentTasksCustomMetaData.PersistentTask currentTask : current.tasks()) {
            PersistentTasksCustomMetaData.PersistentTask previousTask;
            PersistentTasksCustomMetaData.Assignment previousAssignment;
            PersistentTasksCustomMetaData.Assignment currentAssignment = currentTask.getAssignment();
            if (Objects.equals(currentAssignment, previousAssignment = (previousTask = previous != null ? previous.getTask(currentTask.getId()) : null) != null ? previousTask.getAssignment() : null)) continue;
            if ("xpack/ml/job".equals(currentTask.getTaskName())) {
                String jobId = ((OpenJobAction.JobParams)currentTask.getParams()).getJobId();
                if (currentAssignment.getExecutorNode() == null) {
                    this.auditor.warning(jobId, "No node found to open job. Reasons [" + currentAssignment.getExplanation() + "]");
                    continue;
                }
                DiscoveryNode node = event.state().nodes().get(currentAssignment.getExecutorNode());
                this.auditor.info(jobId, "Opening job on node [" + node.toString() + "]");
                continue;
            }
            if (!"xpack/ml/datafeed".equals(currentTask.getTaskName())) continue;
            StartDatafeedAction.DatafeedParams datafeedParams = (StartDatafeedAction.DatafeedParams)currentTask.getParams();
            String jobId = datafeedParams.getJobId();
            if (currentAssignment.getExecutorNode() == null) {
                String msg = "No node found to start datafeed [" + datafeedParams.getDatafeedId() + "]. Reasons [" + currentAssignment.getExplanation() + "]";
                logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                if (jobId == null) continue;
                this.auditor.warning(jobId, msg);
                continue;
            }
            DiscoveryNode node = event.state().nodes().get(currentAssignment.getExecutorNode());
            if (jobId == null) continue;
            this.auditor.info(jobId, "Starting datafeed [" + datafeedParams.getDatafeedId() + "] on node [" + node + "]");
        }
    }
}

