/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.container;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.sql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.LiteralAttribute;
import org.elasticsearch.xpack.sql.expression.function.ScoreAttribute;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.querydsl.agg.Aggs;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.SearchHitFieldRef;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.sql.querydsl.query.MatchAll;
import org.elasticsearch.xpack.sql.querydsl.query.NestedQuery;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class QueryContainer {
    private final Aggs aggs;
    private final Query query;
    private final List<Tuple<FieldExtraction, ExpressionId>> fields;
    private final AttributeMap<Attribute> aliases;
    private final Map<String, GroupByKey> pseudoFunctions;
    private final AttributeMap<Pipe> scalarFunctions;
    private final Set<Sort> sort;
    private final int limit;
    private final boolean trackHits;
    private final boolean includeFrozen;
    private Boolean aggsOnly;
    private Boolean customSort;

    public QueryContainer() {
        this(null, null, null, null, null, null, null, -1, false, false);
    }

    public QueryContainer(Query query, Aggs aggs, List<Tuple<FieldExtraction, ExpressionId>> fields, AttributeMap<Attribute> aliases, Map<String, GroupByKey> pseudoFunctions, AttributeMap<Pipe> scalarFunctions, Set<Sort> sort, int limit, boolean trackHits, boolean includeFrozen) {
        this.query = query;
        this.aggs = aggs == null ? Aggs.EMPTY : aggs;
        this.fields = fields == null || fields.isEmpty() ? Collections.emptyList() : fields;
        this.aliases = aliases == null || aliases.isEmpty() ? AttributeMap.emptyAttributeMap() : aliases;
        this.pseudoFunctions = pseudoFunctions == null || pseudoFunctions.isEmpty() ? Collections.emptyMap() : pseudoFunctions;
        this.scalarFunctions = scalarFunctions == null || scalarFunctions.isEmpty() ? AttributeMap.emptyAttributeMap() : scalarFunctions;
        this.sort = sort == null || sort.isEmpty() ? Collections.emptySet() : sort;
        this.limit = limit;
        this.trackHits = trackHits;
        this.includeFrozen = includeFrozen;
    }

    public List<Tuple<Integer, Comparator>> sortingColumns() {
        if (this.customSort == Boolean.FALSE) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> sortingColumns = new ArrayList<Tuple>(this.sort.size());
        boolean aggSort = false;
        for (Sort s : this.sort) {
            AttributeSort as;
            Tuple tuple = new Tuple((Object)-1, null);
            if (s instanceof AttributeSort && (as = (AttributeSort)s).attribute() instanceof AggregateFunctionAttribute) {
                aggSort = true;
                AggregateFunctionAttribute afa = (AggregateFunctionAttribute)as.attribute();
                afa = (AggregateFunctionAttribute)this.aliases.getOrDefault((Object)afa, afa);
                int atIndex = -1;
                for (int i = 0; i < this.fields.size(); ++i) {
                    Tuple<FieldExtraction, ExpressionId> field = this.fields.get(i);
                    if (!((ExpressionId)field.v2()).equals(afa.innerId())) continue;
                    atIndex = i;
                    break;
                }
                if (atIndex == -1) {
                    throw new SqlIllegalArgumentException("Cannot find backing column for ordering aggregation [{}]", afa.name());
                }
                Comparator comp = s.direction() == Sort.Direction.ASC ? Comparator.naturalOrder() : Comparator.reverseOrder();
                comp = s.missing() == Sort.Missing.FIRST ? Comparator.nullsFirst(comp) : Comparator.nullsLast(comp);
                tuple = new Tuple((Object)atIndex, comp);
            }
            sortingColumns.add(tuple);
        }
        if (this.customSort == null) {
            this.customSort = aggSort;
        }
        return aggSort ? sortingColumns : Collections.emptyList();
    }

    public BitSet columnMask(List<Attribute> columns) {
        BitSet mask = new BitSet(this.fields.size());
        for (Attribute column : columns) {
            ExpressionId id;
            Attribute alias = this.aliases.get(column);
            int index = -1;
            ExpressionId expressionId = id = column instanceof AggregateFunctionAttribute ? ((AggregateFunctionAttribute)column).innerId() : column.id();
            ExpressionId aliasId = alias != null ? (alias instanceof AggregateFunctionAttribute ? ((AggregateFunctionAttribute)alias).innerId() : alias.id()) : null;
            for (int i = 0; i < this.fields.size(); ++i) {
                Tuple<FieldExtraction, ExpressionId> tuple = this.fields.get(i);
                if (!((ExpressionId)tuple.v2()).equals(id) && (aliasId == null || !((ExpressionId)tuple.v2()).equals(aliasId))) continue;
                index = i;
                break;
            }
            if (index > -1) {
                mask.set(index);
                continue;
            }
            throw new SqlIllegalArgumentException("Cannot resolve field extractor index for column [{}]", column);
        }
        return mask;
    }

    public Query query() {
        return this.query;
    }

    public Aggs aggs() {
        return this.aggs;
    }

    public List<Tuple<FieldExtraction, ExpressionId>> fields() {
        return this.fields;
    }

    public AttributeMap<Attribute> aliases() {
        return this.aliases;
    }

    public Map<String, GroupByKey> pseudoFunctions() {
        return this.pseudoFunctions;
    }

    public Set<Sort> sort() {
        return this.sort;
    }

    public int limit() {
        return this.limit;
    }

    public boolean isAggsOnly() {
        if (this.aggsOnly == null) {
            this.aggsOnly = this.fields.stream().anyMatch(t -> ((FieldExtraction)t.v1()).supportedByAggsOnlyQuery());
        }
        return this.aggsOnly;
    }

    public boolean hasColumns() {
        return this.fields.size() > 0;
    }

    public boolean shouldTrackHits() {
        return this.trackHits;
    }

    public boolean shouldIncludeFrozen() {
        return this.includeFrozen;
    }

    public QueryContainer with(Query q) {
        return new QueryContainer(q, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public QueryContainer withAliases(AttributeMap<Attribute> a) {
        return new QueryContainer(this.query, this.aggs, this.fields, a, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public QueryContainer withPseudoFunctions(Map<String, GroupByKey> p) {
        return new QueryContainer(this.query, this.aggs, this.fields, this.aliases, p, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public QueryContainer with(Aggs a) {
        return new QueryContainer(this.query, a, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public QueryContainer withLimit(int l) {
        return l == this.limit ? this : new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, l, this.trackHits, this.includeFrozen);
    }

    public QueryContainer withTrackHits() {
        return this.trackHits ? this : new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, true, this.includeFrozen);
    }

    public QueryContainer withFrozen() {
        return this.includeFrozen ? this : new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, true);
    }

    public QueryContainer withScalarProcessors(AttributeMap<Pipe> procs) {
        return new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, procs, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public QueryContainer addSort(Sort sortable) {
        LinkedHashSet<Sort> sort = new LinkedHashSet<Sort>(this.sort);
        sort.add(sortable);
        return new QueryContainer(this.query, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, sort, this.limit, this.trackHits, this.includeFrozen);
    }

    private String aliasName(Attribute attr) {
        return this.aliases.getOrDefault((Object)attr, attr).name();
    }

    private FieldExtraction topHitFieldRef(FieldAttribute fieldAttr) {
        FieldAttribute actualField = fieldAttr;
        FieldAttribute rootField = fieldAttr;
        StringBuilder fullFieldName = new StringBuilder(fieldAttr.field().getName());
        if (!fieldAttr.field().isAlias()) {
            while (actualField.parent() != null && actualField.parent().field().getDataType() != DataType.OBJECT && actualField.parent().field().getDataType() != DataType.NESTED && !actualField.field().getDataType().isFromDocValuesOnly()) {
                actualField = actualField.parent();
            }
        }
        while (rootField.parent() != null) {
            fullFieldName.insert(0, ".").insert(0, rootField.parent().field().getName());
            rootField = rootField.parent();
        }
        return new SearchHitFieldRef(this.aliasName(actualField), fullFieldName.toString(), fieldAttr.field().getDataType(), fieldAttr.field().isAggregatable(), fieldAttr.field().isAlias());
    }

    private Tuple<QueryContainer, FieldExtraction> nestedHitFieldRef(FieldAttribute attr) {
        String name = this.aliasName(attr);
        Query q = QueryContainer.rewriteToContainNestedField(this.query, attr.source(), attr.nestedParent().name(), name, attr.field().getDataType().format(), attr.field().getDataType().isFromDocValuesOnly());
        SearchHitFieldRef nestedFieldRef = new SearchHitFieldRef(name, null, attr.field().getDataType(), attr.field().isAggregatable(), false, attr.parent().name());
        return new Tuple((Object)new QueryContainer(q, this.aggs, this.fields, this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen), (Object)nestedFieldRef);
    }

    static Query rewriteToContainNestedField(@Nullable Query query, Source source, String path, String name, String format, boolean hasDocValues) {
        if (query == null) {
            return new NestedQuery(source, path, Collections.singletonMap(name, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format)), new MatchAll(source));
        }
        if (query.containsNestedField(path, name)) {
            return query;
        }
        Query rewritten = query.addNestedField(path, name, format, hasDocValues);
        if (rewritten != query) {
            return rewritten;
        }
        NestedQuery nested = new NestedQuery(source, path, Collections.singletonMap(name, new AbstractMap.SimpleImmutableEntry<Boolean, String>(hasDocValues, format)), new MatchAll(source));
        return new BoolQuery(source, true, query, nested);
    }

    private Tuple<QueryContainer, FieldExtraction> resolvedTreeComputingRef(ScalarFunctionAttribute ta) {
        Attribute attribute = this.aliases.getOrDefault((Object)ta, ta);
        Pipe proc = this.scalarFunctions.get(attribute);
        if (proc == null) {
            if (attribute instanceof ScalarFunctionAttribute) {
                ta = (ScalarFunctionAttribute)attribute;
            }
            proc = ta.asPipe();
        }
        class QueryAttributeResolver
        implements Pipe.AttributeResolver {
            private QueryContainer container;

            QueryAttributeResolver(QueryContainer container) {
                this.container = container;
            }

            @Override
            public FieldExtraction resolve(Attribute attribute) {
                Attribute attr = QueryContainer.this.aliases.getOrDefault((Object)attribute, attribute);
                Tuple ref = this.container.toReference(attr);
                this.container = (QueryContainer)ref.v1();
                return (FieldExtraction)ref.v2();
            }
        }
        QueryAttributeResolver resolver = new QueryAttributeResolver(this);
        proc = proc.resolveAttributes(resolver);
        QueryContainer qContainer = resolver.container;
        LinkedHashMap<Attribute, Pipe> procs = new LinkedHashMap<Attribute, Pipe>(qContainer.scalarFunctions());
        procs.put(attribute, proc);
        qContainer = qContainer.withScalarProcessors(new AttributeMap<Pipe>(procs));
        return new Tuple((Object)qContainer, (Object)new ComputedRef(proc));
    }

    public QueryContainer addColumn(Attribute attr) {
        Tuple<QueryContainer, FieldExtraction> tuple = this.toReference(attr);
        return ((QueryContainer)tuple.v1()).addColumn((FieldExtraction)tuple.v2(), attr);
    }

    private Tuple<QueryContainer, FieldExtraction> toReference(Attribute attr) {
        if (attr instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)attr;
            if (fa.isNested()) {
                return this.nestedHitFieldRef(fa);
            }
            return new Tuple((Object)this, (Object)this.topHitFieldRef(fa));
        }
        if (attr instanceof ScalarFunctionAttribute) {
            return this.resolvedTreeComputingRef((ScalarFunctionAttribute)attr);
        }
        if (attr instanceof LiteralAttribute) {
            return new Tuple((Object)this, (Object)new ComputedRef(((LiteralAttribute)attr).asPipe()));
        }
        if (attr instanceof ScoreAttribute) {
            return new Tuple((Object)this, (Object)new ComputedRef(((ScoreAttribute)attr).asPipe()));
        }
        throw new SqlIllegalArgumentException("Unknown output attribute {}", attr);
    }

    public QueryContainer addColumn(FieldExtraction ref, Attribute attr) {
        ExpressionId id = attr instanceof AggregateFunctionAttribute ? ((AggregateFunctionAttribute)attr).innerId() : attr.id();
        return new QueryContainer(this.query, this.aggs, CollectionUtils.combine(this.fields, new Tuple((Object)ref, (Object)id)), this.aliases, this.pseudoFunctions, this.scalarFunctions, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public AttributeMap<Pipe> scalarFunctions() {
        return this.scalarFunctions;
    }

    public QueryContainer addAgg(String groupId, LeafAgg agg) {
        return this.with(this.aggs.addAgg(agg));
    }

    public QueryContainer addGroups(Collection<GroupByKey> values) {
        return this.with(this.aggs.addGroups(values));
    }

    public GroupByKey findGroupForAgg(String aggId) {
        return this.aggs.findGroupForAgg(aggId);
    }

    public QueryContainer updateGroup(GroupByKey group) {
        return this.with(this.aggs.updateGroup(group));
    }

    public int hashCode() {
        return Objects.hash(this.query, this.aggs, this.fields, this.aliases, this.sort, this.limit, this.trackHits, this.includeFrozen);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryContainer other = (QueryContainer)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.aggs, other.aggs) && Objects.equals(this.fields, other.fields) && Objects.equals(this.aliases, other.aliases) && Objects.equals(this.sort, other.sort) && Objects.equals(this.limit, other.limit) && Objects.equals(this.trackHits, other.trackHits) && Objects.equals(this.includeFrozen, other.includeFrozen);
    }

    public String toString() {
        String string;
        block8: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.humanReadable(true).prettyPrint();
                SourceGenerator.sourceBuilder(this, null, null).toXContent(builder, ToXContent.EMPTY_PARAMS);
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("error rendering", e);
                }
            }
            builder.close();
        }
        return string;
    }
}

