/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.physical.LeafExec;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.session.Executable;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class LocalExec
extends LeafExec {
    private final Executable executable;

    public LocalExec(Source source, Executable executable) {
        super(source);
        this.executable = executable;
    }

    @Override
    protected NodeInfo<LocalExec> info() {
        return NodeInfo.create(this, LocalExec::new, this.executable);
    }

    public Executable executable() {
        return this.executable;
    }

    @Override
    public List<Attribute> output() {
        return this.executable.output();
    }

    public boolean isEmpty() {
        return this.executable instanceof EmptyExecutable;
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        this.executable.execute(session, listener);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.executable);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocalExec other = (LocalExec)obj;
        return Objects.equals(this.executable, other.executable);
    }
}

