/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.rule.RuleExecutor;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.NodeUtils;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.KeywordEsField;
import org.elasticsearch.xpack.sql.util.Graphviz;

public class Debug
extends Command {
    private final LogicalPlan plan;
    private final Format format;
    private final Type type;

    public Debug(Source source, LogicalPlan plan, Type type, Format format) {
        super(source);
        this.plan = plan;
        this.format = format == null ? Format.TEXT : format;
        this.type = type == null ? Type.OPTIMIZED : type;
    }

    @Override
    protected NodeInfo<Debug> info() {
        return NodeInfo.create(this, Debug::new, this.plan, this.type, this.format);
    }

    public LogicalPlan plan() {
        return this.plan;
    }

    public Format format() {
        return this.format;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public List<Attribute> output() {
        return Collections.singletonList(new FieldAttribute(this.source(), "plan", new KeywordEsField("plan")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<Cursor.Page> listener) {
        switch (this.type) {
            case ANALYZED: {
                session.debugAnalyzedPlan(this.plan, (ActionListener<RuleExecutor.ExecutionInfo>)ActionListener.wrap(i -> this.handleInfo((RuleExecutor.ExecutionInfo)i, listener), arg_0 -> listener.onFailure(arg_0)));
                break;
            }
            case OPTIMIZED: {
                session.analyzedPlan(this.plan, true, (ActionListener<LogicalPlan>)ActionListener.wrap(analyzedPlan -> this.handleInfo(session.optimizer().debugOptimize((LogicalPlan)analyzedPlan), listener), arg_0 -> listener.onFailure(arg_0)));
                break;
            }
        }
    }

    private void handleInfo(RuleExecutor.ExecutionInfo info, ActionListener<Cursor.Page> listener) {
        String planString = null;
        if (this.format == Format.TEXT) {
            StringBuilder sb = new StringBuilder();
            if (info == null) {
                sb.append(this.plan.toString());
            } else {
                Map<RuleExecutor.Batch, List<RuleExecutor.Transformation>> map = info.transformations();
                for (Map.Entry<RuleExecutor.Batch, List<RuleExecutor.Transformation>> entry : map.entrySet()) {
                    sb.append("***");
                    sb.append(entry.getKey().name());
                    sb.append("***");
                    for (RuleExecutor.Transformation tf : entry.getValue()) {
                        sb.append(tf.ruleName());
                        sb.append("\n");
                        sb.append(NodeUtils.diffString(tf.before(), tf.after()));
                        sb.append("\n");
                    }
                }
            }
            planString = sb.toString();
        } else if (info == null) {
            planString = Graphviz.dot("Planned", this.plan);
        } else {
            LinkedHashMap plans = new LinkedHashMap();
            Map<RuleExecutor.Batch, List<RuleExecutor.Transformation>> map = info.transformations();
            plans.put("start", info.before());
            for (Map.Entry<RuleExecutor.Batch, List<RuleExecutor.Transformation>> entry : map.entrySet()) {
                int counter = 0;
                for (RuleExecutor.Transformation tf : entry.getValue()) {
                    if (!tf.hasChanged()) continue;
                    plans.put(tf.ruleName() + "#" + ++counter, tf.after());
                }
            }
            planString = Graphviz.dot(plans, true);
        }
        listener.onResponse((Object)Cursor.Page.last(Rows.singleton(this.output(), planString)));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.plan, this.type, this.format});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Debug o = (Debug)obj;
        return Objects.equals((Object)this.format, (Object)o.format) && Objects.equals((Object)this.type, (Object)o.type) && Objects.equals(this.plan, o.plan);
    }

    public static enum Format {
        TEXT,
        GRAPHVIZ;

    }

    public static enum Type {
        ANALYZED,
        OPTIMIZED;

    }
}

