/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.geo;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistanceFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistancePipe;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class StDistance
extends BinaryOperator<Object, Object, Double, StDistanceFunction> {
    private static final StDistanceFunction FUNCTION = new StDistanceFunction();

    public StDistance(Source source, Expression source1, Expression source2) {
        super(source, source1, source2, FUNCTION);
    }

    @Override
    protected StDistance replaceChildren(Expression newLeft, Expression newRight) {
        return new StDistance(this.source(), newLeft, newRight);
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected NodeInfo<StDistance> info() {
        return NodeInfo.create(this, StDistance::new, this.left(), this.right());
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("{sql}.geoDocValue(doc,{})"), ParamsBuilder.paramsBuilder().variable(field.exactAttribute().name()).build(), this.dataType());
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isGeo(e, this.sourceText(), paramOrdinal);
    }

    public StDistance swapLeftAndRight() {
        return new StDistance(this.source(), this.right(), this.left());
    }

    @Override
    protected Pipe makePipe() {
        return new StDistancePipe(this.source(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()));
    }

    @Override
    protected String scriptMethodName() {
        return "stDistance";
    }
}

