/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.geo;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public class GeoShape
implements ToXContentFragment,
NamedWriteable {
    public static final String NAME = "geo";
    private final Geometry shape;
    private static final GeometryValidator validator = new StandardValidator(true);
    private static final GeometryParser GEOMETRY_PARSER = new GeometryParser(true, true, true);
    private static final WellKnownText WKT_PARSER = new WellKnownText(true, validator);

    public GeoShape(double lon, double lat) {
        this.shape = new Point(lon, lat);
    }

    public GeoShape(Object value) throws IOException {
        try {
            this.shape = GeoShape.parse(value);
        }
        catch (ParseException ex) {
            throw new SqlIllegalArgumentException("Cannot parse [" + value + "] as a geo_shape value", ex);
        }
    }

    public GeoShape(StreamInput in) throws IOException {
        String value = in.readString();
        try {
            this.shape = GeoShape.parse(value);
        }
        catch (ParseException ex) {
            throw new SqlIllegalArgumentException("Cannot parse [" + value + "] as a geo_shape value", ex);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(WKT_PARSER.toWKT(this.shape));
    }

    public String toString() {
        return WKT_PARSER.toWKT(this.shape);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(WKT_PARSER.toWKT(this.shape));
    }

    public Geometry toGeometry() {
        return this.shape;
    }

    public Point firstPoint() {
        return (Point)this.shape.visit((GeometryVisitor)new GeometryVisitor<Point, RuntimeException>(){

            public Point visit(Circle circle) {
                return new Point(circle.getX(), circle.getY(), circle.hasZ() ? circle.getZ() : Double.NaN);
            }

            public Point visit(GeometryCollection<?> collection) {
                if (collection.size() > 0) {
                    return (Point)collection.get(0).visit((GeometryVisitor)this);
                }
                return null;
            }

            public Point visit(Line line) {
                if (line.length() > 0) {
                    return new Point(line.getX(0), line.getY(0), line.hasZ() ? line.getZ(0) : Double.NaN);
                }
                return null;
            }

            public Point visit(LinearRing ring) {
                return this.visit((Line)ring);
            }

            public Point visit(MultiLine multiLine) {
                return this.visit((GeometryCollection<?>)multiLine);
            }

            public Point visit(MultiPoint multiPoint) {
                return this.visit((GeometryCollection<?>)multiPoint);
            }

            public Point visit(MultiPolygon multiPolygon) {
                return this.visit((GeometryCollection<?>)multiPolygon);
            }

            public Point visit(Point point) {
                return point;
            }

            public Point visit(Polygon polygon) {
                return this.visit(polygon.getPolygon());
            }

            public Point visit(Rectangle rectangle) {
                return new Point(rectangle.getMinX(), rectangle.getMinY(), rectangle.getMinZ());
            }
        });
    }

    public Double getX() {
        Point firstPoint = this.firstPoint();
        return firstPoint != null ? Double.valueOf(firstPoint.getX()) : null;
    }

    public Double getY() {
        Point firstPoint = this.firstPoint();
        return firstPoint != null ? Double.valueOf(firstPoint.getY()) : null;
    }

    public Double getZ() {
        Point firstPoint = this.firstPoint();
        return firstPoint != null && firstPoint.hasZ() ? Double.valueOf(firstPoint.getZ()) : null;
    }

    public String getGeometryType() {
        return this.toGeometry().type().name();
    }

    public static double distance(GeoShape shape1, GeoShape shape2) {
        if (!(shape1.shape instanceof Point)) {
            throw new SqlIllegalArgumentException("distance calculation is only supported for points; received [{}]", shape1);
        }
        if (!(shape2.shape instanceof Point)) {
            throw new SqlIllegalArgumentException("distance calculation is only supported for points; received [{}]", shape2);
        }
        double srcLat = ((Point)shape1.shape).getY();
        double srcLon = ((Point)shape1.shape).getX();
        double dstLat = ((Point)shape2.shape).getY();
        double dstLon = ((Point)shape2.shape).getX();
        return GeoUtils.arcDistance((double)srcLat, (double)srcLon, (double)dstLat, (double)dstLon);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoShape geoShape = (GeoShape)o;
        return this.shape.equals(geoShape.shape);
    }

    public int hashCode() {
        return Objects.hash(this.shape);
    }

    public String getWriteableName() {
        return NAME;
    }

    private static Geometry parse(Object value) throws IOException, ParseException {
        XContentBuilder content = JsonXContent.contentBuilder();
        content.startObject();
        content.field("value", value);
        content.endObject();
        try (StreamInput stream = BytesReference.bytes((XContentBuilder)content).streamInput();){
            Geometry geometry;
            block12: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    parser.nextToken();
                    parser.nextToken();
                    parser.nextToken();
                    geometry = GEOMETRY_PARSER.parse(parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return geometry;
        }
    }
}

