/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.GeoShape;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class FieldHitExtractor
implements HitExtractor {
    private static final Version SWITCHED_FROM_DOCVALUES_TO_SOURCE_EXTRACTION = Version.V_7_4_0;
    static final String NAME = "f";
    private final String fieldName;
    private final String hitName;
    private final String fullFieldName;
    private final DataType dataType;
    private final ZoneId zoneId;
    private final boolean useDocValue;
    private final boolean arrayLeniency;
    private final String[] path;

    private static String[] sourcePath(String name, boolean useDocValue, String hitName) {
        return useDocValue ? Strings.EMPTY_ARRAY : Strings.tokenizeToStringArray((String)(hitName == null ? name : name.substring(hitName.length() + 1)), (String)".");
    }

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue) {
        this(name, null, dataType, zoneId, useDocValue, null, false);
    }

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue, boolean arrayLeniency) {
        this(name, null, dataType, zoneId, useDocValue, null, arrayLeniency);
    }

    public FieldHitExtractor(String name, String fullFieldName, DataType dataType, ZoneId zoneId, boolean useDocValue, String hitName, boolean arrayLeniency) {
        this.fieldName = name;
        this.fullFieldName = fullFieldName;
        this.dataType = dataType;
        this.zoneId = zoneId;
        this.useDocValue = useDocValue;
        this.arrayLeniency = arrayLeniency;
        this.hitName = hitName;
        if (hitName != null && !name.contains(hitName)) {
            throw new SqlIllegalArgumentException("Hitname [{}] specified but not part of the name [{}]", hitName, name);
        }
        this.path = FieldHitExtractor.sourcePath(this.fieldName, useDocValue, hitName);
    }

    FieldHitExtractor(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        this.fullFieldName = in.getVersion().onOrAfter(SWITCHED_FROM_DOCVALUES_TO_SOURCE_EXTRACTION) ? in.readOptionalString() : null;
        String esType = in.readOptionalString();
        this.dataType = esType != null ? DataType.fromTypeName(esType) : null;
        this.useDocValue = in.readBoolean();
        this.hitName = in.readOptionalString();
        this.arrayLeniency = in.readBoolean();
        this.path = FieldHitExtractor.sourcePath(this.fieldName, this.useDocValue, this.hitName);
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        if (out.getVersion().onOrAfter(SWITCHED_FROM_DOCVALUES_TO_SOURCE_EXTRACTION)) {
            out.writeOptionalString(this.fullFieldName);
        }
        out.writeOptionalString(this.dataType == null ? null : this.dataType.typeName);
        out.writeBoolean(this.useDocValue);
        out.writeOptionalString(this.hitName);
        out.writeBoolean(this.arrayLeniency);
    }

    @Override
    public Object extract(SearchHit hit) {
        Object value = null;
        if (this.useDocValue) {
            DocumentField field = hit.field(this.fieldName);
            if (field != null) {
                value = this.unwrapMultiValue(field.getValues());
            }
        } else {
            if (this.fullFieldName != null && hit.getFields().containsKey("_ignored") && !this.dataType.isFromDocValuesOnly() && this.dataType.isNumeric() && ((DocumentField)hit.getFields().get("_ignored")).getValues().contains(this.fullFieldName)) {
                return null;
            }
            Map source = hit.getSourceAsMap();
            if (source != null) {
                value = this.extractFromSource(source);
            }
        }
        return value;
    }

    private Object unwrapMultiValue(Object values) {
        if (values == null) {
            return null;
        }
        if (values instanceof List) {
            List list = (List)values;
            if (list.isEmpty()) {
                return null;
            }
            if (!this.isGeoPointArray(list)) {
                if (list.size() == 1 || this.arrayLeniency) {
                    return this.unwrapMultiValue(list.get(0));
                }
                throw new SqlIllegalArgumentException("Arrays (returned by [{}]) are not supported", this.fieldName);
            }
        }
        if (this.dataType == DataType.GEO_POINT) {
            try {
                GeoPoint geoPoint = GeoUtils.parseGeoPoint((Object)values, (boolean)true);
                return new GeoShape(geoPoint.lon(), geoPoint.lat());
            }
            catch (ElasticsearchParseException ex) {
                throw new SqlIllegalArgumentException("Cannot parse geo_point value [{}] (returned by [{}])", values, this.fieldName);
            }
        }
        if (this.dataType == DataType.GEO_SHAPE) {
            try {
                return new GeoShape(values);
            }
            catch (IOException ex) {
                throw new SqlIllegalArgumentException("Cannot read geo_shape value [{}] (returned by [{}])", values, this.fieldName);
            }
        }
        if (values instanceof Map) {
            throw new SqlIllegalArgumentException("Objects (returned by [{}]) are not supported", this.fieldName);
        }
        if (this.dataType == DataType.DATETIME && values instanceof String) {
            return DateUtils.asDateTime(Long.parseLong(values.toString()), this.zoneId);
        }
        if (values instanceof Number || values instanceof String || values instanceof Boolean) {
            if (this.dataType == null) {
                return values;
            }
            if (this.dataType.isNumeric() && !this.dataType.isFromDocValuesOnly()) {
                Number result;
                if (this.dataType == DataType.DOUBLE || this.dataType == DataType.FLOAT || this.dataType == DataType.HALF_FLOAT) {
                    result = null;
                    try {
                        result = this.dataType.numberType().parse(values, true);
                    }
                    catch (IllegalArgumentException iae) {
                        return null;
                    }
                    return result.doubleValue();
                }
                result = null;
                try {
                    result = this.dataType.numberType().parse(values, true);
                }
                catch (IllegalArgumentException iae) {
                    return null;
                }
                return result;
            }
            if (this.dataType.isString()) {
                return values.toString();
            }
            return values;
        }
        throw new SqlIllegalArgumentException("Type {} (returned by [{}]) is not supported", values.getClass().getSimpleName(), this.fieldName);
    }

    private boolean isGeoPointArray(List<?> list) {
        if (this.dataType != DataType.GEO_POINT) {
            return false;
        }
        if (list.size() > 3 || list.size() < 1) {
            return false;
        }
        return list.get(0) instanceof Number;
    }

    Object extractFromSource(Map<String, Object> map) {
        Object value = null;
        ArrayDeque<Tuple> queue = new ArrayDeque<Tuple>();
        queue.add(new Tuple((Object)-1, map));
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.removeLast();
            int idx = (Integer)tuple.v1();
            Map subMap = (Map)tuple.v2();
            StringJoiner sj = new StringJoiner(".");
            for (int i = idx + 1; i < this.path.length; ++i) {
                sj.add(this.path[i]);
                Object node = subMap.get(sj.toString());
                if (node instanceof List) {
                    List listOfValues = (List)node;
                    if (i < this.path.length - 1 && (listOfValues.size() == 1 || this.arrayLeniency)) {
                        node = listOfValues.get(0);
                    } else {
                        return this.unwrapMultiValue(node);
                    }
                }
                if (node instanceof Map) {
                    if (i < this.path.length - 1) {
                        queue.add(new Tuple((Object)i, (Object)((Map)node)));
                        continue;
                    }
                    value = node;
                    continue;
                }
                if (node == null) continue;
                if (i < this.path.length - 1) {
                    throw new SqlIllegalArgumentException("Cannot extract value [{}] from source", this.fieldName);
                }
                if (value != null) {
                    throw new SqlIllegalArgumentException("Multiple values (returned by [{}]) are not supported", this.fieldName);
                }
                value = node;
            }
        }
        return this.unwrapMultiValue(value);
    }

    @Override
    public String hitName() {
        return this.hitName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String fullFieldName() {
        return this.fullFieldName;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    DataType dataType() {
        return this.dataType;
    }

    public String toString() {
        return this.fieldName + "@" + this.hitName + "@" + this.zoneId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FieldHitExtractor other = (FieldHitExtractor)obj;
        return this.fieldName.equals(other.fieldName) && this.hitName.equals(other.hitName) && this.useDocValue == other.useDocValue && this.arrayLeniency == other.arrayLeniency;
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.useDocValue, this.hitName, this.arrayLeniency);
    }
}

