/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggsRowSet;
import org.elasticsearch.xpack.sql.execution.search.Querier;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.type.Schema;
import org.elasticsearch.xpack.sql.util.StringUtils;

public class CompositeAggregationCursor
implements Cursor {
    private final Logger log = LogManager.getLogger(this.getClass());
    public static final String NAME = "c";
    private final String[] indices;
    private final byte[] nextQuery;
    private final List<BucketExtractor> extractors;
    private final BitSet mask;
    private final int limit;
    private final boolean includeFrozen;

    CompositeAggregationCursor(byte[] next, List<BucketExtractor> exts, BitSet mask, int remainingLimit, boolean includeFrozen, String ... indices) {
        this.indices = indices;
        this.nextQuery = next;
        this.extractors = exts;
        this.mask = mask;
        this.limit = remainingLimit;
        this.includeFrozen = includeFrozen;
    }

    public CompositeAggregationCursor(StreamInput in) throws IOException {
        this.indices = in.readStringArray();
        this.nextQuery = in.readByteArray();
        this.limit = in.readVInt();
        this.extractors = in.readNamedWriteableList(BucketExtractor.class);
        this.mask = BitSet.valueOf(in.readByteArray());
        this.includeFrozen = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeByteArray(this.nextQuery);
        out.writeVInt(this.limit);
        out.writeNamedWriteableList(this.extractors);
        out.writeByteArray(this.mask.toByteArray());
        out.writeBoolean(this.includeFrozen);
    }

    public String getWriteableName() {
        return NAME;
    }

    String[] indices() {
        return this.indices;
    }

    byte[] next() {
        return this.nextQuery;
    }

    BitSet mask() {
        return this.mask;
    }

    List<BucketExtractor> extractors() {
        return this.extractors;
    }

    int limit() {
        return this.limit;
    }

    boolean includeFrozen() {
        return this.includeFrozen;
    }

    @Override
    public void nextPage(Configuration cfg, final Client client, NamedWriteableRegistry registry, final ActionListener<Cursor.Page> listener) {
        SearchSourceBuilder q;
        try {
            q = CompositeAggregationCursor.deserializeQuery(registry, this.nextQuery);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
            return;
        }
        SearchSourceBuilder query = q;
        if (this.log.isTraceEnabled()) {
            this.log.trace("About to execute composite query {} on {}", (Object)StringUtils.toString(query), (Object)this.indices);
        }
        final SearchRequest search = Querier.prepareRequest(client, query, cfg.pageTimeout(), this.includeFrozen, this.indices);
        client.search(search, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse r) {
                CompositeAggregationCursor.handle(r, search.source(), ba -> new CompositeAggsRowSet(CompositeAggregationCursor.this.extractors, CompositeAggregationCursor.this.mask, r, CompositeAggregationCursor.this.limit, (byte[])ba), () -> client.search(search, (ActionListener)this), p -> listener.onResponse(p), e -> listener.onFailure(e), Schema.EMPTY, CompositeAggregationCursor.this.includeFrozen, CompositeAggregationCursor.this.indices);
            }

            public void onFailure(Exception ex) {
                listener.onFailure(ex);
            }
        });
    }

    static void handle(SearchResponse response, SearchSourceBuilder source, Function<byte[], CompositeAggsRowSet> makeRowSet, Runnable retry, Consumer<Cursor.Page> onPage, Consumer<Exception> onFailure, Schema schema, boolean includeFrozen, String[] indices) {
        if (!response.getAggregations().asList().isEmpty()) {
            if (CompositeAggregationCursor.shouldRetryDueToEmptyPage(response)) {
                CompositeAggregationCursor.updateCompositeAfterKey(response, source);
                retry.run();
                return;
            }
            try {
                boolean hasAfterKey = CompositeAggregationCursor.updateCompositeAfterKey(response, source);
                byte[] queryAsBytes = hasAfterKey ? CompositeAggregationCursor.serializeQuery(source) : null;
                CompositeAggsRowSet rowSet = makeRowSet.apply(queryAsBytes);
                Cursor next = rowSet.remainingData() == 0 ? Cursor.EMPTY : new CompositeAggregationCursor(queryAsBytes, rowSet.extractors(), rowSet.mask(), rowSet.remainingData(), includeFrozen, indices);
                onPage.accept(new Cursor.Page(rowSet, next));
            }
            catch (Exception ex) {
                onFailure.accept(ex);
            }
        } else {
            onPage.accept(Cursor.Page.last(Rows.empty(schema)));
        }
    }

    static boolean shouldRetryDueToEmptyPage(SearchResponse response) {
        CompositeAggregation composite = CompositeAggregationCursor.getComposite(response);
        return composite != null && composite.getBuckets().isEmpty() && composite.afterKey() != null && !composite.afterKey().isEmpty();
    }

    static CompositeAggregation getComposite(SearchResponse response) {
        Aggregation agg = response.getAggregations().get("groupby");
        if (agg == null) {
            return null;
        }
        if (agg instanceof CompositeAggregation) {
            return (CompositeAggregation)agg;
        }
        throw new SqlIllegalArgumentException("Unrecognized root group found; {}", agg.getClass());
    }

    static boolean updateCompositeAfterKey(SearchResponse r, SearchSourceBuilder next) {
        CompositeAggregation composite = CompositeAggregationCursor.getComposite(r);
        if (composite == null) {
            throw new SqlIllegalArgumentException("Invalid server response; no group-by detected");
        }
        Map afterKey = composite.afterKey();
        if (afterKey == null) {
            return false;
        }
        AggregationBuilder aggBuilder = (AggregationBuilder)next.aggregations().getAggregatorFactories().iterator().next();
        if (aggBuilder instanceof CompositeAggregationBuilder) {
            CompositeAggregationBuilder comp = (CompositeAggregationBuilder)aggBuilder;
            comp.aggregateAfter(afterKey);
            return true;
        }
        throw new SqlIllegalArgumentException("Invalid client request; expected a group-by but instead got {}", aggBuilder);
    }

    private static SearchSourceBuilder deserializeQuery(NamedWriteableRegistry registry, byte[] source) throws IOException {
        try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(StreamInput.wrap((byte[])source), registry);){
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder((StreamInput)in);
            return searchSourceBuilder;
        }
    }

    static byte[] serializeQuery(SearchSourceBuilder source) throws IOException {
        if (source == null) {
            return new byte[0];
        }
        try (BytesStreamOutput out = new BytesStreamOutput();){
            source.writeTo((StreamOutput)out);
            byte[] byArray = BytesReference.toBytes((BytesReference)out.bytes());
            return byArray;
        }
    }

    @Override
    public void clear(Configuration cfg, Client client, ActionListener<Boolean> listener) {
        listener.onResponse((Object)true);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), Arrays.hashCode(this.nextQuery), this.extractors, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CompositeAggregationCursor other = (CompositeAggregationCursor)obj;
        return Arrays.equals(this.indices, other.indices) && Arrays.equals(this.nextQuery, other.nextQuery) && Objects.equals(this.extractors, other.extractors) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "cursor for composite on index [" + Arrays.toString(this.indices) + "]";
    }
}

