/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.sql.analysis.analyzer.PreAnalyzer;
import org.elasticsearch.xpack.sql.analysis.analyzer.Verifier;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.execution.search.SourceGenerator;
import org.elasticsearch.xpack.sql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.sql.optimizer.Optimizer;
import org.elasticsearch.xpack.sql.plan.physical.CommandExec;
import org.elasticsearch.xpack.sql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.sql.plan.physical.LocalExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.planner.Planner;
import org.elasticsearch.xpack.sql.planner.PlanningException;
import org.elasticsearch.xpack.sql.proto.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.stats.Metrics;
import org.elasticsearch.xpack.sql.stats.QueryMetric;

public class PlanExecutor {
    private final Client client;
    private final NamedWriteableRegistry writableRegistry;
    private final FunctionRegistry functionRegistry;
    private final IndexResolver indexResolver;
    private final PreAnalyzer preAnalyzer;
    private final Verifier verifier;
    private final Optimizer optimizer;
    private final Planner planner;
    private final Metrics metrics;

    public PlanExecutor(Client client, IndexResolver indexResolver, NamedWriteableRegistry writeableRegistry) {
        this.client = client;
        this.writableRegistry = writeableRegistry;
        this.indexResolver = indexResolver;
        this.functionRegistry = new FunctionRegistry();
        this.metrics = new Metrics();
        this.preAnalyzer = new PreAnalyzer();
        this.verifier = new Verifier(this.metrics);
        this.optimizer = new Optimizer();
        this.planner = new Planner();
    }

    private SqlSession newSession(Configuration cfg) {
        return new SqlSession(cfg, this.client, this.functionRegistry, this.indexResolver, this.preAnalyzer, this.verifier, this.optimizer, this.planner, this);
    }

    public void searchSource(Configuration cfg, String sql, List<SqlTypedParamValue> params, ActionListener<SearchSourceBuilder> listener) {
        this.metrics.translate();
        this.newSession(cfg).sqlExecutable(sql, params, (ActionListener<PhysicalPlan>)ActionListener.wrap(exec -> {
            if (exec instanceof EsQueryExec) {
                EsQueryExec e = (EsQueryExec)exec;
                listener.onResponse((Object)SourceGenerator.sourceBuilder(e.queryContainer(), cfg.filter(), cfg.pageSize()));
            } else {
                String message = null;
                message = exec instanceof LocalExec ? "Cannot generate a query DSL for an SQL query that either its WHERE clause evaluates to FALSE or doesn't operate on a table (missing a FROM clause)" : (exec instanceof CommandExec ? "Cannot generate a query DSL for a special SQL command (e.g.: DESCRIBE, SHOW)" : "Cannot generate a query DSL");
                listener.onFailure((Exception)((Object)new PlanningException(message + ", sql statement: [{}]", sql)));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void sql(Configuration cfg, String sql, List<SqlTypedParamValue> params, ActionListener<Cursor.Page> listener) {
        QueryMetric metric = QueryMetric.from(cfg.mode(), cfg.clientId());
        this.metrics.total(metric);
        this.newSession(cfg).sql(sql, params, (ActionListener<Cursor.Page>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), ex -> {
            this.metrics.failed(metric);
            listener.onFailure(ex);
        }));
    }

    public void nextPage(Configuration cfg, Cursor cursor, ActionListener<Cursor.Page> listener) {
        QueryMetric metric = QueryMetric.from(cfg.mode(), cfg.clientId());
        this.metrics.total(metric);
        this.metrics.paging(metric);
        cursor.nextPage(cfg, this.client, this.writableRegistry, (ActionListener<Cursor.Page>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), ex -> {
            this.metrics.failed(metric);
            listener.onFailure(ex);
        }));
    }

    public void cleanCursor(Configuration cfg, Cursor cursor, ActionListener<Boolean> listener) {
        cursor.clear(cfg, this.client, listener);
    }

    public Metrics metrics() {
        return this.metrics;
    }
}

