/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.analysis.analyzer.VerificationException;
import org.elasticsearch.xpack.sql.analysis.analyzer.Verifier;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.expression.SubQueryExpression;
import org.elasticsearch.xpack.sql.expression.UnresolvedAlias;
import org.elasticsearch.xpack.sql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.sql.expression.UnresolvedStar;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.sql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.sql.expression.function.Functions;
import org.elasticsearch.xpack.sql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.sql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.Aggregate;
import org.elasticsearch.xpack.sql.plan.logical.EsRelation;
import org.elasticsearch.xpack.sql.plan.logical.Filter;
import org.elasticsearch.xpack.sql.plan.logical.Join;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.OrderBy;
import org.elasticsearch.xpack.sql.plan.logical.Project;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.sql.plan.logical.With;
import org.elasticsearch.xpack.sql.rule.Rule;
import org.elasticsearch.xpack.sql.rule.RuleExecutor;
import org.elasticsearch.xpack.sql.session.Configuration;
import org.elasticsearch.xpack.sql.tree.Node;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.type.InvalidMappedField;
import org.elasticsearch.xpack.sql.type.UnsupportedEsField;
import org.elasticsearch.xpack.sql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.util.Holder;

public class Analyzer
extends RuleExecutor<LogicalPlan> {
    private final FunctionRegistry functionRegistry;
    private final IndexResolution indexResolution;
    private final Configuration configuration;
    private final Verifier verifier;

    public Analyzer(Configuration configuration, FunctionRegistry functionRegistry, IndexResolution results, Verifier verifier) {
        this.configuration = configuration;
        this.functionRegistry = functionRegistry;
        this.indexResolution = results;
        this.verifier = verifier;
    }

    @Override
    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch substitution = (RuleExecutor)this.new RuleExecutor.Batch("Substitution", new CTESubstitution());
        RuleExecutor.Batch resolution = (RuleExecutor)this.new RuleExecutor.Batch("Resolution", new ResolveTable(), new ResolveRefs(), new ResolveOrdinalInOrderByAndGroupBy(), new ResolveMissingRefs(), new ResolveFilterRefs(), new ResolveFunctions(), new ResolveAliases(), new ProjectedAggregations(), new HavingOverProject(), new ResolveAggsInHaving(), new ResolveAggsInOrderBy());
        RuleExecutor.Batch finish = (RuleExecutor)this.new RuleExecutor.Batch("Finish Analysis", new PruneSubqueryAliases(), CleanAliases.INSTANCE);
        return Arrays.asList(substitution, resolution, finish);
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        return this.analyze(plan, true);
    }

    public LogicalPlan analyze(LogicalPlan plan, boolean verify) {
        if (plan.analyzed()) {
            return plan;
        }
        return verify ? this.verify(this.execute(plan)) : this.execute(plan);
    }

    public RuleExecutor.ExecutionInfo debugAnalyze(LogicalPlan plan) {
        return plan.analyzed() ? null : this.executeWithInfo(plan);
    }

    public LogicalPlan verify(LogicalPlan plan) {
        Collection<Verifier.Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    private static <E extends Expression> E resolveExpression(E expression, LogicalPlan plan) {
        return (E)expression.transformUp(e -> {
            if (e instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)e;
                Attribute a = Analyzer.resolveAgainstList(ua, plan.output());
                return a != null ? a : e;
            }
            return e;
        });
    }

    private static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList) {
        return Analyzer.resolveAgainstList(u, attrList, false);
    }

    private static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, boolean allowCompound) {
        ArrayList<Attribute> matches = new ArrayList<Attribute>();
        boolean qualified = u.qualifier() != null;
        for (Attribute attribute : attrList) {
            boolean match;
            if (attribute.synthetic() || !(match = qualified ? Objects.equals(u.qualifiedName(), attribute.qualifiedName()) : Objects.equals(u.name(), attribute.name()) || Objects.equals(u.name(), attribute.qualifiedName()))) continue;
            matches.add(attribute.withLocation(u.source()));
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return Analyzer.handleSpecialFields(u, (Attribute)matches.get(0), allowCompound);
        }
        return u.withUnresolvedMessage("Reference [" + u.qualifiedName() + "] is ambiguous (to disambiguate use quotes or qualifiers); matches any of " + matches.stream().map(a -> "\"" + a.qualifier() + "\".\"" + a.name() + "\"").sorted().collect(Collectors.toList()));
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named, boolean allowCompound) {
        if (named instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)named;
            if (fa.field() instanceof InvalidMappedField) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + ((InvalidMappedField)fa.field()).errorMessage());
            } else if (DataTypes.isUnsupported(fa.dataType())) {
                UnsupportedEsField unsupportedField = (UnsupportedEsField)fa.field();
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + unsupportedField.getOriginalType() + "] as is unsupported");
            } else if (!allowCompound && !fa.dataType().isPrimitive()) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName + "] only its subfields");
            }
        }
        return named;
    }

    private static boolean hasStar(List<? extends Expression> exprs) {
        for (Expression expression : exprs) {
            if (!(expression instanceof UnresolvedStar)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAggregate(List<? extends Expression> list) {
        return Expressions.anyMatch(list, Functions::isAggregate);
    }

    private static boolean containsAggregate(Expression exp) {
        return Analyzer.containsAggregate(Collections.singletonList(exp));
    }

    static abstract class AnalyzeRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        AnalyzeRule() {
        }

        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return plan.transformUp(t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule((SubPlan)t), this.typeToken());
        }

        @Override
        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static class CleanAliases
    extends AnalyzeRule<LogicalPlan> {
        public static final CleanAliases INSTANCE = new CleanAliases();

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (plan instanceof Project) {
                Project p = (Project)plan;
                return new Project(p.source(), p.child(), this.cleanSecondaryAliases(p.projections()));
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                return new Aggregate(a.source(), a.child(), this.cleanAllAliases(a.groupings()), this.cleanSecondaryAliases(a.aggregates()));
            }
            return (LogicalPlan)plan.transformExpressionsOnly(e -> {
                if (e instanceof Alias) {
                    return ((Alias)e).child();
                }
                return e;
            });
        }

        private List<NamedExpression> cleanSecondaryAliases(List<? extends NamedExpression> args) {
            ArrayList<NamedExpression> cleaned = new ArrayList<NamedExpression>(args.size());
            for (NamedExpression namedExpression : args) {
                cleaned.add((NamedExpression)CleanAliases.trimNonTopLevelAliases(namedExpression));
            }
            return cleaned;
        }

        private List<Expression> cleanAllAliases(List<Expression> args) {
            ArrayList<Expression> cleaned = new ArrayList<Expression>(args.size());
            for (Expression e : args) {
                cleaned.add(CleanAliases.trimAliases(e));
            }
            return cleaned;
        }

        public static Expression trimNonTopLevelAliases(Expression e) {
            if (e instanceof Alias) {
                Alias a = (Alias)e;
                return new Alias(a.source(), a.name(), a.qualifier(), CleanAliases.trimAliases(a.child()), a.id());
            }
            return CleanAliases.trimAliases(e);
        }

        private static Expression trimAliases(Expression e) {
            return e.transformDown(Alias::child, Alias.class);
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    public static class PruneSubqueryAliases
    extends AnalyzeRule<SubQueryAlias> {
        @Override
        protected LogicalPlan rule(SubQueryAlias alias) {
            return alias.child();
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    private class ImplicitCasting
    extends AnalyzeRule<LogicalPlan> {
        private ImplicitCasting() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsDown(this::implicitCast);
        }

        private Expression implicitCast(Expression e) {
            DataType r;
            DataType l;
            if (!e.childrenResolved()) {
                return e;
            }
            Expression left = null;
            Expression right = null;
            if (e instanceof ArithmeticOperation) {
                ArithmeticOperation f = (ArithmeticOperation)e;
                left = f.left();
                right = f.right();
            }
            if (left != null && (l = left.dataType()) != (r = right.dataType())) {
                DataType common = DataTypeConversion.commonType(l, r);
                if (common == null) {
                    return e;
                }
                left = l == common ? left : new Cast(left.source(), left, common);
                right = r == common ? right : new Cast(right.source(), right, common);
                return e.replaceChildren(Arrays.asList(left, right));
            }
            return e;
        }
    }

    private class PruneDuplicateFunctions
    extends AnalyzeRule<LogicalPlan> {
        private PruneDuplicateFunctions() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        public LogicalPlan rule(LogicalPlan plan) {
            ArrayList seen = new ArrayList();
            LogicalPlan p = (LogicalPlan)plan.transformExpressionsUp(e -> this.rule((Expression)e, seen));
            return p;
        }

        private Expression rule(Expression e, List<Function> seen) {
            if (e instanceof Function) {
                Function f = (Function)e;
                for (Function seenFunction : seen) {
                    if (seenFunction == f || !this.functionsEquals(f, seenFunction)) continue;
                    return seenFunction;
                }
                seen.add(f);
            }
            return e;
        }

        private boolean functionsEquals(Function f, Function seenFunction) {
            return f.sourceText().equals(seenFunction.sourceText()) && f.arguments().equals(seenFunction.arguments());
        }
    }

    private static class ResolveAggsInOrderBy
    extends AnalyzeRule<OrderBy> {
        private ResolveAggsInOrderBy() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(OrderBy ob) {
            List<Order> orders = ob.order();
            ArrayList<NamedExpression> aggs = new ArrayList<NamedExpression>();
            for (Order order : orders) {
                if (!Functions.isAggregate(order.child())) continue;
                aggs.add(Expressions.wrapAsNamed(order.child()));
            }
            if (aggs.isEmpty()) {
                return ob;
            }
            Holder<Boolean> found = new Holder<Boolean>(Boolean.FALSE);
            LogicalPlan plan = ob.transformDown(a -> {
                if (found.get() == Boolean.FALSE) {
                    found.set(Boolean.TRUE);
                    ArrayList<NamedExpression> missing = new ArrayList<NamedExpression>();
                    for (NamedExpression orderedAgg : aggs) {
                        if (Expressions.anyMatch(a.aggregates(), e -> Expressions.equalsAsAttribute(e, orderedAgg))) continue;
                        missing.add(orderedAgg);
                    }
                    if (!missing.isEmpty()) {
                        return new Aggregate(a.source(), a.child(), a.groupings(), CollectionUtils.combine(a.aggregates(), missing));
                    }
                }
                return a;
            }, Aggregate.class);
            if (plan != ob) {
                return new Project(ob.source(), plan, ob.output());
            }
            return ob;
        }
    }

    private class ResolveAggsInHaving
    extends AnalyzeRule<Filter> {
        private ResolveAggsInHaving() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(Filter f) {
            if (f.child() instanceof Aggregate && f.child().resolved()) {
                Aggregate agg = (Aggregate)f.child();
                Set<NamedExpression> missing = null;
                Expression condition = f.condition();
                if (!condition.resolved()) {
                    Aggregate tryResolvingCondition = new Aggregate(agg.source(), agg.child(), agg.groupings(), CollectionUtils.combine(agg.aggregates(), new Alias(f.source(), ".having", condition)));
                    if ((tryResolvingCondition = (Aggregate)Analyzer.this.analyze(tryResolvingCondition, false)).resolved()) {
                        condition = ((Alias)tryResolvingCondition.aggregates().get(tryResolvingCondition.aggregates().size() - 1)).child();
                    } else {
                        return f;
                    }
                }
                if (!(missing = this.findMissingAggregate(agg, condition)).isEmpty()) {
                    Aggregate newAgg = new Aggregate(agg.source(), agg.child(), agg.groupings(), CollectionUtils.combine(new Collection[]{agg.aggregates(), missing}));
                    Filter newFilter = new Filter(f.source(), newAgg, condition);
                    return new Project(f.source(), newFilter, f.output());
                }
                return new Filter(f.source(), f.child(), condition);
            }
            return f;
        }

        private Set<NamedExpression> findMissingAggregate(Aggregate target, Expression from) {
            LinkedHashSet<NamedExpression> missing = new LinkedHashSet<NamedExpression>();
            for (Expression filterAgg : from.collect(Functions::isAggregate)) {
                if (Expressions.anyMatch(target.aggregates(), a -> {
                    Attribute attr = Expressions.attribute(a);
                    return attr != null && attr.semanticEquals(Expressions.attribute(filterAgg));
                })) continue;
                missing.add(Expressions.wrapAsNamed(filterAgg));
            }
            return missing;
        }
    }

    private static class HavingOverProject
    extends AnalyzeRule<Filter> {
        private HavingOverProject() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected LogicalPlan rule(Filter f) {
            if (f.child() instanceof Project) {
                Project p = (Project)f.child();
                for (Expression expression : p.projections()) {
                    void var4_4;
                    if (expression instanceof Alias) {
                        Expression expression2 = ((Alias)expression).child();
                    }
                    if (var4_4.foldable() || Functions.isAggregate((Expression)var4_4) || !var4_4.anyMatch(e -> e instanceof FieldAttribute)) continue;
                    return f;
                }
                if (Analyzer.containsAggregate(f.condition())) {
                    return new Filter(f.source(), new Aggregate(p.source(), p.child(), Collections.emptyList(), p.projections()), f.condition());
                }
            }
            return f;
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }

    private static class ProjectedAggregations
    extends AnalyzeRule<Project> {
        private ProjectedAggregations() {
        }

        @Override
        protected LogicalPlan rule(Project p) {
            if (Analyzer.containsAggregate(p.projections())) {
                return new Aggregate(p.source(), p.child(), Collections.emptyList(), p.projections());
            }
            return p;
        }
    }

    private static class ResolveAliases
    extends AnalyzeRule<LogicalPlan> {
        private ResolveAliases() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (plan instanceof Project) {
                Project p = (Project)plan;
                if (p.childrenResolved() && this.hasUnresolvedAliases(p.projections())) {
                    return new Project(p.source(), p.child(), this.assignAliases(p.projections()));
                }
                return p;
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (a.childrenResolved() && this.hasUnresolvedAliases(a.aggregates())) {
                    return new Aggregate(a.source(), a.child(), a.groupings(), this.assignAliases(a.aggregates()));
                }
                return a;
            }
            return plan;
        }

        private boolean hasUnresolvedAliases(List<? extends NamedExpression> expressions) {
            return expressions != null && expressions.stream().anyMatch(e -> e instanceof UnresolvedAlias);
        }

        private List<NamedExpression> assignAliases(List<? extends NamedExpression> exprs) {
            ArrayList<NamedExpression> newExpr = new ArrayList<NamedExpression>(exprs.size());
            for (int i = 0; i < exprs.size(); ++i) {
                NamedExpression transformed;
                NamedExpression expr = exprs.get(i);
                newExpr.add(expr.equals(transformed = (NamedExpression)expr.transformUp(ua -> {
                    Cast c;
                    Expression child = ua.child();
                    if (child instanceof NamedExpression) {
                        return child;
                    }
                    if (!child.resolved()) {
                        return ua;
                    }
                    if (child instanceof Cast && (c = (Cast)child).field() instanceof NamedExpression) {
                        return new Alias(c.source(), ((NamedExpression)c.field()).name(), c);
                    }
                    return new Alias(child.source(), child.sourceText(), child);
                }, UnresolvedAlias.class)) ? expr : transformed);
            }
            return newExpr;
        }
    }

    private class ResolveFunctions
    extends AnalyzeRule<LogicalPlan> {
        private ResolveFunctions() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            LinkedHashMap<String, List<Function>> seen = new LinkedHashMap<String, List<Function>>();
            LogicalPlan p = (LogicalPlan)plan.transformExpressionsUp(e -> this.collectResolvedAndReplace((Expression)e, (Map<String, List<Function>>)seen));
            return this.resolve(p, seen);
        }

        private Expression collectResolvedAndReplace(Expression e, Map<String, List<Function>> seen) {
            if (e instanceof Function && e.resolved()) {
                Function f = (Function)e;
                String fName = f.functionName();
                List<Function> list = this.getList(seen, fName);
                for (Function seenFunction : list) {
                    if (seenFunction == f || !f.arguments().equals(seenFunction.arguments())) continue;
                    if (seenFunction instanceof Count || seenFunction instanceof RegexMatch) {
                        if (!seenFunction.equals(f)) continue;
                        return seenFunction;
                    }
                    return seenFunction;
                }
                list.add(f);
            }
            return e;
        }

        protected LogicalPlan resolve(LogicalPlan plan, Map<String, List<Function>> seen) {
            return (LogicalPlan)plan.transformExpressionsUp(e -> {
                if (e instanceof UnresolvedFunction) {
                    UnresolvedFunction uf = (UnresolvedFunction)e;
                    if (uf.analyzed()) {
                        return uf;
                    }
                    String name = uf.name();
                    if (Analyzer.hasStar(uf.arguments()) && (uf = uf.preprocessStar()).analyzed()) {
                        return uf;
                    }
                    if (!uf.childrenResolved()) {
                        return uf;
                    }
                    String functionName = Analyzer.this.functionRegistry.resolveAlias(name);
                    List<Function> list = this.getList(seen, functionName);
                    if (!list.isEmpty()) {
                        for (Function seenFunction : list) {
                            if (!uf.arguments().equals(seenFunction.arguments())) continue;
                            if (seenFunction instanceof Count) {
                                if (!uf.sameAs((Count)seenFunction)) continue;
                                return seenFunction;
                            }
                            return seenFunction;
                        }
                    }
                    if (!Analyzer.this.functionRegistry.functionExists(functionName)) {
                        return uf.missing(functionName, Analyzer.this.functionRegistry.listFunctions());
                    }
                    FunctionDefinition def = Analyzer.this.functionRegistry.resolveFunction(functionName);
                    Function f = uf.buildResolved(Analyzer.this.configuration, def);
                    list.add(f);
                    return f;
                }
                return e;
            });
        }

        private List<Function> getList(Map<String, List<Function>> seen, String name) {
            List<Function> list = seen.get(name);
            if (list == null) {
                list = new ArrayList<Function>();
                seen.put(name, list);
            }
            return list;
        }
    }

    private class ResolveFilterRefs
    extends AnalyzeRule<LogicalPlan> {
        private ResolveFilterRefs() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            Aggregate a;
            Expression newCondition;
            Filter f;
            Expression condition;
            Project p;
            if (plan instanceof Project && (p = (Project)plan).child() instanceof Filter && !(condition = (f = (Filter)p.child()).condition()).resolved() && f.childrenResolved() && (newCondition = this.replaceAliases(condition, p.projections())) != condition) {
                return new Project(p.source(), new Filter(f.source(), f.child(), newCondition), p.projections());
            }
            if (plan instanceof Aggregate && (a = (Aggregate)plan).child() instanceof Filter && !(condition = (f = (Filter)a.child()).condition()).resolved() && f.childrenResolved() && (newCondition = this.replaceAliases(condition, a.aggregates())) != condition) {
                return new Aggregate(a.source(), new Filter(f.source(), f.child(), newCondition), a.groupings(), a.aggregates());
            }
            return plan;
        }

        private Expression replaceAliases(Expression condition, List<? extends NamedExpression> named) {
            ArrayList aliases = new ArrayList();
            named.forEach(n -> {
                if (n instanceof Alias) {
                    aliases.add((Alias)n);
                }
            });
            return condition.transformDown(u -> {
                boolean qualified = u.qualifier() != null;
                for (Alias alias : aliases) {
                    if (!(qualified ? Objects.equals(alias.qualifiedName(), u.qualifiedName()) : Objects.equals(alias.name(), u.name()))) continue;
                    return alias;
                }
                return u;
            }, UnresolvedAttribute.class);
        }
    }

    private static class ResolveMissingRefs
    extends AnalyzeRule<LogicalPlan> {
        private ResolveMissingRefs() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            AttributeSet missing;
            AttributeSet resolvedRefs;
            Object maybeResolved;
            if (plan instanceof OrderBy && !plan.resolved() && plan.childrenResolved()) {
                OrderBy o = (OrderBy)plan;
                maybeResolved = o.order().stream().map(or -> ResolveMissingRefs.tryResolveExpression(or, o.child())).collect(Collectors.toList());
                resolvedRefs = Expressions.references(maybeResolved.stream().filter(Expression::resolved).collect(Collectors.toList()));
                missing = resolvedRefs.subtract(o.child().outputSet());
                if (!missing.isEmpty()) {
                    ArrayList<Attribute> failedAttrs = new ArrayList<Attribute>();
                    LogicalPlan newChild = ResolveMissingRefs.propagateMissing(o.child(), missing, failedAttrs);
                    if (!failedAttrs.isEmpty()) {
                        ArrayList<Order> newOrders = new ArrayList<Order>();
                        for (Order order : o.order()) {
                            Order transformed;
                            newOrders.add(order.equals(transformed = (Order)order.transformUp(ua -> ResolveMissingRefs.resolveMetadataToMessage(ua, failedAttrs, "order"), UnresolvedAttribute.class)) ? order : transformed);
                        }
                        return o.order().equals(newOrders) ? o : new OrderBy(o.source(), o.child(), newOrders);
                    }
                    return new Project(o.source(), new OrderBy(o.source(), newChild, (List<Order>)maybeResolved), o.child().output());
                }
                if (!maybeResolved.equals(o.order())) {
                    return new OrderBy(o.source(), o.child(), (List<Order>)maybeResolved);
                }
            }
            if (plan instanceof Filter && !plan.resolved() && plan.childrenResolved()) {
                Filter f = (Filter)plan;
                maybeResolved = ResolveMissingRefs.tryResolveExpression(f.condition(), f.child());
                resolvedRefs = new AttributeSet(((Expression)maybeResolved).references().stream().filter(Expression::resolved).collect(Collectors.toList()));
                missing = resolvedRefs.subtract(f.child().outputSet());
                if (!missing.isEmpty()) {
                    ArrayList<Attribute> failedAttrs = new ArrayList<Attribute>();
                    LogicalPlan newChild = ResolveMissingRefs.propagateMissing(f.child(), missing, failedAttrs);
                    if (!failedAttrs.isEmpty()) {
                        Expression transformed = f.condition().transformUp(ua -> ResolveMissingRefs.resolveMetadataToMessage(ua, failedAttrs, "filter"), UnresolvedAttribute.class);
                        return f.condition().equals(transformed) ? f : new Filter(f.source(), f.child(), transformed);
                    }
                    return new Project(f.source(), new Filter(f.source(), newChild, (Expression)maybeResolved), f.child().output());
                }
                if (!((Node)maybeResolved).equals(f.condition())) {
                    return new Filter(f.source(), f.child(), (Expression)maybeResolved);
                }
            }
            return plan;
        }

        static <E extends Expression> E tryResolveExpression(E exp, LogicalPlan plan) {
            Expression resolved = Analyzer.resolveExpression(exp, plan);
            if (!resolved.resolved() && plan.children().size() == 1 && !(plan instanceof SubQueryAlias)) {
                return (E)ResolveMissingRefs.tryResolveExpression(resolved, (LogicalPlan)plan.children().get(0));
            }
            return (E)resolved;
        }

        private static LogicalPlan propagateMissing(LogicalPlan plan, AttributeSet missing, List<Attribute> failed) {
            if (missing.isEmpty()) {
                return plan;
            }
            if (plan instanceof Project) {
                Project p = (Project)plan;
                AttributeSet diff = missing.subtract(p.child().outputSet());
                return new Project(p.source(), ResolveMissingRefs.propagateMissing(p.child(), diff, failed), CollectionUtils.combine(new Collection[]{p.projections(), missing}));
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                for (Attribute m : missing) {
                    if (Expressions.anyMatch(a.groupings(), m::semanticEquals)) continue;
                    if (m instanceof Attribute) {
                        m = new UnresolvedAttribute(m.source(), m.name(), m.qualifier(), null, null, new AggGroupingFailure(Expressions.names(a.groupings())));
                    }
                    failed.add(m);
                }
                if (!failed.isEmpty()) {
                    return plan;
                }
                return new Aggregate(a.source(), a.child(), a.groupings(), CollectionUtils.combine(new Collection[]{a.aggregates(), missing}));
            }
            if (plan instanceof UnaryPlan) {
                return plan.replaceChildren(Collections.singletonList(ResolveMissingRefs.propagateMissing(((UnaryPlan)plan).child(), missing, failed)));
            }
            failed.addAll(missing);
            return plan;
        }

        private static UnresolvedAttribute resolveMetadataToMessage(UnresolvedAttribute ua, List<Attribute> attrs, String actionName) {
            for (Attribute attr : attrs) {
                UnresolvedAttribute fua;
                Object metadata;
                if (ua.resolutionMetadata() != null || !attr.name().equals(ua.name()) || !(attr instanceof UnresolvedAttribute) || !((metadata = (fua = (UnresolvedAttribute)attr).resolutionMetadata()) instanceof AggGroupingFailure)) continue;
                List<String> names = ((AggGroupingFailure)metadata).expectedGrouping;
                return ua.withUnresolvedMessage("Cannot " + actionName + " by non-grouped column [" + ua.qualifiedName() + "], expected " + names);
            }
            return ua;
        }

        private static class AggGroupingFailure {
            final List<String> expectedGrouping;

            private AggGroupingFailure(List<String> expectedGrouping) {
                this.expectedGrouping = expectedGrouping;
            }
        }
    }

    private static class ResolveOrdinalInOrderByAndGroupBy
    extends AnalyzeRule<LogicalPlan> {
        private ResolveOrdinalInOrderByAndGroupBy() {
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            if (plan instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)plan;
                boolean changed = false;
                ArrayList<Order> newOrder = new ArrayList<Order>(orderBy.order().size());
                List<Attribute> ordinalReference = orderBy.child().output();
                int max = ordinalReference.size();
                for (Order order : orderBy.order()) {
                    Expression child = order.child();
                    Integer ordinal = this.findOrdinal(order.child());
                    if (ordinal != null) {
                        changed = true;
                        if (ordinal > 0 && ordinal <= max) {
                            newOrder.add(new Order(order.source(), orderBy.child().output().get(ordinal - 1), order.direction(), order.nullsPosition()));
                            continue;
                        }
                        String message = LoggerMessageFormat.format((String)"Invalid ordinal [{}] specified in [{}] (valid range is [1, {}])", (Object[])new Object[]{ordinal, orderBy.sourceText(), max});
                        UnresolvedAttribute ua = new UnresolvedAttribute(child.source(), orderBy.sourceText(), null, message);
                        newOrder.add(new Order(order.source(), ua, order.direction(), order.nullsPosition()));
                        continue;
                    }
                    newOrder.add(order);
                }
                return changed ? new OrderBy(orderBy.source(), orderBy.child(), newOrder) : orderBy;
            }
            if (plan instanceof Aggregate) {
                Aggregate agg = (Aggregate)plan;
                if (!Resolvables.resolved(agg.aggregates())) {
                    return agg;
                }
                boolean changed = false;
                ArrayList<Expression> newGroupings = new ArrayList<Expression>(agg.groupings().size());
                List<? extends NamedExpression> aggregates = agg.aggregates();
                int max = aggregates.size();
                for (Expression exp : agg.groupings()) {
                    Integer ordinal = this.findOrdinal(exp);
                    if (ordinal != null) {
                        changed = true;
                        String errorMessage = null;
                        if (ordinal > 0 && ordinal <= max) {
                            NamedExpression reference = aggregates.get(ordinal - 1);
                            if (Analyzer.containsAggregate(reference)) {
                                errorMessage = LoggerMessageFormat.format((String)"Ordinal [{}] in [{}] refers to an invalid argument, aggregate function [{}]", (Object[])new Object[]{ordinal, agg.sourceText(), reference.sourceText()});
                            } else {
                                newGroupings.add(reference);
                            }
                        } else {
                            errorMessage = LoggerMessageFormat.format((String)"Invalid ordinal [{}] specified in [{}] (valid range is [1, {}])", (Object[])new Object[]{ordinal, agg.sourceText(), max});
                        }
                        if (errorMessage == null) continue;
                        newGroupings.add(new UnresolvedAttribute(exp.source(), agg.sourceText(), null, errorMessage));
                        continue;
                    }
                    newGroupings.add(exp);
                }
                return changed ? new Aggregate(agg.source(), agg.child(), newGroupings, aggregates) : agg;
            }
            return plan;
        }

        private Integer findOrdinal(Expression expression) {
            Object v;
            if (expression.foldable() && expression.dataType().isInteger() && (v = Foldables.valueOf(expression)) instanceof Number) {
                return ((Number)v).intValue();
            }
            return null;
        }
    }

    private static class ResolveRefs
    extends AnalyzeRule<LogicalPlan> {
        private ResolveRefs() {
        }

        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            OrderBy o;
            if (!plan.childrenResolved()) {
                return plan;
            }
            if (plan instanceof Project) {
                Project p = (Project)plan;
                if (Analyzer.hasStar(p.projections())) {
                    return new Project(p.source(), p.child(), this.expandProjections(p.projections(), p.child()));
                }
            } else if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (Analyzer.hasStar(a.aggregates())) {
                    return new Aggregate(a.source(), a.child(), a.groupings(), this.expandProjections(a.aggregates(), a.child()));
                }
                if (!a.expressionsResolved() && Resolvables.resolved(a.aggregates())) {
                    List<Expression> groupings = a.groupings();
                    ArrayList<Expression> newGroupings = new ArrayList<Expression>();
                    AttributeMap<Expression> resolved = Expressions.asAttributeMap(a.aggregates());
                    boolean changed = false;
                    for (Expression grouping : groupings) {
                        Attribute maybeResolved;
                        if (grouping instanceof UnresolvedAttribute && (maybeResolved = Analyzer.resolveAgainstList((UnresolvedAttribute)grouping, resolved.keySet())) != null) {
                            changed = true;
                            grouping = resolved.get(maybeResolved);
                        }
                        newGroupings.add(grouping);
                    }
                    return changed ? new Aggregate(a.source(), a.child(), newGroupings, a.aggregates()) : a;
                }
            } else if (plan instanceof Join) {
                Join j = (Join)plan;
                if (!j.duplicatesResolved()) {
                    LogicalPlan deduped = this.dedupRight(j.left(), j.right());
                    return new Join(j.source(), j.left(), deduped, j.type(), j.condition());
                }
            } else if (plan instanceof OrderBy && !(o = (OrderBy)plan).resolved()) {
                List<Order> resolvedOrder = o.order().stream().map(or -> (Order)Analyzer.resolveExpression(or, o.child())).collect(Collectors.toList());
                return new OrderBy(o.source(), o.child(), resolvedOrder);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to resolve {}", (Object)plan.nodeString());
            }
            return (LogicalPlan)plan.transformExpressionsUp(e -> {
                if (e instanceof UnresolvedAttribute) {
                    UnresolvedAttribute u = (UnresolvedAttribute)e;
                    ArrayList<Attribute> childrenOutput = new ArrayList<Attribute>();
                    for (LogicalPlan child : plan.children()) {
                        childrenOutput.addAll(child.output());
                    }
                    Attribute named = Analyzer.resolveAgainstList(u, childrenOutput);
                    if (named != null) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Resolved {} to {}", (Object)u, (Object)named);
                        }
                        return named;
                    }
                }
                return e;
            });
        }

        private List<NamedExpression> expandProjections(List<? extends NamedExpression> projections, LogicalPlan child) {
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            List<Attribute> output = child.output();
            for (NamedExpression namedExpression : projections) {
                if (namedExpression instanceof UnresolvedStar) {
                    List<NamedExpression> expanded = this.expandStar((UnresolvedStar)namedExpression, output);
                    if (expanded.isEmpty()) {
                        result.add(namedExpression);
                        continue;
                    }
                    result.addAll(expanded);
                    continue;
                }
                if (namedExpression instanceof UnresolvedAlias) {
                    UnresolvedAlias ua = (UnresolvedAlias)namedExpression;
                    if (!(ua.child() instanceof UnresolvedStar)) continue;
                    result.addAll(this.expandStar((UnresolvedStar)ua.child(), output));
                    continue;
                }
                result.add(namedExpression);
            }
            return result;
        }

        private List<NamedExpression> expandStar(UnresolvedStar us, List<Attribute> output) {
            ArrayList<NamedExpression> expanded = new ArrayList<NamedExpression>();
            if (us.qualifier() != null) {
                Attribute q = Analyzer.resolveAgainstList(us.qualifier(), output, true);
                if (q == null) {
                    return Collections.singletonList(us.qualifier());
                }
                if (!q.resolved()) {
                    return Collections.singletonList(q);
                }
                for (Attribute attr : output) {
                    FieldAttribute fa;
                    if (!(attr instanceof FieldAttribute) || DataTypes.isUnsupported((fa = (FieldAttribute)attr).dataType())) continue;
                    if (q.qualifier() != null) {
                        if (!Objects.equals(q.qualifiedName(), fa.qualifiedPath())) continue;
                        expanded.add(fa.withLocation(attr.source()));
                        continue;
                    }
                    if (!Objects.equals(q.name(), fa.path())) continue;
                    expanded.add(fa.withLocation(attr.source()));
                }
            } else {
                LinkedHashSet<Attribute> seenMultiFields = new LinkedHashSet<Attribute>();
                for (Attribute a : output) {
                    if (DataTypes.isUnsupported(a.dataType()) || !a.dataType().isPrimitive()) continue;
                    if (a instanceof FieldAttribute) {
                        FieldAttribute fa = (FieldAttribute)a;
                        if (fa.isNested() || seenMultiFields.contains(fa.parent())) continue;
                        expanded.add(a);
                        seenMultiFields.add(a);
                        continue;
                    }
                    expanded.add(a);
                }
            }
            return expanded;
        }

        private LogicalPlan dedupRight(LogicalPlan left, LogicalPlan right) {
            AttributeSet conflicting = left.outputSet().intersect(right.outputSet());
            if (this.log.isTraceEnabled()) {
                this.log.trace("Trying to resolve conflicts " + conflicting + " between left " + left.nodeString() + " and right " + right.nodeString());
            }
            throw new UnsupportedOperationException("don't know how to resolve conficting IDs yet");
        }
    }

    private class ResolveTable
    extends AnalyzeRule<UnresolvedRelation> {
        private ResolveTable() {
        }

        @Override
        protected LogicalPlan rule(UnresolvedRelation plan) {
            TableIdentifier table = plan.table();
            if (!Analyzer.this.indexResolution.isValid()) {
                return plan.unresolvedMessage().equals(Analyzer.this.indexResolution.toString()) ? plan : new UnresolvedRelation(plan.source(), plan.table(), plan.alias(), plan.frozen(), Analyzer.this.indexResolution.toString());
            }
            assert (Analyzer.this.indexResolution.matches(table.index()));
            EsRelation logicalPlan = new EsRelation(plan.source(), Analyzer.this.indexResolution.get(), plan.frozen());
            SubQueryAlias sa = new SubQueryAlias(plan.source(), logicalPlan, table.index());
            if (plan.alias() != null) {
                sa = new SubQueryAlias(plan.source(), sa, plan.alias());
            }
            return sa;
        }
    }

    private static class CTESubstitution
    extends AnalyzeRule<With> {
        private CTESubstitution() {
        }

        @Override
        protected LogicalPlan rule(With plan) {
            return this.substituteCTE(plan.child(), plan.subQueries());
        }

        private LogicalPlan substituteCTE(LogicalPlan p, Map<String, SubQueryAlias> subQueries) {
            if (p instanceof UnresolvedRelation) {
                UnresolvedRelation ur = (UnresolvedRelation)p;
                SubQueryAlias subQueryAlias = subQueries.get(ur.table().index());
                if (subQueryAlias != null) {
                    if (ur.alias() != null) {
                        return new SubQueryAlias(ur.source(), subQueryAlias, ur.alias());
                    }
                    return subQueryAlias;
                }
                return ur;
            }
            if (p instanceof LocalRelation) {
                return p;
            }
            return (LogicalPlan)p.transformExpressionsDown(e -> {
                if (e instanceof SubQueryExpression) {
                    SubQueryExpression sq = (SubQueryExpression)e;
                    return sq.withQuery(this.substituteCTE(sq.query(), subQueries));
                }
                return e;
            });
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }
}

