/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

abstract class KeyConfig
extends TrustConfig {
    static final KeyConfig NONE = new KeyConfig(){

        @Override
        X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
            return null;
        }

        @Override
        X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
            return null;
        }

        @Override
        Collection<CertificateInfo> certificates(Environment environment) {
            return Collections.emptyList();
        }

        @Override
        List<Path> filesToMonitor(@Nullable Environment environment) {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            return "NONE";
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        List<PrivateKey> privateKeys(@Nullable Environment environment) {
            return Collections.emptyList();
        }
    };

    KeyConfig() {
    }

    abstract X509ExtendedKeyManager createKeyManager(@Nullable Environment var1);

    static ElasticsearchException missingKeyConfigFile(IOException cause, String fileType, Path path) {
        return new ElasticsearchException("failed to initialize SSL KeyManager - " + fileType + " file [{}] does not exist", (Throwable)cause, new Object[]{path.toAbsolutePath()});
    }

    static ElasticsearchException unreadableKeyConfigFile(AccessDeniedException cause, String fileType, Path path) {
        return new ElasticsearchException("failed to initialize SSL KeyManager - not permitted to read " + fileType + " file [{}]", (Throwable)cause, new Object[]{path.toAbsolutePath()});
    }

    static ElasticsearchException blockedKeyConfigFile(AccessControlException cause, Environment environment, String fileType, Path path) {
        return new ElasticsearchException("failed to initialize SSL KeyManager - access to read {} file [{}] is blocked; SSL resources should be placed in the [{}] directory", (Throwable)cause, new Object[]{fileType, path, environment.configFile()});
    }

    abstract List<PrivateKey> privateKeys(@Nullable Environment var1);
}

