/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyItem;

public class GetSnapshotLifecycleAction
extends ActionType<Response> {
    public static final GetSnapshotLifecycleAction INSTANCE = new GetSnapshotLifecycleAction();
    public static final String NAME = "cluster:admin/slm/get";

    protected GetSnapshotLifecycleAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private List<SnapshotLifecyclePolicyItem> lifecycles;

        public Response() {
        }

        public Response(List<SnapshotLifecyclePolicyItem> lifecycles) {
            this.lifecycles = lifecycles;
        }

        public Response(StreamInput in) throws IOException {
            this.lifecycles = in.readList(SnapshotLifecyclePolicyItem::new);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            for (SnapshotLifecyclePolicyItem item : this.lifecycles) {
                item.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.lifecycles);
        }

        public int hashCode() {
            return Objects.hash(this.lifecycles);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return this.lifecycles.equals(other.lifecycles);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String[] lifecycleIds;

        public Request(String ... lifecycleIds) {
            this.lifecycleIds = Objects.requireNonNull(lifecycleIds, "ids may not be null");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.lifecycleIds = in.readStringArray();
        }

        public Request() {
            this.lifecycleIds = Strings.EMPTY_ARRAY;
        }

        public String[] getLifecycleIds() {
            return this.lifecycleIds;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.lifecycleIds);
        }

        public int hashCode() {
            return Arrays.hashCode(this.lifecycleIds);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Arrays.equals(this.lifecycleIds, other.lifecycleIds);
        }
    }
}

