/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;

public class Role {
    public static final Role EMPTY = Role.builder("__empty").build();
    private final String[] names;
    private final ClusterPermission cluster;
    private final IndicesPermission indices;
    private final ApplicationPermission application;
    private final RunAsPermission runAs;

    Role(String[] names, ClusterPermission cluster, IndicesPermission indices, ApplicationPermission application, RunAsPermission runAs) {
        this.names = names;
        this.cluster = Objects.requireNonNull(cluster);
        this.indices = Objects.requireNonNull(indices);
        this.application = Objects.requireNonNull(application);
        this.runAs = Objects.requireNonNull(runAs);
    }

    public String[] names() {
        return this.names;
    }

    public ClusterPermission cluster() {
        return this.cluster;
    }

    public IndicesPermission indices() {
        return this.indices;
    }

    public ApplicationPermission application() {
        return this.application;
    }

    public RunAsPermission runAs() {
        return this.runAs;
    }

    public static Builder builder(String ... names) {
        return new Builder(names);
    }

    public static Builder builder(RoleDescriptor rd, FieldPermissionsCache fieldPermissionsCache) {
        return new Builder(rd, fieldPermissionsCache);
    }

    public Predicate<String> allowedIndicesMatcher(String action) {
        return this.indices.allowedIndicesMatcher(action);
    }

    public Automaton allowedActionsMatcher(String index) {
        return this.indices.allowedActionsMatcher(index);
    }

    public boolean checkRunAs(String runAsName) {
        return this.runAs.check(runAsName);
    }

    public boolean checkIndicesAction(String action) {
        return this.indices.check(action);
    }

    public ResourcePrivilegesMap checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        return this.indices.checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges);
    }

    public boolean checkClusterAction(String action, TransportRequest request, Authentication authentication) {
        return this.cluster.check(action, request, authentication);
    }

    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return this.cluster.implies(clusterPrivilege.buildPermission(ClusterPermission.builder()).build());
    }

    public ResourcePrivilegesMap checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges) {
        return this.application.checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges);
    }

    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, AliasOrIndex> aliasAndIndexLookup, FieldPermissionsCache fieldPermissionsCache) {
        Map<String, IndicesAccessControl.IndexAccessControl> indexPermissions = this.indices.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
        boolean granted = true;
        for (Map.Entry<String, IndicesAccessControl.IndexAccessControl> entry : indexPermissions.entrySet()) {
            if (entry.getValue().isGranted()) continue;
            granted = false;
            break;
        }
        return new IndicesAccessControl(granted, indexPermissions);
    }

    public static class Builder {
        private final String[] names;
        private ClusterPermission cluster = ClusterPermission.NONE;
        private RunAsPermission runAs = RunAsPermission.NONE;
        private List<IndicesPermission.Group> groups = new ArrayList<IndicesPermission.Group>();
        private List<Tuple<ApplicationPrivilege, Set<String>>> applicationPrivs = new ArrayList<Tuple<ApplicationPrivilege, Set<String>>>();

        private Builder(String[] names) {
            this.names = names;
        }

        private Builder(RoleDescriptor rd, @Nullable FieldPermissionsCache fieldPermissionsCache) {
            this.names = new String[]{rd.getName()};
            this.cluster(Sets.newHashSet((Object[])rd.getClusterPrivileges()), Arrays.asList(rd.getConditionalClusterPrivileges()));
            this.groups.addAll(Builder.convertFromIndicesPrivileges(rd.getIndicesPrivileges(), fieldPermissionsCache));
            RoleDescriptor.ApplicationResourcePrivileges[] applicationPrivileges = rd.getApplicationPrivileges();
            for (int i = 0; i < applicationPrivileges.length; ++i) {
                this.applicationPrivs.add(Builder.convertApplicationPrivilege(rd.getName(), i, applicationPrivileges[i]));
            }
            Object[] rdRunAs = rd.getRunAs();
            if (rdRunAs != null && rdRunAs.length > 0) {
                this.runAs(new Privilege((Set<String>)Sets.newHashSet((Object[])rdRunAs), (String[])rdRunAs));
            }
        }

        public Builder cluster(Set<String> privilegeNames, Iterable<ConfigurableClusterPrivilege> configurableClusterPrivileges) {
            ClusterPermission.Builder builder = ClusterPermission.builder();
            ArrayList clusterPermissions = new ArrayList();
            if (!privilegeNames.isEmpty()) {
                for (String name : privilegeNames) {
                    builder = ClusterPrivilegeResolver.resolve(name).buildPermission(builder);
                }
            }
            for (ConfigurableClusterPrivilege ccp : configurableClusterPrivileges) {
                builder = ccp.buildPermission(builder);
            }
            this.cluster = builder.build();
            return this;
        }

        public Builder runAs(Privilege privilege) {
            this.runAs = new RunAsPermission(privilege);
            return this;
        }

        public Builder add(IndexPrivilege privilege, String ... indices) {
            this.groups.add(new IndicesPermission.Group(privilege, FieldPermissions.DEFAULT, null, false, indices));
            return this;
        }

        public Builder add(FieldPermissions fieldPermissions, Set<BytesReference> query, IndexPrivilege privilege, boolean allowRestrictedIndices, String ... indices) {
            this.groups.add(new IndicesPermission.Group(privilege, fieldPermissions, query, allowRestrictedIndices, indices));
            return this;
        }

        public Builder addApplicationPrivilege(ApplicationPrivilege privilege, Set<String> resources) {
            this.applicationPrivs.add((Tuple<ApplicationPrivilege, Set<String>>)new Tuple((Object)privilege, resources));
            return this;
        }

        public Role build() {
            IndicesPermission indices = this.groups.isEmpty() ? IndicesPermission.NONE : new IndicesPermission(this.groups.toArray(new IndicesPermission.Group[this.groups.size()]));
            ApplicationPermission applicationPermission = this.applicationPrivs.isEmpty() ? ApplicationPermission.NONE : new ApplicationPermission(this.applicationPrivs);
            return new Role(this.names, this.cluster, indices, applicationPermission, this.runAs);
        }

        static List<IndicesPermission.Group> convertFromIndicesPrivileges(RoleDescriptor.IndicesPrivileges[] indicesPrivileges, @Nullable FieldPermissionsCache fieldPermissionsCache) {
            ArrayList<IndicesPermission.Group> list = new ArrayList<IndicesPermission.Group>(indicesPrivileges.length);
            for (RoleDescriptor.IndicesPrivileges privilege : indicesPrivileges) {
                FieldPermissions fieldPermissions = fieldPermissionsCache != null ? fieldPermissionsCache.getFieldPermissions(privilege.getGrantedFields(), privilege.getDeniedFields()) : new FieldPermissions(new FieldPermissionsDefinition(privilege.getGrantedFields(), privilege.getDeniedFields()));
                Set<BytesReference> query = privilege.getQuery() == null ? null : Collections.singleton(privilege.getQuery());
                list.add(new IndicesPermission.Group(IndexPrivilege.get(Sets.newHashSet((Object[])privilege.getPrivileges())), fieldPermissions, query, privilege.allowRestrictedIndices(), privilege.getIndices()));
            }
            return list;
        }

        static Tuple<ApplicationPrivilege, Set<String>> convertApplicationPrivilege(String role, int index, RoleDescriptor.ApplicationResourcePrivileges arp) {
            return new Tuple((Object)new ApplicationPrivilege(arp.getApplication(), Sets.newHashSet((Object[])arp.getPrivileges()), arp.getPrivileges()), (Object)Sets.newHashSet((Object[])arp.getResources()));
        }
    }
}

