/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;

public final class DocumentSubsetBitsetCache
implements IndexReader.ClosedListener,
Closeable,
Accountable {
    static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.dls.bitset.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)168L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<ByteSizeValue> CACHE_SIZE_SETTING = Setting.byteSizeSetting((String)"xpack.security.dls.bitset.cache.size", (ByteSizeValue)new ByteSizeValue(50L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final BitSet NULL_MARKER = new FixedBitSet(0);
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Cache<BitsetCacheKey, BitSet> bitsetCache;
    private final Map<IndexReader.CacheKey, Set<BitsetCacheKey>> keysByIndex;

    public DocumentSubsetBitsetCache(Settings settings) {
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        ByteSizeValue size = (ByteSizeValue)CACHE_SIZE_SETTING.get(settings);
        this.bitsetCache = CacheBuilder.builder().setExpireAfterAccess(ttl).setMaximumWeight(size.getBytes()).weigher((key, bitSet) -> bitSet == NULL_MARKER ? 0L : bitSet.ramBytesUsed()).build();
        this.keysByIndex = new ConcurrentHashMap<IndexReader.CacheKey, Set<BitsetCacheKey>>();
    }

    public void onClose(IndexReader.CacheKey ownerCoreCacheKey) {
        Set<BitsetCacheKey> keys = this.keysByIndex.remove(ownerCoreCacheKey);
        if (keys != null) {
            keys.forEach(arg_0 -> this.bitsetCache.invalidate(arg_0));
        }
    }

    @Override
    public void close() {
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("clearing all DLS bitsets because [{}]", (Object)reason);
        this.keysByIndex.clear();
        this.bitsetCache.invalidateAll();
    }

    int entryCount() {
        return this.bitsetCache.count();
    }

    public long ramBytesUsed() {
        return this.bitsetCache.weight();
    }

    @Nullable
    public BitSet getBitSet(Query query, LeafReaderContext context) throws ExecutionException {
        IndexReader.CacheHelper coreCacheHelper = context.reader().getCoreCacheHelper();
        if (coreCacheHelper == null) {
            throw new IllegalArgumentException("Reader " + context.reader() + " does not support caching");
        }
        coreCacheHelper.addClosedListener((IndexReader.ClosedListener)this);
        IndexReader.CacheKey indexKey = coreCacheHelper.getKey();
        BitsetCacheKey cacheKey = new BitsetCacheKey(indexKey, query);
        BitSet bitSet = (BitSet)this.bitsetCache.computeIfAbsent((Object)cacheKey, ignore1 -> {
            this.keysByIndex.compute(indexKey, (ignore2, set) -> {
                if (set == null) {
                    set = Sets.newConcurrentHashSet();
                }
                set.add(cacheKey);
                return set;
            });
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = weight.scorer(context);
            if (s == null) {
                return NULL_MARKER;
            }
            return BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc());
        });
        if (bitSet == NULL_MARKER) {
            return null;
        }
        return bitSet;
    }

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_TTL_SETTING, CACHE_SIZE_SETTING);
    }

    public Map<String, Object> usageStats() {
        ByteSizeValue ram = new ByteSizeValue(this.ramBytesUsed(), ByteSizeUnit.BYTES);
        return new MapBuilder().put((Object)"count", (Object)this.entryCount()).put((Object)"memory", (Object)ram.toString()).put((Object)"memory_in_bytes", (Object)ram.getBytes()).immutableMap();
    }

    private class BitsetCacheKey {
        final IndexReader.CacheKey index;
        final Query query;

        private BitsetCacheKey(IndexReader.CacheKey index, Query query) {
            this.index = index;
            this.query = query;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BitsetCacheKey that = (BitsetCacheKey)other;
            return Objects.equals(this.index, that.index) && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.query);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.index + "," + this.query + ")";
        }
    }
}

