/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;

public final class CachingUsernamePasswordRealmSettings {
    private static final String CACHE_HASH_ALGO_SUFFIX = "cache.hash_algo";
    public static final Function<String, Setting.AffixSetting<String>> CACHE_HASH_ALGO_SETTING = RealmSettings.affixSetting("cache.hash_algo", key -> Setting.simpleString((String)key, (String)"ssha256", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    private static final String CACHE_TTL_SUFFIX = "cache.ttl";
    public static final Function<String, Setting.AffixSetting<TimeValue>> CACHE_TTL_SETTING = RealmSettings.affixSetting("cache.ttl", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    private static final int DEFAULT_MAX_USERS = 100000;
    private static final String CACHE_MAX_USERS_SUFFIX = "cache.max_users";
    public static final Function<String, Setting.AffixSetting<Integer>> CACHE_MAX_USERS_SETTING = RealmSettings.affixSetting("cache.max_users", key -> Setting.intSetting((String)key, (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
    public static final Function<String, Setting.AffixSetting<Boolean>> AUTHC_ENABLED_SETTING = RealmSettings.affixSetting("authentication.enabled", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    private CachingUsernamePasswordRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings(String type) {
        return new HashSet(Arrays.asList(CACHE_HASH_ALGO_SETTING.apply(type), CACHE_TTL_SETTING.apply(type), CACHE_MAX_USERS_SETTING.apply(type), AUTHC_ENABLED_SETTING.apply(type)));
    }
}

