/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.oidc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class OpenIdConnectRealmSettings {
    private static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS = Collections.unmodifiableList(Arrays.asList("HS256", "HS384", "HS512", "RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "PS256", "PS384", "PS512"));
    private static final List<String> RESPONSE_TYPES = Arrays.asList("code", "id_token", "id_token token");
    public static final String TYPE = "oidc";
    public static final Setting.AffixSetting<String> RP_CLIENT_ID = RealmSettings.simpleString("oidc", "rp.client_id", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<SecureString> RP_CLIENT_SECRET = RealmSettings.secureString("oidc", "rp.client_secret");
    public static final Setting.AffixSetting<String> RP_REDIRECT_URI = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.redirect_uri", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> RP_POST_LOGOUT_REDIRECT_URI = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.post_logout_redirect_uri", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> RP_RESPONSE_TYPE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.response_type", key -> Setting.simpleString((String)key, v -> {
        if (!RESPONSE_TYPES.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + RESPONSE_TYPES + "");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> RP_SIGNATURE_ALGORITHM = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.signature_algorithm", key -> new Setting(key, "RS256", Function.identity(), v -> {
        if (!SUPPORTED_SIGNATURE_ALGORITHMS.contains(v)) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Allowed values are " + SUPPORTED_SIGNATURE_ALGORITHMS + "}]");
        }
    }, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<List<String>> RP_REQUESTED_SCOPES = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"rp.requested_scopes", key -> Setting.listSetting((String)key, Collections.singletonList("openid"), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> OP_AUTHORIZATION_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.authorization_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> OP_TOKEN_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.token_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> OP_USERINFO_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.userinfo_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> OP_ENDSESSION_ENDPOINT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"op.endsession_endpoint", key -> Setting.simpleString((String)key, v -> {
        try {
            new URI((String)v);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid value [" + v + "] for [" + key + "]. Not a valid URI.", e);
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<String> OP_ISSUER = RealmSettings.simpleString("oidc", "op.issuer", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<String> OP_JWKSET_PATH = RealmSettings.simpleString("oidc", "op.jwkset_path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<TimeValue> ALLOWED_CLOCK_SKEW = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"allowed_clock_skew", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Boolean> POPULATE_USER_METADATA = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"populate_user_metadata", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECT_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECTION_READ_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.connection_read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_SOCKET_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.socket_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.max_connections", key -> Setting.intSetting((String)key, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_ENDPOINT_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("oidc"), (String)"http.max_endpoint_connections", key -> Setting.intSetting((String)key, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    public static final ClaimSetting PRINCIPAL_CLAIM = new ClaimSetting("principal");
    public static final ClaimSetting GROUPS_CLAIM = new ClaimSetting("groups");
    public static final ClaimSetting NAME_CLAIM = new ClaimSetting("name");
    public static final ClaimSetting DN_CLAIM = new ClaimSetting("dn");
    public static final ClaimSetting MAIL_CLAIM = new ClaimSetting("mail");

    private OpenIdConnectRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet set = Sets.newHashSet((Object[])new Setting.AffixSetting[]{RP_CLIENT_ID, RP_REDIRECT_URI, RP_RESPONSE_TYPE, RP_REQUESTED_SCOPES, RP_CLIENT_SECRET, RP_SIGNATURE_ALGORITHM, RP_POST_LOGOUT_REDIRECT_URI, OP_AUTHORIZATION_ENDPOINT, OP_TOKEN_ENDPOINT, OP_USERINFO_ENDPOINT, OP_ENDSESSION_ENDPOINT, OP_ISSUER, OP_JWKSET_PATH, HTTP_CONNECT_TIMEOUT, HTTP_CONNECTION_READ_TIMEOUT, HTTP_SOCKET_TIMEOUT, HTTP_MAX_CONNECTIONS, HTTP_MAX_ENDPOINT_CONNECTIONS, ALLOWED_CLOCK_SKEW});
        set.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        set.addAll(RealmSettings.getStandardSettings(TYPE));
        set.addAll(SSLConfigurationSettings.getRealmSettings(TYPE));
        set.addAll(PRINCIPAL_CLAIM.settings());
        set.addAll(GROUPS_CLAIM.settings());
        set.addAll(DN_CLAIM.settings());
        set.addAll(NAME_CLAIM.settings());
        set.addAll(MAIL_CLAIM.settings());
        return set;
    }

    public static final class ClaimSetting {
        public static final String CLAIMS_PREFIX = "claims.";
        public static final String CLAIM_PATTERNS_PREFIX = "claim_patterns.";
        private final Setting.AffixSetting<String> claim;
        private final Setting.AffixSetting<String> pattern;

        public ClaimSetting(String name) {
            this.claim = RealmSettings.simpleString(OpenIdConnectRealmSettings.TYPE, CLAIMS_PREFIX + name, Setting.Property.NodeScope);
            this.pattern = RealmSettings.simpleString(OpenIdConnectRealmSettings.TYPE, CLAIM_PATTERNS_PREFIX + name, Setting.Property.NodeScope);
        }

        public Collection<Setting.AffixSetting<?>> settings() {
            return Arrays.asList(this.getClaim(), this.getPattern());
        }

        public String name(RealmConfig config) {
            return this.getClaim().getConcreteSettingForNamespace(config.name()).getKey();
        }

        public Setting.AffixSetting<String> getClaim() {
            return this.claim;
        }

        public Setting.AffixSetting<String> getPattern() {
            return this.pattern;
        }
    }
}

