/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class GetApiKeyRequest
extends ActionRequest {
    private final String realmName;
    private final String userName;
    private final String apiKeyId;
    private final String apiKeyName;
    private final boolean ownedByAuthenticatedUser;

    public GetApiKeyRequest() {
        this(null, null, null, null, false);
    }

    public GetApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.userName = in.readOptionalString();
        this.apiKeyId = in.readOptionalString();
        this.apiKeyName = in.readOptionalString();
        this.ownedByAuthenticatedUser = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readOptionalBoolean() : false;
    }

    public GetApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName, boolean ownedByAuthenticatedUser) {
        this.realmName = realmName;
        this.userName = userName;
        this.apiKeyId = apiKeyId;
        this.apiKeyName = apiKeyName;
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public String getApiKeyName() {
        return this.apiKeyName;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public static GetApiKeyRequest usingRealmName(String realmName) {
        return new GetApiKeyRequest(realmName, null, null, null, false);
    }

    public static GetApiKeyRequest usingUserName(String userName) {
        return new GetApiKeyRequest(null, userName, null, null, false);
    }

    public static GetApiKeyRequest usingRealmAndUserName(String realmName, String userName) {
        return new GetApiKeyRequest(realmName, userName, null, null, false);
    }

    public static GetApiKeyRequest usingApiKeyId(String apiKeyId, boolean ownedByAuthenticatedUser) {
        return new GetApiKeyRequest(null, null, apiKeyId, null, ownedByAuthenticatedUser);
    }

    public static GetApiKeyRequest usingApiKeyName(String apiKeyName, boolean ownedByAuthenticatedUser) {
        return new GetApiKeyRequest(null, null, null, apiKeyName, ownedByAuthenticatedUser);
    }

    public static GetApiKeyRequest forOwnedApiKeys() {
        return new GetApiKeyRequest(null, null, null, null, true);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!(Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName) || Strings.hasText((String)this.apiKeyId) || Strings.hasText((String)this.apiKeyName) || this.ownedByAuthenticatedUser)) {
            validationException = ValidateActions.addValidationError((String)"One of [api key id, api key name, username, realm name] must be specified if [owner] flag is false", (ActionRequestValidationException)validationException);
        }
        if ((Strings.hasText((String)this.apiKeyId) || Strings.hasText((String)this.apiKeyName)) && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"username or realm name must not be specified when the api key id or api key name is specified", validationException);
        }
        if (this.ownedByAuthenticatedUser && (Strings.hasText((String)this.realmName) || Strings.hasText((String)this.userName))) {
            validationException = ValidateActions.addValidationError((String)"neither username nor realm-name may be specified when retrieving owned API keys", (ActionRequestValidationException)validationException);
        }
        if (Strings.hasText((String)this.apiKeyId) && Strings.hasText((String)this.apiKeyName)) {
            validationException = ValidateActions.addValidationError((String)"only one of [api key id, api key name] can be specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.apiKeyId);
        out.writeOptionalString(this.apiKeyName);
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeOptionalBoolean(Boolean.valueOf(this.ownedByAuthenticatedUser));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetApiKeyRequest that = (GetApiKeyRequest)((Object)o);
        return this.ownedByAuthenticatedUser == that.ownedByAuthenticatedUser && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.userName, that.userName) && Objects.equals(this.apiKeyId, that.apiKeyId) && Objects.equals(this.apiKeyName, that.apiKeyName);
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.userName, this.apiKeyId, this.apiKeyName, this.ownedByAuthenticatedUser);
    }
}

