/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class ModelSizeStats
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "model_size_stats";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("model_size_stats", new String[0]);
    public static final ParseField MODEL_BYTES_FIELD = new ParseField("model_bytes", new String[0]);
    public static final ParseField MODEL_BYTES_EXCEEDED_FIELD = new ParseField("model_bytes_exceeded", new String[0]);
    public static final ParseField MODEL_BYTES_MEMORY_LIMIT_FIELD = new ParseField("model_bytes_memory_limit", new String[0]);
    public static final ParseField TOTAL_BY_FIELD_COUNT_FIELD = new ParseField("total_by_field_count", new String[0]);
    public static final ParseField TOTAL_OVER_FIELD_COUNT_FIELD = new ParseField("total_over_field_count", new String[0]);
    public static final ParseField TOTAL_PARTITION_FIELD_COUNT_FIELD = new ParseField("total_partition_field_count", new String[0]);
    public static final ParseField BUCKET_ALLOCATION_FAILURES_COUNT_FIELD = new ParseField("bucket_allocation_failures_count", new String[0]);
    public static final ParseField MEMORY_STATUS_FIELD = new ParseField("memory_status", new String[0]);
    public static final ParseField LOG_TIME_FIELD = new ParseField("log_time", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = new ParseField("timestamp", new String[0]);
    public static final ConstructingObjectParser<Builder, Void> STRICT_PARSER = ModelSizeStats.createParser(false);
    public static final ConstructingObjectParser<Builder, Void> LENIENT_PARSER = ModelSizeStats.createParser(true);
    private final String jobId;
    private final long modelBytes;
    private final Long modelBytesExceeded;
    private final Long modelBytesMemoryLimit;
    private final long totalByFieldCount;
    private final long totalOverFieldCount;
    private final long totalPartitionFieldCount;
    private final long bucketAllocationFailuresCount;
    private final MemoryStatus memoryStatus;
    private final Date timestamp;
    private final Date logTime;

    private static ConstructingObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(RESULT_TYPE_FIELD.getPreferredName(), ignoreUnknownFields, a -> new Builder((String)a[0]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareString((modelSizeStat, s) -> {}, Result.RESULT_TYPE);
        parser.declareLong(Builder::setModelBytes, MODEL_BYTES_FIELD);
        parser.declareLong(Builder::setModelBytesExceeded, MODEL_BYTES_EXCEEDED_FIELD);
        parser.declareLong(Builder::setModelBytesMemoryLimit, MODEL_BYTES_MEMORY_LIMIT_FIELD);
        parser.declareLong(Builder::setBucketAllocationFailuresCount, BUCKET_ALLOCATION_FAILURES_COUNT_FIELD);
        parser.declareLong(Builder::setTotalByFieldCount, TOTAL_BY_FIELD_COUNT_FIELD);
        parser.declareLong(Builder::setTotalOverFieldCount, TOTAL_OVER_FIELD_COUNT_FIELD);
        parser.declareLong(Builder::setTotalPartitionFieldCount, TOTAL_PARTITION_FIELD_COUNT_FIELD);
        parser.declareField(Builder::setLogTime, p -> TimeUtils.parseTimeField(p, LOG_TIME_FIELD.getPreferredName()), LOG_TIME_FIELD, ObjectParser.ValueType.VALUE);
        parser.declareField(Builder::setTimestamp, p -> TimeUtils.parseTimeField(p, TIMESTAMP_FIELD.getPreferredName()), TIMESTAMP_FIELD, ObjectParser.ValueType.VALUE);
        BiConsumer<Builder, MemoryStatus> setMemoryStatus = Builder::setMemoryStatus;
        parser.declareField(setMemoryStatus, p -> MemoryStatus.fromString(p.text()), MEMORY_STATUS_FIELD, ObjectParser.ValueType.STRING);
        return parser;
    }

    private ModelSizeStats(String jobId, long modelBytes, Long modelBytesExceeded, Long modelBytesMemoryLimit, long totalByFieldCount, long totalOverFieldCount, long totalPartitionFieldCount, long bucketAllocationFailuresCount, MemoryStatus memoryStatus, Date timestamp, Date logTime) {
        this.jobId = jobId;
        this.modelBytes = modelBytes;
        this.modelBytesExceeded = modelBytesExceeded;
        this.modelBytesMemoryLimit = modelBytesMemoryLimit;
        this.totalByFieldCount = totalByFieldCount;
        this.totalOverFieldCount = totalOverFieldCount;
        this.totalPartitionFieldCount = totalPartitionFieldCount;
        this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
        this.memoryStatus = memoryStatus;
        this.timestamp = timestamp;
        this.logTime = logTime;
    }

    public ModelSizeStats(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.modelBytes = in.readVLong();
        this.modelBytesExceeded = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readOptionalLong() : null;
        this.modelBytesMemoryLimit = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readOptionalLong() : null;
        this.totalByFieldCount = in.readVLong();
        this.totalOverFieldCount = in.readVLong();
        this.totalPartitionFieldCount = in.readVLong();
        this.bucketAllocationFailuresCount = in.readVLong();
        this.memoryStatus = MemoryStatus.readFromStream(in);
        this.logTime = new Date(in.readVLong());
        this.timestamp = in.readBoolean() ? new Date(in.readVLong()) : null;
    }

    public String getId() {
        return ModelSizeStats.documentIdPrefix(this.jobId) + this.logTime.getTime();
    }

    public static String documentIdPrefix(String jobId) {
        return jobId + "_model_size_stats_";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeVLong(this.modelBytes);
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeOptionalLong(this.modelBytesExceeded);
        }
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeOptionalLong(this.modelBytesMemoryLimit);
        }
        out.writeVLong(this.totalByFieldCount);
        out.writeVLong(this.totalOverFieldCount);
        out.writeVLong(this.totalPartitionFieldCount);
        out.writeVLong(this.bucketAllocationFailuresCount);
        this.memoryStatus.writeTo(out);
        out.writeVLong(this.logTime.getTime());
        boolean hasTimestamp = this.timestamp != null;
        out.writeBoolean(hasTimestamp);
        if (hasTimestamp) {
            out.writeVLong(this.timestamp.getTime());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContentBody(builder);
        builder.endObject();
        return builder;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder) throws IOException {
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(MODEL_BYTES_FIELD.getPreferredName(), this.modelBytes);
        if (this.modelBytesExceeded != null) {
            builder.field(MODEL_BYTES_EXCEEDED_FIELD.getPreferredName(), this.modelBytesExceeded);
        }
        if (this.modelBytesMemoryLimit != null) {
            builder.field(MODEL_BYTES_MEMORY_LIMIT_FIELD.getPreferredName(), this.modelBytesMemoryLimit);
        }
        builder.field(TOTAL_BY_FIELD_COUNT_FIELD.getPreferredName(), this.totalByFieldCount);
        builder.field(TOTAL_OVER_FIELD_COUNT_FIELD.getPreferredName(), this.totalOverFieldCount);
        builder.field(TOTAL_PARTITION_FIELD_COUNT_FIELD.getPreferredName(), this.totalPartitionFieldCount);
        builder.field(BUCKET_ALLOCATION_FAILURES_COUNT_FIELD.getPreferredName(), this.bucketAllocationFailuresCount);
        builder.field(MEMORY_STATUS_FIELD.getPreferredName(), (Object)this.memoryStatus);
        builder.timeField(LOG_TIME_FIELD.getPreferredName(), LOG_TIME_FIELD.getPreferredName() + "_string", this.logTime.getTime());
        if (this.timestamp != null) {
            builder.timeField(TIMESTAMP_FIELD.getPreferredName(), TIMESTAMP_FIELD.getPreferredName() + "_string", this.timestamp.getTime());
        }
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getModelBytes() {
        return this.modelBytes;
    }

    public Long getModelBytesExceeded() {
        return this.modelBytesExceeded;
    }

    public Long getModelBytesMemoryLimit() {
        return this.modelBytesMemoryLimit;
    }

    public long getTotalByFieldCount() {
        return this.totalByFieldCount;
    }

    public long getTotalPartitionFieldCount() {
        return this.totalPartitionFieldCount;
    }

    public long getTotalOverFieldCount() {
        return this.totalOverFieldCount;
    }

    public long getBucketAllocationFailuresCount() {
        return this.bucketAllocationFailuresCount;
    }

    public MemoryStatus getMemoryStatus() {
        return this.memoryStatus;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jobId, this.modelBytes, this.modelBytesExceeded, this.modelBytesMemoryLimit, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.timestamp, this.logTime});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelSizeStats)) {
            return false;
        }
        ModelSizeStats that = (ModelSizeStats)other;
        return this.modelBytes == that.modelBytes && Objects.equals(this.modelBytesExceeded, that.modelBytesExceeded) && Objects.equals(this.modelBytesMemoryLimit, that.modelBytesMemoryLimit) && this.totalByFieldCount == that.totalByFieldCount && this.totalOverFieldCount == that.totalOverFieldCount && this.totalPartitionFieldCount == that.totalPartitionFieldCount && this.bucketAllocationFailuresCount == that.bucketAllocationFailuresCount && Objects.equals((Object)this.memoryStatus, (Object)that.memoryStatus) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.logTime, that.logTime) && Objects.equals(this.jobId, that.jobId);
    }

    public static class Builder {
        private final String jobId;
        private long modelBytes;
        private Long modelBytesExceeded;
        private Long modelBytesMemoryLimit;
        private long totalByFieldCount;
        private long totalOverFieldCount;
        private long totalPartitionFieldCount;
        private long bucketAllocationFailuresCount;
        private MemoryStatus memoryStatus;
        private Date timestamp;
        private Date logTime;

        public Builder(String jobId) {
            this.jobId = jobId;
            this.memoryStatus = MemoryStatus.OK;
            this.logTime = new Date();
        }

        public Builder(ModelSizeStats modelSizeStats) {
            this.jobId = modelSizeStats.jobId;
            this.modelBytes = modelSizeStats.modelBytes;
            this.modelBytesExceeded = modelSizeStats.modelBytesExceeded;
            this.modelBytesMemoryLimit = modelSizeStats.modelBytesMemoryLimit;
            this.totalByFieldCount = modelSizeStats.totalByFieldCount;
            this.totalOverFieldCount = modelSizeStats.totalOverFieldCount;
            this.totalPartitionFieldCount = modelSizeStats.totalPartitionFieldCount;
            this.bucketAllocationFailuresCount = modelSizeStats.bucketAllocationFailuresCount;
            this.memoryStatus = modelSizeStats.memoryStatus;
            this.timestamp = modelSizeStats.timestamp;
            this.logTime = modelSizeStats.logTime;
        }

        public Builder setModelBytes(long modelBytes) {
            this.modelBytes = modelBytes;
            return this;
        }

        public Builder setModelBytesExceeded(long modelBytesExceeded) {
            this.modelBytesExceeded = modelBytesExceeded;
            return this;
        }

        public Builder setModelBytesMemoryLimit(long modelBytesMemoryLimit) {
            this.modelBytesMemoryLimit = modelBytesMemoryLimit;
            return this;
        }

        public Builder setTotalByFieldCount(long totalByFieldCount) {
            this.totalByFieldCount = totalByFieldCount;
            return this;
        }

        public Builder setTotalPartitionFieldCount(long totalPartitionFieldCount) {
            this.totalPartitionFieldCount = totalPartitionFieldCount;
            return this;
        }

        public Builder setTotalOverFieldCount(long totalOverFieldCount) {
            this.totalOverFieldCount = totalOverFieldCount;
            return this;
        }

        public Builder setBucketAllocationFailuresCount(long bucketAllocationFailuresCount) {
            this.bucketAllocationFailuresCount = bucketAllocationFailuresCount;
            return this;
        }

        public Builder setMemoryStatus(MemoryStatus memoryStatus) {
            Objects.requireNonNull(memoryStatus, "[" + MEMORY_STATUS_FIELD.getPreferredName() + "] must not be null");
            this.memoryStatus = memoryStatus;
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setLogTime(Date logTime) {
            this.logTime = logTime;
            return this;
        }

        public ModelSizeStats build() {
            return new ModelSizeStats(this.jobId, this.modelBytes, this.modelBytesExceeded, this.modelBytesMemoryLimit, this.totalByFieldCount, this.totalOverFieldCount, this.totalPartitionFieldCount, this.bucketAllocationFailuresCount, this.memoryStatus, this.timestamp, this.logTime);
        }
    }

    public static enum MemoryStatus implements Writeable
    {
        OK,
        SOFT_LIMIT,
        HARD_LIMIT;


        public static MemoryStatus fromString(String statusName) {
            return MemoryStatus.valueOf(statusName.trim().toUpperCase(Locale.ROOT));
        }

        public static MemoryStatus readFromStream(StreamInput in) throws IOException {
            return (MemoryStatus)in.readEnum(MemoryStatus.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

