/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.util.Arrays;
import java.util.Collections;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.xpack.core.ClientHelper;

public final class AnomalyDetectorsIndex {
    public static final int CONFIG_INDEX_MAX_RESULTS_WINDOW = 10000;

    private AnomalyDetectorsIndex() {
    }

    public static String jobResultsIndexPrefix() {
        return ".ml-anomalies-";
    }

    public static String jobResultsAliasedName(String jobId) {
        return ".ml-anomalies-" + jobId;
    }

    public static String resultsWriteAlias(String jobId) {
        return ".ml-anomalies-.write-" + jobId;
    }

    public static String jobStateIndexWriteAlias() {
        return ".ml-state-write";
    }

    public static String jobStateIndexPattern() {
        return ".ml-state*";
    }

    public static String configIndexName() {
        return ".ml-config";
    }

    public static void createStateIndexAndAliasIfNecessary(Client client, ClusterState state, ActionListener<Boolean> finalListener) {
        if (state.getMetaData().getAliasAndIndexLookup().containsKey(AnomalyDetectorsIndex.jobStateIndexWriteAlias())) {
            finalListener.onResponse((Object)false);
            return;
        }
        ActionListener createAliasListener = ActionListener.wrap(concreteIndexName -> {
            IndicesAliasesRequest request = (IndicesAliasesRequest)client.admin().indices().prepareAliases().addAlias(concreteIndexName, AnomalyDetectorsIndex.jobStateIndexWriteAlias()).request();
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(resp -> finalListener.onResponse((Object)resp.isAcknowledged()), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finalListener.onFailure(arg_0));
        IndexNameExpressionResolver indexNameExpressionResolver = new IndexNameExpressionResolver();
        String[] stateIndices = indexNameExpressionResolver.concreteIndexNames(state, IndicesOptions.lenientExpandOpen(), new String[]{AnomalyDetectorsIndex.jobStateIndexPattern()});
        if (stateIndices.length > 0) {
            Arrays.sort(stateIndices, Collections.reverseOrder());
            createAliasListener.onResponse((Object)stateIndices[0]);
        } else {
            CreateIndexRequest createIndexRequest = (CreateIndexRequest)client.admin().indices().prepareCreate(".ml-state").addAlias(new Alias(AnomalyDetectorsIndex.jobStateIndexWriteAlias())).request();
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(createIndexResponse -> finalListener.onResponse((Object)true), createIndexFailure -> {
                if (createIndexFailure instanceof ResourceAlreadyExistsException) {
                    createAliasListener.onResponse((Object)".ml-state");
                } else {
                    finalListener.onFailure(createIndexFailure);
                }
            }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
        }
    }
}

