/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.MeanSquaredError;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.RSquared;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.regression.RegressionMetric;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Regression
implements Evaluation {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    private static final ParseField ACTUAL_FIELD = new ParseField("actual_field", new String[0]);
    private static final ParseField PREDICTED_FIELD = new ParseField("predicted_field", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    public static final ConstructingObjectParser<Regression, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), a -> new Regression((String)a[0], (String)a[1], (List)a[2]));
    private final String actualField;
    private final String predictedField;
    private final List<RegressionMetric> metrics;

    public static Regression fromXContent(XContentParser parser) {
        return (Regression)PARSER.apply(parser, null);
    }

    public Regression(String actualField, String predictedField, @Nullable List<RegressionMetric> metrics) {
        this.actualField = ExceptionsHelper.requireNonNull(actualField, ACTUAL_FIELD);
        this.predictedField = ExceptionsHelper.requireNonNull(predictedField, PREDICTED_FIELD);
        this.metrics = Regression.initMetrics(metrics);
    }

    public Regression(StreamInput in) throws IOException {
        this.actualField = in.readString();
        this.predictedField = in.readString();
        this.metrics = in.readNamedWriteableList(RegressionMetric.class);
    }

    private static List<RegressionMetric> initMetrics(@Nullable List<RegressionMetric> parsedMetrics) {
        List<RegressionMetric> metrics;
        List<RegressionMetric> list = metrics = parsedMetrics == null ? Regression.defaultMetrics() : parsedMetrics;
        if (metrics.isEmpty()) {
            throw ExceptionsHelper.badRequestException("[{}] must have one or more metrics", NAME.getPreferredName());
        }
        Collections.sort(metrics, Comparator.comparing(RegressionMetric::getMetricName));
        return metrics;
    }

    private static List<RegressionMetric> defaultMetrics() {
        ArrayList<RegressionMetric> defaultMetrics = new ArrayList<RegressionMetric>(2);
        defaultMetrics.add(new MeanSquaredError());
        defaultMetrics.add(new RSquared());
        return defaultMetrics;
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public SearchSourceBuilder buildSearch(QueryBuilder queryBuilder) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.existsQuery((String)this.actualField)).filter((QueryBuilder)QueryBuilders.existsQuery((String)this.predictedField)).filter(queryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query((QueryBuilder)boolQuery);
        for (RegressionMetric metric : this.metrics) {
            List<AggregationBuilder> aggs = metric.aggs(this.actualField, this.predictedField);
            aggs.forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        }
        return searchSourceBuilder;
    }

    @Override
    public void evaluate(SearchResponse searchResponse, ActionListener<List<EvaluationMetricResult>> listener) {
        ArrayList<EvaluationMetricResult> results = new ArrayList<EvaluationMetricResult>(this.metrics.size());
        if (searchResponse.getHits().getTotalHits().value == 0L) {
            listener.onFailure((Exception)ExceptionsHelper.badRequestException("No documents found containing both [{}, {}] fields", this.actualField, this.predictedField));
            return;
        }
        for (RegressionMetric metric : this.metrics) {
            results.add(metric.evaluate(searchResponse.getAggregations()));
        }
        listener.onResponse(results);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.actualField);
        out.writeString(this.predictedField);
        out.writeNamedWriteableList(this.metrics);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ACTUAL_FIELD.getPreferredName(), this.actualField);
        builder.field(PREDICTED_FIELD.getPreferredName(), this.predictedField);
        builder.startObject(METRICS.getPreferredName());
        for (RegressionMetric metric : this.metrics) {
            builder.field(metric.getWriteableName(), (ToXContent)metric);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(that.actualField, this.actualField) && Objects.equals(that.predictedField, this.predictedField) && Objects.equals(that.metrics, this.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.actualField, this.predictedField, this.metrics);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ACTUAL_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PREDICTED_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (RegressionMetric)p.namedObject(RegressionMetric.class, n, c), METRICS);
    }
}

