/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Types;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Regression
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("regression", new String[0]);
    public static final ParseField DEPENDENT_VARIABLE = new ParseField("dependent_variable", new String[0]);
    public static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    public static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    public static final ParseField ETA = new ParseField("eta", new String[0]);
    public static final ParseField MAXIMUM_NUMBER_TREES = new ParseField("maximum_number_trees", new String[0]);
    public static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    public static final ParseField PREDICTION_FIELD_NAME = new ParseField("prediction_field_name", new String[0]);
    public static final ParseField TRAINING_PERCENT = new ParseField("training_percent", new String[0]);
    private static final ConstructingObjectParser<Regression, Void> LENIENT_PARSER = Regression.createParser(true);
    private static final ConstructingObjectParser<Regression, Void> STRICT_PARSER = Regression.createParser(false);
    private final String dependentVariable;
    private final Double lambda;
    private final Double gamma;
    private final Double eta;
    private final Integer maximumNumberTrees;
    private final Double featureBagFraction;
    private final String predictionFieldName;
    private final double trainingPercent;

    private static ConstructingObjectParser<Regression, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new Regression((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Integer)a[4], (Double)a[5], (String)a[6], (Double)a[7]));
        parser.declareString(ConstructingObjectParser.constructorArg(), DEPENDENT_VARIABLE);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), LAMBDA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), GAMMA);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), ETA);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAXIMUM_NUMBER_TREES);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_BAG_FRACTION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), PREDICTION_FIELD_NAME);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), TRAINING_PERCENT);
        return parser;
    }

    public static Regression fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return ignoreUnknownFields ? (Regression)LENIENT_PARSER.apply(parser, null) : (Regression)STRICT_PARSER.apply(parser, null);
    }

    public Regression(String dependentVariable, @Nullable Double lambda, @Nullable Double gamma, @Nullable Double eta, @Nullable Integer maximumNumberTrees, @Nullable Double featureBagFraction, @Nullable String predictionFieldName, @Nullable Double trainingPercent) {
        this.dependentVariable = Objects.requireNonNull(dependentVariable);
        if (lambda != null && lambda < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", LAMBDA.getPreferredName());
        }
        this.lambda = lambda;
        if (gamma != null && gamma < 0.0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a non-negative double", GAMMA.getPreferredName());
        }
        this.gamma = gamma;
        if (eta != null && (eta < 0.001 || eta > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [0.001, 1]", ETA.getPreferredName());
        }
        this.eta = eta;
        if (maximumNumberTrees != null && (maximumNumberTrees <= 0 || maximumNumberTrees > 2000)) {
            throw ExceptionsHelper.badRequestException("[{}] must be an integer in [1, 2000]", MAXIMUM_NUMBER_TREES.getPreferredName());
        }
        this.maximumNumberTrees = maximumNumberTrees;
        if (featureBagFraction != null && (featureBagFraction <= 0.0 || featureBagFraction > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in (0, 1]", FEATURE_BAG_FRACTION.getPreferredName());
        }
        this.featureBagFraction = featureBagFraction;
        this.predictionFieldName = predictionFieldName;
        if (trainingPercent != null && (trainingPercent < 1.0 || trainingPercent > 100.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be a double in [1, 100]", TRAINING_PERCENT.getPreferredName());
        }
        this.trainingPercent = trainingPercent == null ? 100.0 : trainingPercent;
    }

    public Regression(String dependentVariable) {
        this(dependentVariable, null, null, null, null, null, null, null);
    }

    public Regression(StreamInput in) throws IOException {
        this.dependentVariable = in.readString();
        this.lambda = in.readOptionalDouble();
        this.gamma = in.readOptionalDouble();
        this.eta = in.readOptionalDouble();
        this.maximumNumberTrees = in.readOptionalVInt();
        this.featureBagFraction = in.readOptionalDouble();
        this.predictionFieldName = in.readOptionalString();
        this.trainingPercent = in.readDouble();
    }

    public String getDependentVariable() {
        return this.dependentVariable;
    }

    public double getTrainingPercent() {
        return this.trainingPercent;
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.dependentVariable);
        out.writeOptionalDouble(this.lambda);
        out.writeOptionalDouble(this.gamma);
        out.writeOptionalDouble(this.eta);
        out.writeOptionalVInt(this.maximumNumberTrees);
        out.writeOptionalDouble(this.featureBagFraction);
        out.writeOptionalString(this.predictionFieldName);
        out.writeDouble(this.trainingPercent);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        if (this.lambda != null) {
            builder.field(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            builder.field(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            builder.field(ETA.getPreferredName(), this.eta);
        }
        if (this.maximumNumberTrees != null) {
            builder.field(MAXIMUM_NUMBER_TREES.getPreferredName(), this.maximumNumberTrees);
        }
        if (this.featureBagFraction != null) {
            builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.predictionFieldName != null) {
            builder.field(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        builder.field(TRAINING_PERCENT.getPreferredName(), this.trainingPercent);
        builder.endObject();
        return builder;
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPENDENT_VARIABLE.getPreferredName(), this.dependentVariable);
        if (this.lambda != null) {
            params.put(LAMBDA.getPreferredName(), this.lambda);
        }
        if (this.gamma != null) {
            params.put(GAMMA.getPreferredName(), this.gamma);
        }
        if (this.eta != null) {
            params.put(ETA.getPreferredName(), this.eta);
        }
        if (this.maximumNumberTrees != null) {
            params.put(MAXIMUM_NUMBER_TREES.getPreferredName(), this.maximumNumberTrees);
        }
        if (this.featureBagFraction != null) {
            params.put(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        }
        if (this.predictionFieldName != null) {
            params.put(PREDICTION_FIELD_NAME.getPreferredName(), this.predictionFieldName);
        }
        return params;
    }

    @Override
    public boolean supportsCategoricalFields() {
        return true;
    }

    @Override
    public List<RequiredField> getRequiredFields() {
        return Collections.singletonList(new RequiredField(this.dependentVariable, Types.numerical()));
    }

    @Override
    public boolean supportsMissingValues() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.dependentVariable, this.lambda, this.gamma, this.eta, this.maximumNumberTrees, this.featureBagFraction, this.predictionFieldName, this.trainingPercent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Regression that = (Regression)o;
        return Objects.equals(this.dependentVariable, that.dependentVariable) && Objects.equals(this.lambda, that.lambda) && Objects.equals(this.gamma, that.gamma) && Objects.equals(this.eta, that.eta) && Objects.equals(this.maximumNumberTrees, that.maximumNumberTrees) && Objects.equals(this.featureBagFraction, that.featureBagFraction) && Objects.equals(this.predictionFieldName, that.predictionFieldName) && this.trainingPercent == that.trainingPercent;
    }
}

