/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.analyses;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.RequiredField;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OutlierDetection
implements DataFrameAnalysis {
    public static final ParseField NAME = new ParseField("outlier_detection", new String[0]);
    public static final ParseField N_NEIGHBORS = new ParseField("n_neighbors", new String[0]);
    public static final ParseField METHOD = new ParseField("method", new String[0]);
    public static final ParseField FEATURE_INFLUENCE_THRESHOLD = new ParseField("feature_influence_threshold", new String[0]);
    private static final ConstructingObjectParser<OutlierDetection, Void> LENIENT_PARSER = OutlierDetection.createParser(true);
    private static final ConstructingObjectParser<OutlierDetection, Void> STRICT_PARSER = OutlierDetection.createParser(false);
    private final Integer nNeighbors;
    private final Method method;
    private final Double featureInfluenceThreshold;

    private static ConstructingObjectParser<OutlierDetection, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new OutlierDetection((Integer)a[0], (Method)((Object)((Object)a[1])), (Double)a[2]));
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), N_NEIGHBORS);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Method.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, METHOD, ObjectParser.ValueType.STRING);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), FEATURE_INFLUENCE_THRESHOLD);
        return parser;
    }

    public static OutlierDetection fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return ignoreUnknownFields ? (OutlierDetection)LENIENT_PARSER.apply(parser, null) : (OutlierDetection)STRICT_PARSER.apply(parser, null);
    }

    public OutlierDetection(@Nullable Integer nNeighbors, @Nullable Method method, @Nullable Double featureInfluenceThreshold) {
        if (nNeighbors != null && nNeighbors <= 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a positive integer", N_NEIGHBORS.getPreferredName());
        }
        if (featureInfluenceThreshold != null && (featureInfluenceThreshold < 0.0 || featureInfluenceThreshold > 1.0)) {
            throw ExceptionsHelper.badRequestException("[{}] must be in [0, 1]", FEATURE_INFLUENCE_THRESHOLD.getPreferredName());
        }
        this.nNeighbors = nNeighbors;
        this.method = method;
        this.featureInfluenceThreshold = featureInfluenceThreshold;
    }

    public OutlierDetection() {
        this(null, null, null);
    }

    public OutlierDetection(StreamInput in) throws IOException {
        this.nNeighbors = in.readOptionalVInt();
        this.method = in.readBoolean() ? (Method)in.readEnum(Method.class) : null;
        this.featureInfluenceThreshold = in.readOptionalDouble();
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.nNeighbors);
        if (this.method != null) {
            out.writeBoolean(true);
            out.writeEnum((Enum)this.method);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalDouble(this.featureInfluenceThreshold);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.nNeighbors != null) {
            builder.field(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        }
        if (this.method != null) {
            builder.field(METHOD.getPreferredName(), (Object)this.method);
        }
        if (this.featureInfluenceThreshold != null) {
            builder.field(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlierDetection that = (OutlierDetection)o;
        return Objects.equals(this.nNeighbors, that.nNeighbors) && Objects.equals((Object)this.method, (Object)that.method) && Objects.equals(this.featureInfluenceThreshold, that.featureInfluenceThreshold);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nNeighbors, this.method, this.featureInfluenceThreshold});
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.nNeighbors != null) {
            params.put(N_NEIGHBORS.getPreferredName(), this.nNeighbors);
        }
        if (this.method != null) {
            params.put(METHOD.getPreferredName(), (Object)this.method);
        }
        if (this.featureInfluenceThreshold != null) {
            params.put(FEATURE_INFLUENCE_THRESHOLD.getPreferredName(), this.featureInfluenceThreshold);
        }
        return params;
    }

    @Override
    public boolean supportsCategoricalFields() {
        return false;
    }

    @Override
    public List<RequiredField> getRequiredFields() {
        return Collections.emptyList();
    }

    @Override
    public boolean supportsMissingValues() {
        return false;
    }

    public static enum Method {
        LOF,
        LDOF,
        DISTANCE_KTH_NN,
        DISTANCE_KNN;


        public static Method fromString(String value) {
            return Method.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

