/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class StartDataFrameAnalyticsAction
extends ActionType<AcknowledgedResponse> {
    public static final StartDataFrameAnalyticsAction INSTANCE = new StartDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/start";

    private StartDataFrameAnalyticsAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static interface TaskMatcher {
        public static boolean match(Task task, String expectedId) {
            if (task instanceof TaskMatcher) {
                if ("_all".equals(expectedId)) {
                    return true;
                }
                String expectedDescription = "data_frame_analytics-" + expectedId;
                return expectedDescription.equals(task.getDescription());
            }
            return false;
        }
    }

    public static class TaskParams
    implements XPackPlugin.XPackPersistentTaskParams {
        public static final Version VERSION_INTRODUCED = Version.V_7_3_0;
        public static ConstructingObjectParser<TaskParams, Void> PARSER = new ConstructingObjectParser("xpack/ml/data_frame/analytics", true, a -> new TaskParams((String)a[0], (String)a[1]));
        private final String id;
        private final Version version;

        public static TaskParams fromXContent(XContentParser parser) {
            return (TaskParams)PARSER.apply(parser, null);
        }

        public TaskParams(String id, Version version) {
            this.id = Objects.requireNonNull(id);
            this.version = Objects.requireNonNull(version);
        }

        private TaskParams(String id, String version) {
            this(id, Version.fromString((String)version));
        }

        public TaskParams(StreamInput in) throws IOException {
            this.id = in.readString();
            this.version = Version.readVersion((StreamInput)in);
        }

        public String getId() {
            return this.id;
        }

        public String getWriteableName() {
            return "xpack/ml/data_frame/analytics";
        }

        public Version getMinimalSupportedVersion() {
            return VERSION_INTRODUCED;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            Version.writeVersion((Version)this.version, (StreamOutput)out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DataFrameAnalyticsConfig.ID.getPreferredName(), this.id);
            builder.field(DataFrameAnalyticsConfig.VERSION.getPreferredName(), (ToXContent)this.version);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskParams other = (TaskParams)o;
            return Objects.equals(this.id, other.id) && Objects.equals(this.version, other.version);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), DataFrameAnalyticsConfig.ID);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), DataFrameAnalyticsConfig.VERSION);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        RequestBuilder(ElasticsearchClient client, StartDataFrameAnalyticsAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/data_frame/analytics/start", Request::new);
        private String id;
        private TimeValue timeout = TimeValue.timeValueSeconds((long)20L);

        public static Request parseRequest(String id, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (request.getId() == null) {
                request.setId(id);
            } else if (!Strings.isNullOrEmpty((String)id) && !id.equals(request.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", DataFrameAnalyticsConfig.ID, request.getId(), id));
            }
            return request;
        }

        public Request(String id) {
            this.setId(id);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.timeout = in.readTimeValue();
        }

        public Request() {
        }

        public final void setId(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, DataFrameAnalyticsConfig.ID);
        }

        public String getId() {
            return this.id;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeTimeValue(this.timeout);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.id != null) {
                builder.field(DataFrameAnalyticsConfig.ID.getPreferredName(), this.id);
            }
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.timeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && Objects.equals(this.timeout, other.timeout);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString((request, id) -> {
                request.id = id;
            }, DataFrameAnalyticsConfig.ID);
            PARSER.declareString((request, val) -> request.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }
}

