/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;

public class GetFiltersAction
extends ActionType<Response> {
    public static final GetFiltersAction INSTANCE = new GetFiltersAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/get";

    private GetFiltersAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<MlFilter>
    implements StatusToXContentObject {
        public Response(QueryPage<MlFilter> filters) {
            super(filters);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public QueryPage<MlFilter> getFilters() {
            return this.getResources();
        }

        @Override
        public RestStatus status() {
            return RestStatus.OK;
        }

        @Override
        protected Writeable.Reader<MlFilter> getReader() {
            return MlFilter::new;
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends AbstractGetResourcesRequest {
        public Request() {
            super(null, null, true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public void setFilterId(String filterId) {
            this.setResourceId(filterId);
        }

        public String getFilterId() {
            return this.getResourceId();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.getPageParams() != null && this.getResourceId() != null) {
                validationException = ValidateActions.addValidationError((String)("Params [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] are incompatible with [" + MlFilter.ID.getPreferredName() + "]"), validationException);
            }
            return validationException;
        }

        @Override
        public String getResourceIdField() {
            return MlFilter.ID.getPreferredName();
        }
    }
}

