/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.PhaseProgress;

public class GetDataFrameAnalyticsStatsAction
extends ActionType<Response> {
    public static final GetDataFrameAnalyticsStatsAction INSTANCE = new GetDataFrameAnalyticsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/data_frame/analytics/stats/get";

    private GetDataFrameAnalyticsStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements ToXContentObject {
        private QueryPage<Stats> stats;

        public Response(QueryPage<Stats> stats) {
            this(Collections.emptyList(), Collections.emptyList(), stats);
        }

        public Response(List<TaskOperationFailure> taskFailures, List<? extends ElasticsearchException> nodeFailures, QueryPage<Stats> stats) {
            super(taskFailures, nodeFailures);
            this.stats = stats;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.stats = new QueryPage(in, Stats::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.stats.writeTo(out);
        }

        public QueryPage<Stats> getResponse() {
            return this.stats;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.stats.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.stats);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.stats, other.stats);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        public static class Stats
        implements ToXContentObject,
        Writeable {
            private final String id;
            private final DataFrameAnalyticsState state;
            @Nullable
            private final String failureReason;
            private final List<PhaseProgress> progress;
            @Nullable
            private final DiscoveryNode node;
            @Nullable
            private final String assignmentExplanation;

            public Stats(String id, DataFrameAnalyticsState state, @Nullable String failureReason, List<PhaseProgress> progress, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation) {
                this.id = Objects.requireNonNull(id);
                this.state = Objects.requireNonNull(state);
                this.failureReason = failureReason;
                this.progress = Objects.requireNonNull(progress);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
            }

            public Stats(StreamInput in) throws IOException {
                this.id = in.readString();
                this.state = DataFrameAnalyticsState.fromStream(in);
                this.failureReason = in.readOptionalString();
                this.progress = in.getVersion().before(Version.V_7_4_0) ? Stats.readProgressFromLegacy(this.state, in) : in.readList(PhaseProgress::new);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
            }

            private static List<PhaseProgress> readProgressFromLegacy(DataFrameAnalyticsState state, StreamInput in) throws IOException {
                Integer legacyProgressPercent = in.readOptionalInt();
                if (legacyProgressPercent == null) {
                    return Collections.emptyList();
                }
                int reindexingProgress = 0;
                int loadingDataProgress = 0;
                int analyzingProgress = 0;
                switch (state) {
                    case ANALYZING: {
                        reindexingProgress = 100;
                        loadingDataProgress = 100;
                        analyzingProgress = legacyProgressPercent;
                        break;
                    }
                    case REINDEXING: {
                        reindexingProgress = legacyProgressPercent;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return Arrays.asList(new PhaseProgress("reindexing", reindexingProgress), new PhaseProgress("loading_data", loadingDataProgress), new PhaseProgress("analyzing", analyzingProgress), new PhaseProgress("writing_results", 0));
            }

            public String getId() {
                return this.id;
            }

            public DataFrameAnalyticsState getState() {
                return this.state;
            }

            public List<PhaseProgress> getProgress() {
                return this.progress;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                this.toUnwrappedXContent(builder);
                return builder.endObject();
            }

            public XContentBuilder toUnwrappedXContent(XContentBuilder builder) throws IOException {
                builder.field(DataFrameAnalyticsConfig.ID.getPreferredName(), this.id);
                builder.field("state", this.state.toString());
                if (this.failureReason != null) {
                    builder.field("failure_reason", this.failureReason);
                }
                if (this.progress != null) {
                    builder.field("progress", this.progress);
                }
                if (this.node != null) {
                    builder.startObject("node");
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field("assignment_explanation", this.assignmentExplanation);
                }
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.id);
                this.state.writeTo(out);
                out.writeOptionalString(this.failureReason);
                if (out.getVersion().before(Version.V_7_4_0)) {
                    this.writeProgressToLegacy(out);
                } else {
                    out.writeList(this.progress);
                }
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
            }

            private void writeProgressToLegacy(StreamOutput out) throws IOException {
                String targetPhase = null;
                switch (this.state) {
                    case ANALYZING: {
                        targetPhase = "analyzing";
                        break;
                    }
                    case REINDEXING: {
                        targetPhase = "reindexing";
                        break;
                    }
                }
                Integer legacyProgressPercent = null;
                for (PhaseProgress phaseProgress : this.progress) {
                    if (!phaseProgress.getPhase().equals(targetPhase)) continue;
                    legacyProgressPercent = phaseProgress.getProgressPercent();
                }
                out.writeOptionalInt(legacyProgressPercent);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.id, this.state, this.failureReason, this.progress, this.node, this.assignmentExplanation});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Stats other = (Stats)obj;
                return Objects.equals(this.id, other.id) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation);
            }
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client, GetDataFrameAnalyticsStatsAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        private String id;
        private boolean allowNoMatch = true;
        private PageParams pageParams = PageParams.defaultParams();
        private List<String> expandedIds = Collections.emptyList();

        public Request(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, DataFrameAnalyticsConfig.ID.getPreferredName());
            this.expandedIds = Collections.singletonList(id);
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.allowNoMatch = in.readBoolean();
            this.pageParams = (PageParams)in.readOptionalWriteable(PageParams::new);
            this.expandedIds = in.readStringList();
        }

        public void setExpandedIds(List<String> expandedIds) {
            this.expandedIds = Objects.requireNonNull(expandedIds);
        }

        public List<String> getExpandedIds() {
            return this.expandedIds;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.allowNoMatch);
            out.writeOptionalWriteable((Writeable)this.pageParams);
            out.writeStringCollection(this.expandedIds);
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean isAllowNoMatch() {
            return this.allowNoMatch;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public boolean match(Task task) {
            return this.expandedIds.stream().anyMatch(expandedId -> StartDataFrameAnalyticsAction.TaskMatcher.match(task, expandedId));
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.allowNoMatch, this.pageParams);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id) && this.allowNoMatch == other.allowNoMatch && Objects.equals(this.pageParams, other.pageParams);
        }
    }
}

