/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms.pivot;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.xpack.core.dataframe.transforms.pivot.SingleGroupSource;

public class TermsGroupSource
extends SingleGroupSource {
    private static final String NAME = "data_frame_terms_group";
    private static final ConstructingObjectParser<TermsGroupSource, Void> STRICT_PARSER = TermsGroupSource.createParser(false);
    private static final ConstructingObjectParser<TermsGroupSource, Void> LENIENT_PARSER = TermsGroupSource.createParser(true);

    private static ConstructingObjectParser<TermsGroupSource, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            String field = (String)args[0];
            return new TermsGroupSource(field);
        });
        SingleGroupSource.declareValuesSourceFields(parser);
        return parser;
    }

    public TermsGroupSource(String field) {
        super(field);
    }

    public TermsGroupSource(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.TERMS;
    }

    public static TermsGroupSource fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (TermsGroupSource)LENIENT_PARSER.apply(parser, null) : (TermsGroupSource)STRICT_PARSER.apply(parser, null);
    }

    @Override
    public QueryBuilder getIncrementalBucketUpdateFilterQuery(Set<String> changedBuckets) {
        return new TermsQueryBuilder(this.field, changedBuckets);
    }

    @Override
    public boolean supportsIncrementalBucketUpdate() {
        return true;
    }
}

