/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms.pivot;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.core.dataframe.transforms.pivot.SingleGroupSource;

public class HistogramGroupSource
extends SingleGroupSource {
    static final ParseField INTERVAL = new ParseField("interval", new String[0]);
    private static final String NAME = "data_frame_histogram_group";
    private static final ConstructingObjectParser<HistogramGroupSource, Void> STRICT_PARSER = HistogramGroupSource.createParser(false);
    private static final ConstructingObjectParser<HistogramGroupSource, Void> LENIENT_PARSER = HistogramGroupSource.createParser(true);
    private final double interval;

    public HistogramGroupSource(String field, double interval) {
        super(field);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("[interval] must be greater than 0.");
        }
        this.interval = interval;
    }

    public HistogramGroupSource(StreamInput in) throws IOException {
        super(in);
        this.interval = in.readDouble();
    }

    private static ConstructingObjectParser<HistogramGroupSource, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            String field = (String)args[0];
            double interval = (Double)args[1];
            return new HistogramGroupSource(field, interval);
        });
        HistogramGroupSource.declareValuesSourceFields(parser);
        parser.declareDouble(ConstructingObjectParser.optionalConstructorArg(), INTERVAL);
        return parser;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.HISTOGRAM;
    }

    public static HistogramGroupSource fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (HistogramGroupSource)LENIENT_PARSER.apply(parser, null) : (HistogramGroupSource)STRICT_PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.field);
        out.writeDouble(this.interval);
    }

    public double getInterval() {
        return this.interval;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        builder.field(INTERVAL.getPreferredName(), this.interval);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HistogramGroupSource that = (HistogramGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.interval, that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.interval);
    }

    @Override
    public QueryBuilder getIncrementalBucketUpdateFilterQuery(Set<String> changedBuckets) {
        return null;
    }

    @Override
    public boolean supportsIncrementalBucketUpdate() {
        return false;
    }
}

