/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.transforms.DestConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.SourceConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.SyncConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.core.dataframe.utils.ExceptionsHelper;

public class DataFrameTransformConfig
extends AbstractDiffable<DataFrameTransformConfig>
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame_transform_config";
    public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ParseField PIVOT_TRANSFORM = new ParseField("pivot", new String[0]);
    private static final ConstructingObjectParser<DataFrameTransformConfig, String> STRICT_PARSER = DataFrameTransformConfig.createParser(false);
    private static final ConstructingObjectParser<DataFrameTransformConfig, String> LENIENT_PARSER = DataFrameTransformConfig.createParser(true);
    static final int MAX_DESCRIPTION_LENGTH = 1000;
    private final String id;
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final String description;
    private Map<String, String> headers;
    private Version transformVersion;
    private Instant createTime;
    private final PivotConfig pivotConfig;

    private static void validateStrictParsingParams(Object arg, String parameterName) {
        if (arg != null) {
            throw new IllegalArgumentException("Found [" + parameterName + "], not allowed for strict parsing");
        }
    }

    private static ConstructingObjectParser<DataFrameTransformConfig, String> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, (args, optionalId) -> {
            String id = (String)args[0];
            if (id == null) {
                id = optionalId;
            } else if (optionalId != null && !id.equals(optionalId)) {
                throw new IllegalArgumentException(DataFrameMessages.getMessage("Inconsistent id; ''{0}'' specified in the body differs from ''{1}'' specified as a URL argument", id, optionalId));
            }
            SourceConfig source = (SourceConfig)args[1];
            DestConfig dest = (DestConfig)args[2];
            TimeValue frequency = args[3] == null ? null : TimeValue.parseTimeValue((String)((String)args[3]), (String)DataFrameField.FREQUENCY.getPreferredName());
            SyncConfig syncConfig = (SyncConfig)args[4];
            if (!lenient) {
                DataFrameTransformConfig.validateStrictParsingParams(args[6], HEADERS.getPreferredName());
                DataFrameTransformConfig.validateStrictParsingParams(args[9], DataFrameField.CREATE_TIME.getPreferredName());
                DataFrameTransformConfig.validateStrictParsingParams(args[10], DataFrameField.VERSION.getPreferredName());
            }
            Map headers = (Map)args[6];
            PivotConfig pivotConfig = (PivotConfig)args[7];
            String description = (String)args[8];
            return new DataFrameTransformConfig(id, source, dest, frequency, syncConfig, headers, pivotConfig, description, (Instant)args[9], (String)args[10]);
        });
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.ID);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SourceConfig.fromXContent(p, lenient), DataFrameField.SOURCE);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DestConfig.fromXContent(p, lenient), DataFrameField.DESTINATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.FREQUENCY);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameTransformConfig.parseSyncConfig(p, lenient), DataFrameField.SYNC);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.INDEX_DOC_TYPE);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), HEADERS);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PivotConfig.fromXContent(p, lenient), PIVOT_TRANSFORM);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.DESCRIPTION);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, DataFrameField.CREATE_TIME.getPreferredName()), DataFrameField.CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.VERSION);
        return parser;
    }

    private static SyncConfig parseSyncConfig(XContentParser parser, boolean ignoreUnknownFields) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), () -> ((XContentParser)parser).getTokenLocation());
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        SyncConfig syncConfig = (SyncConfig)parser.namedObject(SyncConfig.class, parser.currentName(), (Object)ignoreUnknownFields);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        return syncConfig;
    }

    public static String documentId(String transformId) {
        return "data_frame_transform_config-" + transformId;
    }

    DataFrameTransformConfig(String id, SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, Map<String, String> headers, PivotConfig pivotConfig, String description, Instant createTime, String version) {
        this.id = ExceptionsHelper.requireNonNull(id, DataFrameField.ID.getPreferredName());
        this.source = ExceptionsHelper.requireNonNull(source, DataFrameField.SOURCE.getPreferredName());
        this.dest = ExceptionsHelper.requireNonNull(dest, DataFrameField.DESTINATION.getPreferredName());
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.setHeaders(headers == null ? Collections.emptyMap() : headers);
        this.pivotConfig = pivotConfig;
        this.description = description;
        if (this.pivotConfig == null) {
            throw new IllegalArgumentException("Data frame transform configuration must specify exactly 1 function");
        }
        if (this.description != null && this.description.length() > 1000) {
            throw new IllegalArgumentException("[description] must be less than 1000 characters in length.");
        }
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.transformVersion = version == null ? null : Version.fromString((String)version);
    }

    public DataFrameTransformConfig(String id, SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, Map<String, String> headers, PivotConfig pivotConfig, String description) {
        this(id, source, dest, frequency, syncConfig, headers, pivotConfig, description, null, null);
    }

    public DataFrameTransformConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.source = new SourceConfig(in);
        this.dest = new DestConfig(in);
        this.frequency = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readOptionalTimeValue() : null;
        this.setHeaders(in.readMap(StreamInput::readString, StreamInput::readString));
        this.pivotConfig = (PivotConfig)in.readOptionalWriteable(PivotConfig::new);
        this.description = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.syncConfig = (SyncConfig)in.readOptionalNamedWriteable(SyncConfig.class);
            this.createTime = in.readOptionalInstant();
            this.transformVersion = in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
        } else {
            this.syncConfig = null;
            this.createTime = null;
            this.transformVersion = null;
        }
    }

    public String getId() {
        return this.id;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public DataFrameTransformConfig setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Version getVersion() {
        return this.transformVersion;
    }

    public DataFrameTransformConfig setVersion(Version transformVersion) {
        this.transformVersion = transformVersion;
        return this;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public DataFrameTransformConfig setCreateTime(Instant createTime) {
        ExceptionsHelper.requireNonNull(createTime, DataFrameField.CREATE_TIME.getPreferredName());
        this.createTime = Instant.ofEpochMilli(createTime.toEpochMilli());
        return this;
    }

    public PivotConfig getPivotConfig() {
        return this.pivotConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isValid() {
        if (this.pivotConfig != null && !this.pivotConfig.isValid()) {
            return false;
        }
        if (this.syncConfig != null && !this.syncConfig.isValid()) {
            return false;
        }
        return this.source.isValid() && this.dest.isValid();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.source.writeTo(out);
        this.dest.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalTimeValue(this.frequency);
        }
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeOptionalWriteable((Writeable)this.pivotConfig);
        out.writeOptionalString(this.description);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.syncConfig);
            out.writeOptionalInstant(this.createTime);
            if (this.transformVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion((Version)this.transformVersion, (StreamOutput)out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DataFrameField.ID.getPreferredName(), this.id);
        builder.field(DataFrameField.SOURCE.getPreferredName(), (ToXContent)this.source);
        builder.field(DataFrameField.DESTINATION.getPreferredName(), (ToXContent)this.dest);
        if (this.frequency != null) {
            builder.field(DataFrameField.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.syncConfig != null) {
            builder.startObject(DataFrameField.SYNC.getPreferredName());
            builder.field(this.syncConfig.getWriteableName(), (ToXContent)this.syncConfig);
            builder.endObject();
        }
        if (this.pivotConfig != null) {
            builder.field(PIVOT_TRANSFORM.getPreferredName(), (ToXContent)this.pivotConfig);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(DataFrameField.INDEX_DOC_TYPE.getPreferredName(), NAME);
        }
        if (!this.headers.isEmpty() && params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(HEADERS.getPreferredName(), this.headers);
        }
        if (this.description != null) {
            builder.field(DataFrameField.DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.transformVersion != null) {
            builder.field(DataFrameField.VERSION.getPreferredName(), (ToXContent)this.transformVersion);
        }
        if (this.createTime != null) {
            builder.timeField(DataFrameField.CREATE_TIME.getPreferredName(), DataFrameField.CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformConfig that = (DataFrameTransformConfig)((Object)other);
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pivotConfig, that.pivotConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.transformVersion, that.transformVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.description, this.createTime, this.transformVersion);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static DataFrameTransformConfig fromXContent(XContentParser parser, @Nullable String optionalTransformId, boolean lenient) {
        return lenient ? (DataFrameTransformConfig)((Object)LENIENT_PARSER.apply(parser, (Object)optionalTransformId)) : (DataFrameTransformConfig)((Object)STRICT_PARSER.apply(parser, (Object)optionalTransformId));
    }

    public static class Builder {
        private String id;
        private SourceConfig source;
        private DestConfig dest;
        private TimeValue frequency;
        private SyncConfig syncConfig;
        private String description;
        private Map<String, String> headers;
        private Version transformVersion;
        private Instant createTime;
        private PivotConfig pivotConfig;

        public Builder() {
        }

        public Builder(DataFrameTransformConfig config) {
            this.id = config.id;
            this.source = config.source;
            this.dest = config.dest;
            this.frequency = config.frequency;
            this.syncConfig = config.syncConfig;
            this.description = config.description;
            this.transformVersion = config.transformVersion;
            this.createTime = config.createTime;
            this.pivotConfig = config.pivotConfig;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder setSyncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setPivotConfig(PivotConfig pivotConfig) {
            this.pivotConfig = pivotConfig;
            return this;
        }

        Builder setVersion(Version version) {
            this.transformVersion = version;
            return this;
        }

        public DataFrameTransformConfig build() {
            return new DataFrameTransformConfig(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.description, this.createTime, this.transformVersion == null ? null : this.transformVersion.toString());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Builder that = (Builder)other;
            return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pivotConfig, that.pivotConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.transformVersion, that.transformVersion);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.description, this.createTime, this.transformVersion);
        }
    }
}

