/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerPosition;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformProgress;

public class DataFrameTransformCheckpointStats
implements Writeable,
ToXContentObject {
    public static final DataFrameTransformCheckpointStats EMPTY = new DataFrameTransformCheckpointStats(0L, null, null, 0L, 0L);
    private final long checkpoint;
    private final DataFrameIndexerPosition position;
    private final DataFrameTransformProgress checkpointProgress;
    private final long timestampMillis;
    private final long timeUpperBoundMillis;
    static final ConstructingObjectParser<DataFrameTransformCheckpointStats, Void> LENIENT_PARSER = new ConstructingObjectParser("data_frame_transform_checkpoint_stats", true, args -> {
        long checkpoint = args[0] == null ? 0L : (Long)args[0];
        DataFrameIndexerPosition position = (DataFrameIndexerPosition)args[1];
        DataFrameTransformProgress checkpointProgress = (DataFrameTransformProgress)args[2];
        long timestamp = args[3] == null ? 0L : (Long)args[3];
        long timeUpperBound = args[4] == null ? 0L : (Long)args[4];
        return new DataFrameTransformCheckpointStats(checkpoint, position, checkpointProgress, timestamp, timeUpperBound);
    });

    public DataFrameTransformCheckpointStats(long checkpoint, DataFrameIndexerPosition position, DataFrameTransformProgress checkpointProgress, long timestampMillis, long timeUpperBoundMillis) {
        this.checkpoint = checkpoint;
        this.position = position;
        this.checkpointProgress = checkpointProgress;
        this.timestampMillis = timestampMillis;
        this.timeUpperBoundMillis = timeUpperBoundMillis;
    }

    public DataFrameTransformCheckpointStats(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_7_4_0)) {
            this.checkpoint = in.readVLong();
            this.position = in.readBoolean() ? new DataFrameIndexerPosition(in) : null;
            this.checkpointProgress = in.readBoolean() ? new DataFrameTransformProgress(in) : null;
        } else {
            this.checkpoint = 0L;
            this.position = null;
            this.checkpointProgress = null;
        }
        this.timestampMillis = in.readLong();
        this.timeUpperBoundMillis = in.readLong();
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    public DataFrameIndexerPosition getPosition() {
        return this.position;
    }

    public DataFrameTransformProgress getCheckpointProgress() {
        return this.checkpointProgress;
    }

    public long getTimestampMillis() {
        return this.timestampMillis;
    }

    public long getTimeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DataFrameField.CHECKPOINT.getPreferredName(), this.checkpoint);
        if (this.position != null) {
            builder.field(DataFrameField.POSITION.getPreferredName(), (ToXContent)this.position);
        }
        if (this.checkpointProgress != null) {
            builder.field(DataFrameField.CHECKPOINT_PROGRESS.getPreferredName(), (ToXContent)this.checkpointProgress);
        }
        if (this.timestampMillis > 0L) {
            builder.timeField(DataFrameField.TIMESTAMP_MILLIS.getPreferredName(), DataFrameField.TIMESTAMP.getPreferredName(), this.timestampMillis);
        }
        if (this.timeUpperBoundMillis > 0L) {
            builder.timeField(DataFrameField.TIME_UPPER_BOUND_MILLIS.getPreferredName(), DataFrameField.TIME_UPPER_BOUND.getPreferredName(), this.timeUpperBoundMillis);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
            out.writeVLong(this.checkpoint);
            if (this.position != null) {
                out.writeBoolean(true);
                this.position.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (this.checkpointProgress != null) {
                out.writeBoolean(true);
                this.checkpointProgress.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
        out.writeLong(this.timestampMillis);
        out.writeLong(this.timeUpperBoundMillis);
    }

    public int hashCode() {
        return Objects.hash(this.checkpoint, this.position, this.checkpointProgress, this.timestampMillis, this.timeUpperBoundMillis);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformCheckpointStats that = (DataFrameTransformCheckpointStats)other;
        return this.checkpoint == that.checkpoint && Objects.equals(this.position, that.position) && Objects.equals(this.checkpointProgress, that.checkpointProgress) && this.timestampMillis == that.timestampMillis && this.timeUpperBoundMillis == that.timeUpperBoundMillis;
    }

    public static DataFrameTransformCheckpointStats fromXContent(XContentParser p) {
        return (DataFrameTransformCheckpointStats)LENIENT_PARSER.apply(p, null);
    }

    static {
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.CHECKPOINT);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataFrameIndexerPosition.PARSER, DataFrameField.POSITION);
        LENIENT_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataFrameTransformProgress.PARSER, DataFrameField.CHECKPOINT_PROGRESS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.TIMESTAMP_MILLIS);
        LENIENT_PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), DataFrameField.TIME_UPPER_BOUND_MILLIS);
    }
}

