/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.action;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.DataFrameMessages;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;
import org.elasticsearch.xpack.core.dataframe.utils.DataFrameStrings;

public class PutDataFrameTransformAction
extends ActionType<AcknowledgedResponse> {
    public static final PutDataFrameTransformAction INSTANCE = new PutDataFrameTransformAction();
    public static final String NAME = "cluster:admin/data_frame/put";
    private static final TimeValue MIN_FREQUENCY = TimeValue.timeValueSeconds((long)1L);
    private static final TimeValue MAX_FREQUENCY = TimeValue.timeValueHours((long)1L);

    private PutDataFrameTransformAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final DataFrameTransformConfig config;
        private final boolean deferValidation;

        public Request(DataFrameTransformConfig config, boolean deferValidation) {
            this.config = config;
            this.deferValidation = deferValidation;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new DataFrameTransformConfig(in);
            this.deferValidation = in.getVersion().onOrAfter(Version.V_7_4_0) ? in.readBoolean() : false;
        }

        public static Request fromXContent(XContentParser parser, String id, boolean deferValidation) {
            return new Request(DataFrameTransformConfig.fromXContent(parser, id, false), deferValidation);
        }

        public ActionRequestValidationException validate() {
            TimeValue frequency;
            ActionRequestValidationException validationException = null;
            if (this.config.getPivotConfig() != null && this.config.getPivotConfig().getMaxPageSearchSize() != null && (this.config.getPivotConfig().getMaxPageSearchSize() < 10 || this.config.getPivotConfig().getMaxPageSearchSize() > 10000)) {
                validationException = ValidateActions.addValidationError((String)("pivot.max_page_search_size [" + this.config.getPivotConfig().getMaxPageSearchSize() + "] must be greater than 10 and less than 10,000"), (ActionRequestValidationException)validationException);
            }
            for (String failure : this.config.getPivotConfig().aggFieldValidation()) {
                validationException = ValidateActions.addValidationError((String)failure, validationException);
            }
            String destIndex = this.config.getDestination().getIndex();
            try {
                MetaDataCreateIndexService.validateIndexOrAliasName((String)destIndex, InvalidIndexNameException::new);
                if (!destIndex.toLowerCase(Locale.ROOT).equals(destIndex)) {
                    validationException = ValidateActions.addValidationError((String)("dest.index [" + destIndex + "] must be lowercase"), (ActionRequestValidationException)validationException);
                }
            }
            catch (InvalidIndexNameException ex) {
                validationException = ValidateActions.addValidationError((String)ex.getMessage(), (ActionRequestValidationException)validationException);
            }
            if (!DataFrameStrings.isValidId(this.config.getId())) {
                validationException = ValidateActions.addValidationError((String)DataFrameMessages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", DataFrameField.ID.getPreferredName(), this.config.getId()), (ActionRequestValidationException)validationException);
            }
            if (!DataFrameStrings.hasValidLengthForId(this.config.getId())) {
                validationException = ValidateActions.addValidationError((String)DataFrameMessages.getMessage("The id cannot contain more than {0} characters.", 64), (ActionRequestValidationException)validationException);
            }
            if ((frequency = this.config.getFrequency()) != null) {
                if (frequency.compareTo(MIN_FREQUENCY) < 0) {
                    validationException = ValidateActions.addValidationError((String)("minimum permitted [" + DataFrameField.FREQUENCY + "] is [" + MIN_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                } else if (frequency.compareTo(MAX_FREQUENCY) > 0) {
                    validationException = ValidateActions.addValidationError((String)("highest permitted [" + DataFrameField.FREQUENCY + "] is [" + MAX_FREQUENCY.getStringRep() + "]"), (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public DataFrameTransformConfig getConfig() {
            return this.config;
        }

        public boolean isDeferValidation() {
            return this.deferValidation;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_7_4_0)) {
                out.writeBoolean(this.deferValidation);
            }
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.config, this.deferValidation});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals((Object)this.config, (Object)other.config) && this.deferValidation == other.deferValidation;
        }
    }
}

