/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformConfig;

public class GetDataFrameTransformsAction
extends ActionType<Response> {
    public static final GetDataFrameTransformsAction INSTANCE = new GetDataFrameTransformsAction();
    public static final String NAME = "cluster:monitor/data_frame/get";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(GetDataFrameTransformsAction.class));

    private GetDataFrameTransformsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<DataFrameTransformConfig>
    implements Writeable,
    ToXContentObject {
        public static final String INVALID_TRANSFORMS_DEPRECATION_WARNING = "Found [{}] invalid transforms";
        private static final ParseField INVALID_TRANSFORMS = new ParseField("invalid_transforms", new String[0]);

        public Response(List<DataFrameTransformConfig> transformConfigs, long count) {
            super(new QueryPage<DataFrameTransformConfig>(transformConfigs, count, DataFrameField.TRANSFORMS));
        }

        public Response() {
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public List<DataFrameTransformConfig> getTransformConfigurations() {
            return this.getResources().results();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            ArrayList<String> invalidTransforms = new ArrayList<String>();
            builder.startObject();
            builder.field(DataFrameField.COUNT.getPreferredName(), this.getResources().count());
            builder.field(DataFrameField.TRANSFORMS.getPreferredName());
            builder.startArray();
            for (DataFrameTransformConfig configResponse : this.getResources().results()) {
                configResponse.toXContent(builder, params);
                if (configResponse.isValid()) continue;
                invalidTransforms.add(configResponse.getId());
            }
            builder.endArray();
            if (!invalidTransforms.isEmpty()) {
                builder.startObject(INVALID_TRANSFORMS.getPreferredName());
                builder.field(DataFrameField.COUNT.getPreferredName(), invalidTransforms.size());
                builder.field(DataFrameField.TRANSFORMS.getPreferredName(), invalidTransforms);
                builder.endObject();
                deprecationLogger.deprecated(INVALID_TRANSFORMS_DEPRECATION_WARNING, new Object[]{invalidTransforms.size()});
            }
            builder.endObject();
            return builder;
        }

        @Override
        protected Writeable.Reader<DataFrameTransformConfig> getReader() {
            return DataFrameTransformConfig::new;
        }
    }

    public static class Request
    extends AbstractGetResourcesRequest {
        private static final int MAX_SIZE_RETURN = 1000;

        public Request(String id) {
            super(id, PageParams.defaultParams(), true);
        }

        public Request() {
            super(null, PageParams.defaultParams(), true);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public String getId() {
            return this.getResourceId();
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException exception = null;
            if (this.getPageParams() != null && this.getPageParams().getSize() > 1000) {
                exception = ValidateActions.addValidationError((String)("Param [" + PageParams.SIZE.getPreferredName() + "] has a max acceptable value of [" + 1000 + "]"), exception);
            }
            return exception;
        }

        @Override
        public String getResourceIdField() {
            return DataFrameField.ID.getPreferredName();
        }
    }
}

