/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.dataframe;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameIndexerTransformStats;

public class DataFrameFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final Map<String, Long> transformCountByState;
    private final DataFrameIndexerTransformStats accumulatedStats;

    public DataFrameFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.transformCountByState = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.accumulatedStats = new DataFrameIndexerTransformStats(in);
    }

    public DataFrameFeatureSetUsage(boolean available, boolean enabled, Map<String, Long> transformCountByState, DataFrameIndexerTransformStats accumulatedStats) {
        super("data_frame", available, enabled);
        this.transformCountByState = Objects.requireNonNull(transformCountByState);
        this.accumulatedStats = Objects.requireNonNull(accumulatedStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.transformCountByState, StreamOutput::writeString, StreamOutput::writeLong);
        this.accumulatedStats.writeTo(out);
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        if (!this.transformCountByState.isEmpty()) {
            builder.startObject(DataFrameField.TRANSFORMS.getPreferredName());
            long all = 0L;
            for (Map.Entry<String, Long> entry : this.transformCountByState.entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
                all += entry.getValue().longValue();
            }
            builder.field("_all", all);
            builder.endObject();
            builder.field(DataFrameField.STATS_FIELD.getPreferredName(), (ToXContent)this.accumulatedStats);
        }
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.available, this.transformCountByState, this.accumulatedStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataFrameFeatureSetUsage other = (DataFrameFeatureSetUsage)obj;
        return Objects.equals(this.name, other.name) && this.available == other.available && this.enabled == other.enabled && Objects.equals(this.transformCountByState, other.transformCountByState) && Objects.equals(this.accumulatedStats, other.accumulatedStats);
    }
}

