/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.analytics.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class AnalyticsStatsAction
extends ActionType<Response> {
    public static final AnalyticsStatsAction INSTANCE = new AnalyticsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/analytics/stats";

    private AnalyticsStatsAction() {
        super(NAME, Response::new);
    }

    public static class NodeResponse
    extends BaseNodeResponse
    implements ToXContentObject {
        static ParseField CUMULATIVE_CARDINALITY_USAGE = new ParseField("cumulative_cardinality_usage", new String[0]);
        private long cumulativeCardinalityUsage;

        public NodeResponse(StreamInput in) throws IOException {
            super(in);
            this.cumulativeCardinalityUsage = in.readZLong();
        }

        public NodeResponse(DiscoveryNode node) {
            super(node);
        }

        public void setCumulativeCardinalityUsage(long cumulativeCardinalityUsage) {
            this.cumulativeCardinalityUsage = cumulativeCardinalityUsage;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.cumulativeCardinalityUsage);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CUMULATIVE_CARDINALITY_USAGE.getPreferredName(), this.cumulativeCardinalityUsage);
            builder.endObject();
            return builder;
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeList(nodes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray("stats");
            for (NodeResponse node : this.getNodes()) {
                node.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest(Request request) {
        }
    }

    public static class Request
    extends BaseNodesRequest<Request>
    implements ToXContentObject {
        public Request() {
            super((String[])null);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(AnalyticsStatsAction.NAME);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }
    }
}

