/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.GetBasicStatusAction;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetTrialStatusAction;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PostStartBasicAction;
import org.elasticsearch.license.PostStartTrialAction;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoAction;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.analytics.AnalyticsFeatureSetUsage;
import org.elasticsearch.xpack.core.beats.BeatsFeatureSetUsage;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.CCRFeatureSet;
import org.elasticsearch.xpack.core.dataframe.DataFrameFeatureSetUsage;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.action.DeleteDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsAction;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsStatsAction;
import org.elasticsearch.xpack.core.dataframe.action.PreviewDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.PutDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformTaskAction;
import org.elasticsearch.xpack.core.dataframe.action.StopDataFrameTransformAction;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransform;
import org.elasticsearch.xpack.core.dataframe.transforms.DataFrameTransformState;
import org.elasticsearch.xpack.core.dataframe.transforms.SyncConfig;
import org.elasticsearch.xpack.core.dataframe.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.core.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.core.flattened.FlattenedFeatureSetUsage;
import org.elasticsearch.xpack.core.frozen.FrozenIndicesFeatureSetUsage;
import org.elasticsearch.xpack.core.frozen.action.FreezeIndexAction;
import org.elasticsearch.xpack.core.graph.GraphFeatureSetUsage;
import org.elasticsearch.xpack.core.graph.action.GraphExploreAction;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.DeleteAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.FreezeAction;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleFeatureSetUsage;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.ReadOnlyAction;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.action.DeleteLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.ExplainLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.GetLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.MoveToStepAction;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleAction;
import org.elasticsearch.xpack.core.ilm.action.RemoveIndexLifecyclePolicyAction;
import org.elasticsearch.xpack.core.ilm.action.RetryAction;
import org.elasticsearch.xpack.core.logstash.LogstashFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MachineLearningFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.EstimateMemoryUsageAction;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;
import org.elasticsearch.xpack.core.ml.action.FlushJobAction;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PersistJobAction;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.core.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.DataFrameAnalysis;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.OutlierDetection;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.Regression;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.Evaluation;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.EvaluationMetricResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.AucRoc;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.BinarySoftClassification;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.ConfusionMatrix;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Precision;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.Recall;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.ScoreByThresholdResult;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.softclassification.SoftClassificationMetric;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.monitoring.MonitoringFeatureSetUsage;
import org.elasticsearch.xpack.core.rollup.RollupFeatureSetUsage;
import org.elasticsearch.xpack.core.rollup.action.DeleteRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupCapsAction;
import org.elasticsearch.xpack.core.rollup.action.GetRollupJobsAction;
import org.elasticsearch.xpack.core.rollup.action.PutRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.RollupSearchAction;
import org.elasticsearch.xpack.core.rollup.action.StartRollupJobAction;
import org.elasticsearch.xpack.core.rollup.action.StopRollupJobAction;
import org.elasticsearch.xpack.core.rollup.job.RollupJob;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;
import org.elasticsearch.xpack.core.security.SecurityFeatureSetUsage;
import org.elasticsearch.xpack.core.security.SecuritySettings;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.GetApiKeyAction;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheAction;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleAction;
import org.elasticsearch.xpack.core.security.action.role.GetRolesAction;
import org.elasticsearch.xpack.core.security.action.role.PutRoleAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsAction;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingAction;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.RefreshTokenAction;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.core.security.action.user.ChangePasswordAction;
import org.elasticsearch.xpack.core.security.action.user.DeleteUserAction;
import org.elasticsearch.xpack.core.security.action.user.GetUsersAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.PutUserAction;
import org.elasticsearch.xpack.core.security.action.user.SetEnabledAction;
import org.elasticsearch.xpack.core.security.authc.TokenMetaData;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AllExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AnyExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExceptExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.core.spatial.SpatialFeatureSetUsage;
import org.elasticsearch.xpack.core.sql.SqlFeatureSetUsage;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.action.GetCertificateInfoAction;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeAction;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;
import org.elasticsearch.xpack.core.vectors.VectorsFeatureSetUsage;
import org.elasticsearch.xpack.core.votingonly.VotingOnlyNodeFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.WatcherFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.WatcherMetaData;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;

public class XPackClientPlugin
extends Plugin
implements ActionPlugin,
NetworkPlugin {
    static Optional<String> X_PACK_FEATURE = Optional.of("x-pack");
    private final Settings settings;

    protected Optional<String> getFeature() {
        return X_PACK_FEATURE;
    }

    public XPackClientPlugin(Settings settings) {
        this.settings = settings;
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(Setting.groupSetting((String)"license.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.addAll(XPackSettings.getAllSettings());
        settings.add(LicenseService.SELF_GENERATED_LICENSE_TYPE);
        settings.add(Setting.simpleString((String)"index.xpack.version", (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope}));
        return settings;
    }

    public Settings additionalSettings() {
        return XPackClientPlugin.additionalSettings(this.settings, (Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings), XPackPlugin.transportClientMode(this.settings));
    }

    static Settings additionalSettings(Settings settings, boolean enabled, boolean transportClientMode) {
        if (enabled && transportClientMode) {
            return Settings.builder().put(SecuritySettings.addTransportSettings(settings)).put(SecuritySettings.addUserSettings(settings)).build();
        }
        return Settings.EMPTY;
    }

    public List<ActionType<? extends ActionResponse>> getClientActions() {
        return Arrays.asList(new ActionType[]{DeprecationInfoAction.INSTANCE, GraphExploreAction.INSTANCE, GetJobsAction.INSTANCE, GetJobsStatsAction.INSTANCE, MlInfoAction.INSTANCE, PutJobAction.INSTANCE, UpdateJobAction.INSTANCE, DeleteJobAction.INSTANCE, OpenJobAction.INSTANCE, GetFiltersAction.INSTANCE, PutFilterAction.INSTANCE, UpdateFilterAction.INSTANCE, DeleteFilterAction.INSTANCE, KillProcessAction.INSTANCE, GetBucketsAction.INSTANCE, GetInfluencersAction.INSTANCE, GetOverallBucketsAction.INSTANCE, GetRecordsAction.INSTANCE, PostDataAction.INSTANCE, CloseJobAction.INSTANCE, FinalizeJobExecutionAction.INSTANCE, FlushJobAction.INSTANCE, ValidateDetectorAction.INSTANCE, ValidateJobConfigAction.INSTANCE, GetCategoriesAction.INSTANCE, GetModelSnapshotsAction.INSTANCE, RevertModelSnapshotAction.INSTANCE, UpdateModelSnapshotAction.INSTANCE, GetDatafeedsAction.INSTANCE, GetDatafeedsStatsAction.INSTANCE, PutDatafeedAction.INSTANCE, UpdateDatafeedAction.INSTANCE, DeleteDatafeedAction.INSTANCE, PreviewDatafeedAction.INSTANCE, StartDatafeedAction.INSTANCE, StopDatafeedAction.INSTANCE, IsolateDatafeedAction.INSTANCE, DeleteModelSnapshotAction.INSTANCE, UpdateProcessAction.INSTANCE, DeleteExpiredDataAction.INSTANCE, ForecastJobAction.INSTANCE, DeleteForecastAction.INSTANCE, GetCalendarsAction.INSTANCE, PutCalendarAction.INSTANCE, DeleteCalendarAction.INSTANCE, DeleteCalendarEventAction.INSTANCE, UpdateCalendarJobAction.INSTANCE, GetCalendarEventsAction.INSTANCE, PostCalendarEventsAction.INSTANCE, PersistJobAction.INSTANCE, FindFileStructureAction.INSTANCE, SetUpgradeModeAction.INSTANCE, PutDataFrameAnalyticsAction.INSTANCE, GetDataFrameAnalyticsAction.INSTANCE, GetDataFrameAnalyticsStatsAction.INSTANCE, DeleteDataFrameAnalyticsAction.INSTANCE, StartDataFrameAnalyticsAction.INSTANCE, StopDataFrameAnalyticsAction.INSTANCE, EvaluateDataFrameAction.INSTANCE, EstimateMemoryUsageAction.INSTANCE, ClearRealmCacheAction.INSTANCE, ClearRolesCacheAction.INSTANCE, GetUsersAction.INSTANCE, PutUserAction.INSTANCE, DeleteUserAction.INSTANCE, GetRolesAction.INSTANCE, PutRoleAction.INSTANCE, DeleteRoleAction.INSTANCE, ChangePasswordAction.INSTANCE, AuthenticateAction.INSTANCE, SetEnabledAction.INSTANCE, HasPrivilegesAction.INSTANCE, GetRoleMappingsAction.INSTANCE, PutRoleMappingAction.INSTANCE, DeleteRoleMappingAction.INSTANCE, CreateTokenAction.INSTANCE, InvalidateTokenAction.INSTANCE, GetCertificateInfoAction.INSTANCE, RefreshTokenAction.INSTANCE, CreateApiKeyAction.INSTANCE, InvalidateApiKeyAction.INSTANCE, GetApiKeyAction.INSTANCE, IndexUpgradeInfoAction.INSTANCE, IndexUpgradeAction.INSTANCE, PutWatchAction.INSTANCE, DeleteWatchAction.INSTANCE, GetWatchAction.INSTANCE, WatcherStatsAction.INSTANCE, AckWatchAction.INSTANCE, ActivateWatchAction.INSTANCE, WatcherServiceAction.INSTANCE, ExecuteWatchAction.INSTANCE, PutLicenseAction.INSTANCE, GetLicenseAction.INSTANCE, DeleteLicenseAction.INSTANCE, PostStartTrialAction.INSTANCE, GetTrialStatusAction.INSTANCE, PostStartBasicAction.INSTANCE, GetBasicStatusAction.INSTANCE, XPackInfoAction.INSTANCE, XPackUsageAction.INSTANCE, RollupSearchAction.INSTANCE, PutRollupJobAction.INSTANCE, StartRollupJobAction.INSTANCE, StopRollupJobAction.INSTANCE, DeleteRollupJobAction.INSTANCE, GetRollupJobsAction.INSTANCE, GetRollupCapsAction.INSTANCE, DeleteLifecycleAction.INSTANCE, GetLifecycleAction.INSTANCE, PutLifecycleAction.INSTANCE, ExplainLifecycleAction.INSTANCE, RemoveIndexLifecyclePolicyAction.INSTANCE, MoveToStepAction.INSTANCE, RetryAction.INSTANCE, PutSnapshotLifecycleAction.INSTANCE, GetSnapshotLifecycleAction.INSTANCE, DeleteSnapshotLifecycleAction.INSTANCE, ExecuteSnapshotLifecycleAction.INSTANCE, FreezeIndexAction.INSTANCE, PutDataFrameTransformAction.INSTANCE, StartDataFrameTransformAction.INSTANCE, StartDataFrameTransformTaskAction.INSTANCE, StopDataFrameTransformAction.INSTANCE, DeleteDataFrameTransformAction.INSTANCE, GetDataFrameTransformsAction.INSTANCE, GetDataFrameTransformsStatsAction.INSTANCE, PreviewDataFrameTransformAction.INSTANCE});
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return Arrays.asList(new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "graph", GraphFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "logstash", LogstashFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "beats", BeatsFeatureSetUsage::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "ml", MlMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "ml", MlMetadata.MlMetadataDiff::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/datafeed", StartDatafeedAction.DatafeedParams::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job", OpenJobAction.JobParams::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/data_frame/analytics", StartDataFrameAnalyticsAction.TaskParams::new), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/job", JobTaskState::new), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/datafeed", DatafeedState::fromStream), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/data_frame/analytics", DataFrameAnalyticsTaskState::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "ml", MachineLearningFeatureSetUsage::new), new NamedWriteableRegistry.Entry(DataFrameAnalysis.class, OutlierDetection.NAME.getPreferredName(), OutlierDetection::new), new NamedWriteableRegistry.Entry(DataFrameAnalysis.class, Regression.NAME.getPreferredName(), Regression::new), new NamedWriteableRegistry.Entry(Evaluation.class, BinarySoftClassification.NAME.getPreferredName(), BinarySoftClassification::new), new NamedWriteableRegistry.Entry(SoftClassificationMetric.class, AucRoc.NAME.getPreferredName(), AucRoc::new), new NamedWriteableRegistry.Entry(SoftClassificationMetric.class, Precision.NAME.getPreferredName(), Precision::new), new NamedWriteableRegistry.Entry(SoftClassificationMetric.class, Recall.NAME.getPreferredName(), Recall::new), new NamedWriteableRegistry.Entry(SoftClassificationMetric.class, ConfusionMatrix.NAME.getPreferredName(), ConfusionMatrix::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, AucRoc.NAME.getPreferredName(), AucRoc.Result::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, "score_by_threshold_result", ScoreByThresholdResult::new), new NamedWriteableRegistry.Entry(EvaluationMetricResult.class, ConfusionMatrix.NAME.getPreferredName(), ConfusionMatrix.Result::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "monitoring", MonitoringFeatureSetUsage::new), new NamedWriteableRegistry.Entry(ClusterState.Custom.class, "security_tokens", TokenMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "security_tokens", TokenMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "security", SecurityFeatureSetUsage::new), new NamedWriteableRegistry.Entry(ConfigurableClusterPrivilege.class, "manage-application-privileges", ConfigurableClusterPrivileges.ManageApplicationPrivileges::createFrom), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "all", AllExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "any", AnyExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "field", FieldExpression::new), new NamedWriteableRegistry.Entry(RoleMapperExpression.class, "except", ExceptExpression::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "sql", SqlFeatureSetUsage::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "watcher", WatcherMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "watcher", WatcherMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "watcher", WatcherFeatureSetUsage::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "licenses", LicensesMetaData::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "licenses", LicensesMetaData::readDiffFrom), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "rollup", RollupFeatureSetUsage::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/rollup/job", RollupJob::new), new NamedWriteableRegistry.Entry(Task.Status.class, "xpack/rollup/job", RollupJobStatus::new), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/rollup/job", RollupJobStatus::new), new NamedWriteableRegistry.Entry(AutoFollowMetadata.class, "ccr_auto_follow", AutoFollowMetadata::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "ccr_auto_follow", AutoFollowMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "ccr_auto_follow", in -> AutoFollowMetadata.readDiffFrom(MetaData.Custom.class, (String)"ccr_auto_follow", (StreamInput)in)), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "ccr", CCRFeatureSet.Usage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "ilm", IndexLifecycleFeatureSetUsage::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "index_lifecycle", IndexLifecycleMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "index_lifecycle", IndexLifecycleMetadata.IndexLifecycleMetadataDiff::new), new NamedWriteableRegistry.Entry(MetaData.Custom.class, "snapshot_lifecycle", SnapshotLifecycleMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "snapshot_lifecycle", SnapshotLifecycleMetadata.SnapshotLifecycleMetadataDiff::new), new NamedWriteableRegistry.Entry(LifecycleType.class, "timeseries", in -> TimeseriesLifecycleType.INSTANCE), new NamedWriteableRegistry.Entry(LifecycleAction.class, "allocate", AllocateAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "forcemerge", ForceMergeAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "readonly", ReadOnlyAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "rollover", RolloverAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "shrink", ShrinkAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "delete", DeleteAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "freeze", FreezeAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "set_priority", SetPriorityAction::new), new NamedWriteableRegistry.Entry(LifecycleAction.class, "unfollow", UnfollowAction::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "data_frame", DataFrameFeatureSetUsage::new), new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "data_frame/transforms", DataFrameTransform::new), new NamedWriteableRegistry.Entry(Task.Status.class, "data_frame/transforms", DataFrameTransformState::new), new NamedWriteableRegistry.Entry(PersistentTaskState.class, "data_frame/transforms", DataFrameTransformState::new), new NamedWriteableRegistry.Entry(SyncConfig.class, DataFrameField.TIME_BASED_SYNC.getPreferredName(), TimeSyncConfig::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "flattened", FlattenedFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "vectors", VectorsFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "voting_only", VotingOnlyNodeFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "frozen_indices", FrozenIndicesFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "spatial", SpatialFeatureSetUsage::new), new NamedWriteableRegistry.Entry(XPackFeatureSet.Usage.class, "analytics", AnalyticsFeatureSetUsage::new));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return Arrays.asList(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("ml", new String[0]), parser -> ((MlMetadata.Builder)MlMetadata.LENIENT_PARSER.parse(parser, null)).build()), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/datafeed", new String[0]), StartDatafeedAction.DatafeedParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/job", new String[0]), OpenJobAction.JobParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/ml/data_frame/analytics", new String[0]), StartDataFrameAnalyticsAction.TaskParams::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/datafeed", new String[0]), DatafeedState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/job", new String[0]), JobTaskState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/ml/data_frame/analytics", new String[0]), DataFrameAnalyticsTaskState::fromXContent), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("watcher", new String[0]), WatcherMetaData::fromXContent), new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("licenses", new String[0]), LicensesMetaData::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("xpack/rollup/job", new String[0]), RollupJob::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("xpack/rollup/job", new String[0]), RollupJobStatus::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("xpack/rollup/job", new String[0]), RollupJobStatus::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskParams.class, new ParseField("data_frame/transforms", new String[0]), DataFrameTransform::fromXContent), new NamedXContentRegistry.Entry(Task.Status.class, new ParseField("data_frame/transforms", new String[0]), DataFrameTransformState::fromXContent), new NamedXContentRegistry.Entry(PersistentTaskState.class, new ParseField("data_frame/transforms", new String[0]), DataFrameTransformState::fromXContent));
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, PageCacheRecycler pageCacheRecycler, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        SSLService sslService;
        if (!XPackPlugin.transportClientMode(settings) || !((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            return Collections.emptyMap();
        }
        try {
            sslService = new SSLService(settings, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("security4", () -> new SecurityNetty4Transport(settings, Version.CURRENT, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sslService));
    }
}

