/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.repositories.FilterRepository;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.snapshots.SeqIdGeneratingFilterReader;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SourceOnlySnapshot;

public final class SourceOnlySnapshotRepository
extends FilterRepository {
    private static final Setting<String> DELEGATE_TYPE = new Setting("delegate_type", "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> SOURCE_ONLY = Setting.boolSetting((String)"index.source_only", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.Final, Setting.Property.PrivateIndex});
    private static final String SNAPSHOT_DIR_NAME = "_snapshot";

    SourceOnlySnapshotRepository(Repository in) {
        super(in);
    }

    public void initializeSnapshot(SnapshotId snapshotId, List<IndexId> indices, MetaData metaData) {
        try {
            MetaData.Builder builder = MetaData.builder((MetaData)metaData);
            for (IndexId indexId : indices) {
                IndexMetaData index = metaData.index(indexId.getName());
                IndexMetaData.Builder indexMetadataBuilder = IndexMetaData.builder((IndexMetaData)index);
                ImmutableOpenMap mappings = index.getMappings();
                for (ObjectObjectCursor next : mappings) {
                    String mapping = "{ \"" + (String)next.key + "\": { \"enabled\": false, \"_meta\": " + ((MappingMetaData)next.value).source().string() + " } }";
                    indexMetadataBuilder.putMapping((String)next.key, mapping);
                }
                indexMetadataBuilder.settings(Settings.builder().put(index.getSettings()).put(SOURCE_ONLY.getKey(), true).put("index.blocks.write", true));
                indexMetadataBuilder.settingsVersion(1L + indexMetadataBuilder.settingsVersion());
                builder.put(indexMetadataBuilder);
            }
            super.initializeSnapshot(snapshotId, indices, builder.build());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotShard(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus) {
        if (mapperService.documentMapper() != null && !mapperService.documentMapper().sourceMapper().isComplete()) {
            throw new IllegalStateException("Can't snapshot _source only on an index that has incomplete source ie. has _source disabled or filters the source");
        }
        Directory unwrap = FilterDirectory.unwrap((Directory)store.directory());
        if (!(unwrap instanceof FSDirectory)) {
            throw new AssertionError((Object)("expected FSDirectory but got " + unwrap.toString()));
        }
        Path dataPath = ((FSDirectory)unwrap).getDirectory().getParent();
        Path snapPath = dataPath.resolve(SNAPSHOT_DIR_NAME);
        try (SimpleFSDirectory directory = new SimpleFSDirectory(snapPath);){
            Store tempStore = new Store(store.shardId(), store.indexSettings(), (Directory)directory, new ShardLock(store.shardId()){

                protected void closeInternal() {
                }
            }, Store.OnClose.EMPTY);
            Supplier<Query> querySupplier = mapperService.hasNested() ? Queries::newNestedFilter : null;
            SourceOnlySnapshot snapshot = new SourceOnlySnapshot(tempStore.directory(), querySupplier);
            snapshot.syncSnapshot(snapshotIndexCommit);
            SegmentInfos segmentInfos = tempStore.readLastCommittedSegmentsInfo();
            long maxDoc = segmentInfos.totalMaxDoc();
            tempStore.bootstrapNewHistory(maxDoc, maxDoc);
            store.incRef();
            try (DirectoryReader reader = DirectoryReader.open((Directory)tempStore.directory(), Collections.singletonMap("blocktree.terms.fst", BlockTreeTermsReader.FSTLoadMode.OFF_HEAP.name()));){
                IndexCommit indexCommit = reader.getIndexCommit();
                super.snapshotShard(tempStore, mapperService, snapshotId, indexId, indexCommit, snapshotStatus);
            }
            finally {
                store.decRef();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static EngineFactory getEngineFactory() {
        return config -> new ReadOnlyEngine(config, null, new TranslogStats(0, 0L, 0, 0L, 0L), true, reader -> {
            try {
                return SeqIdGeneratingFilterReader.wrap(reader, config.getPrimaryTermSupplier().getAsLong());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static Repository.Factory newRepositoryFactory() {
        return new Repository.Factory(){

            public Repository create(RepositoryMetaData metadata) {
                throw new UnsupportedOperationException();
            }

            public Repository create(RepositoryMetaData metaData, Function<String, Repository.Factory> typeLookup) throws Exception {
                String delegateType = (String)DELEGATE_TYPE.get(metaData.settings());
                if (!Strings.hasLength((String)delegateType)) {
                    throw new IllegalArgumentException(DELEGATE_TYPE.getKey() + " must be set");
                }
                Repository.Factory factory = typeLookup.apply(delegateType);
                return new SourceOnlySnapshotRepository(factory.create(new RepositoryMetaData(metaData.name(), delegateType, metaData.settings()), typeLookup));
            }
        };
    }
}

