/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Locale;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.DateUtils;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.OperationModeFileWatcher;
import org.elasticsearch.protocol.xpack.license.LicenseStatus;

public class License
implements ToXContentObject {
    public static final int VERSION_START = 1;
    public static final int VERSION_NO_FEATURE_TYPE = 2;
    public static final int VERSION_START_DATE = 3;
    public static final int VERSION_CRYPTO_ALGORITHMS = 4;
    public static final int VERSION_CURRENT = 4;
    public static final String REST_VIEW_MODE = "rest_view";
    public static final String LICENSE_SPEC_VIEW_MODE = "license_spec_view";
    public static final String LICENSE_VERSION_MODE = "license_version";
    public static final Comparator<License> LATEST_ISSUE_DATE_FIRST = Comparator.comparing(License::issueDate).reversed();
    private final int version;
    private final String uid;
    private final String issuer;
    private final String issuedTo;
    private final long issueDate;
    private final String type;
    private final String subscriptionType;
    private final String feature;
    private final String signature;
    private final long expiryDate;
    private final long startDate;
    private final int maxNodes;
    private final OperationMode operationMode;
    private volatile OperationModeFileWatcher operationModeFileWatcher;

    private License(int version, String uid, String issuer, String issuedTo, long issueDate, String type, String subscriptionType, String feature, String signature, long expiryDate, int maxNodes, long startDate) {
        this.version = version;
        this.uid = uid;
        this.issuer = issuer;
        this.issuedTo = issuedTo;
        this.issueDate = issueDate;
        this.type = type;
        this.subscriptionType = subscriptionType;
        this.feature = feature;
        this.signature = signature;
        this.expiryDate = expiryDate == -1L ? LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS : expiryDate;
        this.maxNodes = maxNodes;
        this.startDate = startDate;
        this.operationMode = version == 1 ? OperationMode.resolve(subscriptionType) : OperationMode.resolve(type);
        this.validate();
    }

    public int version() {
        return this.version;
    }

    public String uid() {
        return this.uid;
    }

    public String type() {
        return this.type;
    }

    public long issueDate() {
        return this.issueDate;
    }

    public long startDate() {
        return this.startDate;
    }

    public long expiryDate() {
        return this.expiryDate;
    }

    public int maxNodes() {
        return this.maxNodes;
    }

    public String issuedTo() {
        return this.issuedTo;
    }

    public String issuer() {
        return this.issuer;
    }

    public String signature() {
        return this.signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationMode operationMode() {
        License license = this;
        synchronized (license) {
            if (this.canReadOperationModeFromFile() && this.operationModeFileWatcher != null) {
                return this.operationModeFileWatcher.getCurrentOperationMode();
            }
        }
        return this.operationMode;
    }

    private boolean canReadOperationModeFromFile() {
        return this.type.equals("cloud_internal");
    }

    public synchronized void setOperationModeFileWatcher(OperationModeFileWatcher operationModeFileWatcher) {
        this.operationModeFileWatcher = operationModeFileWatcher;
        if (this.canReadOperationModeFromFile()) {
            this.operationModeFileWatcher.init();
        }
    }

    public synchronized void removeOperationModeFileWatcher() {
        this.operationModeFileWatcher = null;
    }

    public LicenseStatus status() {
        long now = System.currentTimeMillis();
        if (this.issueDate > now) {
            return LicenseStatus.INVALID;
        }
        if (this.expiryDate < now) {
            return LicenseStatus.EXPIRED;
        }
        return LicenseStatus.ACTIVE;
    }

    private void validate() {
        if (this.issuer == null) {
            throw new IllegalStateException("issuer can not be null");
        }
        if (this.issuedTo == null) {
            throw new IllegalStateException("issuedTo can not be null");
        }
        if (this.issueDate == -1L) {
            throw new IllegalStateException("issueDate has to be set");
        }
        if (this.type == null) {
            throw new IllegalStateException("type can not be null");
        }
        if (this.subscriptionType == null && this.version == 1) {
            throw new IllegalStateException("subscriptionType can not be null");
        }
        if (this.uid == null) {
            throw new IllegalStateException("uid can not be null");
        }
        if (this.feature == null && this.version == 1) {
            throw new IllegalStateException("feature can not be null");
        }
        if (this.maxNodes == -1) {
            throw new IllegalStateException("maxNodes has to be set");
        }
        if (this.expiryDate == -1L) {
            throw new IllegalStateException("expiryDate has to be set");
        }
        if (this.expiryDate == LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS && !"basic".equals(this.type)) {
            throw new IllegalStateException("only basic licenses are allowed to have no expiration");
        }
    }

    public static License readLicense(StreamInput in) throws IOException {
        int version = in.readVInt();
        if (version > 4) {
            throw new ElasticsearchException("Unknown license version found, please upgrade all nodes to the latest elasticsearch-license plugin", new Object[0]);
        }
        Builder builder = License.builder();
        builder.version(version);
        builder.uid(in.readString());
        builder.type(in.readString());
        if (version == 1) {
            builder.subscriptionType(in.readString());
        }
        builder.issueDate(in.readLong());
        if (version == 1) {
            builder.feature(in.readString());
        }
        builder.expiryDate(in.readLong());
        builder.maxNodes(in.readInt());
        builder.issuedTo(in.readString());
        builder.issuer(in.readString());
        builder.signature(in.readOptionalString());
        if (version >= 3) {
            builder.startDate(in.readLong());
        }
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.version);
        out.writeString(this.uid);
        out.writeString(this.type);
        if (this.version == 1) {
            out.writeString(this.subscriptionType);
        }
        out.writeLong(this.issueDate);
        if (this.version == 1) {
            out.writeString(this.feature);
        }
        out.writeLong(this.expiryDate);
        out.writeInt(this.maxNodes);
        out.writeString(this.issuedTo);
        out.writeString(this.issuer);
        out.writeOptionalString(this.signature);
        if (this.version >= 3) {
            out.writeLong(this.startDate);
        }
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            return Strings.toString((XContentBuilder)builder);
        }
        catch (IOException e) {
            return "";
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toInnerXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toInnerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean licenseSpecMode = params.paramAsBoolean(LICENSE_SPEC_VIEW_MODE, false);
        boolean restViewMode = params.paramAsBoolean(REST_VIEW_MODE, false);
        boolean previouslyHumanReadable = builder.humanReadable();
        if (licenseSpecMode && restViewMode) {
            throw new IllegalArgumentException("can have either rest_view or license_spec_view");
        }
        if (restViewMode && !previouslyHumanReadable) {
            builder.humanReadable(true);
        }
        int version = params.param(LICENSE_VERSION_MODE) != null && restViewMode ? Integer.parseInt(params.param(LICENSE_VERSION_MODE)) : this.version;
        if (restViewMode) {
            builder.field("status", this.status().label());
        }
        builder.field("uid", this.uid);
        builder.field("type", this.type);
        if (version == 1) {
            builder.field("subscription_type", this.subscriptionType);
        }
        builder.timeField("issue_date_in_millis", "issue_date", this.issueDate);
        if (version == 1) {
            builder.field("feature", this.feature);
        }
        if (this.expiryDate != LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS) {
            builder.timeField("expiry_date_in_millis", "expiry_date", this.expiryDate);
        }
        builder.field("max_nodes", this.maxNodes);
        builder.field("issued_to", this.issuedTo);
        builder.field("issuer", this.issuer);
        if (!licenseSpecMode && !restViewMode && this.signature != null) {
            builder.field("signature", this.signature);
        }
        if (restViewMode) {
            builder.humanReadable(previouslyHumanReadable);
        }
        if (version >= 3) {
            builder.timeField("start_date_in_millis", "start_date", this.startDate);
        }
        return builder;
    }

    public static License fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Builder builder = new Builder();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token.isValue()) {
                if ("uid".equals(currentFieldName)) {
                    builder.uid(parser.text());
                    continue;
                }
                if ("type".equals(currentFieldName)) {
                    builder.type(parser.text());
                    continue;
                }
                if ("subscription_type".equals(currentFieldName)) {
                    builder.subscriptionType(parser.text());
                    continue;
                }
                if ("issue_date".equals(currentFieldName)) {
                    builder.issueDate(License.parseDate(parser, "issue", false));
                    continue;
                }
                if ("issue_date_in_millis".equals(currentFieldName)) {
                    builder.issueDate(parser.longValue());
                    continue;
                }
                if ("feature".equals(currentFieldName)) {
                    builder.feature(parser.text());
                    continue;
                }
                if ("expiry_date".equals(currentFieldName)) {
                    builder.expiryDate(License.parseDate(parser, "expiration", true));
                    continue;
                }
                if ("expiry_date_in_millis".equals(currentFieldName)) {
                    builder.expiryDate(parser.longValue());
                    continue;
                }
                if ("start_date".equals(currentFieldName)) {
                    builder.startDate(License.parseDate(parser, "start", false));
                    continue;
                }
                if ("start_date_in_millis".equals(currentFieldName)) {
                    builder.startDate(parser.longValue());
                    continue;
                }
                if ("max_nodes".equals(currentFieldName)) {
                    builder.maxNodes(parser.intValue());
                    continue;
                }
                if ("issued_to".equals(currentFieldName)) {
                    builder.issuedTo(parser.text());
                    continue;
                }
                if ("issuer".equals(currentFieldName)) {
                    builder.issuer(parser.text());
                    continue;
                }
                if ("signature".equals(currentFieldName)) {
                    builder.signature(parser.text());
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser.intValue());
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        if (builder.signature != null) {
            int version;
            try {
                byte[] signatureBytes = Base64.getDecoder().decode(builder.signature);
                ByteBuffer byteBuffer = ByteBuffer.wrap(signatureBytes);
                version = byteBuffer.getInt();
            }
            catch (Exception e) {
                throw new ElasticsearchException("malformed signature for license [" + builder.uid + "]", (Throwable)e, new Object[0]);
            }
            if (version < 0) {
                version *= -1;
            }
            if (version == 0) {
                throw new ElasticsearchException("malformed signature for license [" + builder.uid + "]", new Object[0]);
            }
            if (version > 4) {
                throw new ElasticsearchException("Unknown license version found, please upgrade all nodes to the latest elasticsearch-license plugin", new Object[0]);
            }
            builder.version(version);
        }
        return builder.build();
    }

    public static boolean isAutoGeneratedLicense(String signature) {
        try {
            byte[] signatureBytes = Base64.getDecoder().decode(signature);
            ByteBuffer byteBuffer = ByteBuffer.wrap(signatureBytes);
            return byteBuffer.getInt() < 0;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static License fromSource(BytesReference bytes, XContentType xContentType) throws IOException {
        if (bytes == null || bytes.length() == 0) {
            throw new ElasticsearchParseException("failed to parse license - no content provided", new Object[0]);
        }
        if (xContentType == null) {
            throw new ElasticsearchParseException("failed to parse license - no content-type provided", new Object[0]);
        }
        try (StreamInput byteStream = bytes.streamInput();){
            License license;
            try (XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)byteStream);){
                License license2 = null;
                if (parser.nextToken() != XContentParser.Token.START_OBJECT) throw new ElasticsearchParseException("failed to parse licenses expected start object", new Object[0]);
                if (parser.nextToken() != XContentParser.Token.FIELD_NAME) throw new ElasticsearchParseException("failed to parse licenses expected field", new Object[0]);
                String currentFieldName = parser.currentName();
                if ("licenses".equals(currentFieldName)) {
                    ArrayList<License> pre20Licenses = new ArrayList<License>();
                    if (parser.nextToken() != XContentParser.Token.START_ARRAY) throw new ElasticsearchParseException("failed to parse licenses expected an array of licenses", new Object[0]);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        pre20Licenses.add(License.fromXContent(parser));
                    }
                    CollectionUtil.timSort(pre20Licenses, LATEST_ISSUE_DATE_FIRST);
                    long now = System.currentTimeMillis();
                    for (License oldLicense : pre20Licenses) {
                        if (oldLicense.expiryDate() <= now) continue;
                        license2 = oldLicense;
                        break;
                    }
                    if (license2 == null && !pre20Licenses.isEmpty()) {
                        license2 = (License)pre20Licenses.get(0);
                    }
                } else if ("license".equals(currentFieldName)) {
                    license2 = License.fromXContent(parser);
                }
                license = license2;
                if (parser == null) return license;
            }
            return license;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        if (this.issueDate != license.issueDate) {
            return false;
        }
        if (this.expiryDate != license.expiryDate) {
            return false;
        }
        if (this.startDate != license.startDate) {
            return false;
        }
        if (this.maxNodes != license.maxNodes) {
            return false;
        }
        if (this.version != license.version) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(license.uid) : license.uid != null) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(license.issuer) : license.issuer != null) {
            return false;
        }
        if (this.issuedTo != null ? !this.issuedTo.equals(license.issuedTo) : license.issuedTo != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(license.type) : license.type != null) {
            return false;
        }
        if (this.subscriptionType != null ? !this.subscriptionType.equals(license.subscriptionType) : license.subscriptionType != null) {
            return false;
        }
        if (this.feature != null ? !this.feature.equals(license.feature) : license.feature != null) {
            return false;
        }
        return !(this.signature == null ? license.signature != null : !this.signature.equals(license.signature));
    }

    public int hashCode() {
        int result = this.uid != null ? this.uid.hashCode() : 0;
        result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
        result = 31 * result + (this.issuedTo != null ? this.issuedTo.hashCode() : 0);
        result = 31 * result + (int)(this.issueDate ^ this.issueDate >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.subscriptionType != null ? this.subscriptionType.hashCode() : 0);
        result = 31 * result + (this.feature != null ? this.feature.hashCode() : 0);
        result = 31 * result + (this.signature != null ? this.signature.hashCode() : 0);
        result = 31 * result + (int)(this.expiryDate ^ this.expiryDate >>> 32);
        result = 31 * result + (int)(this.startDate ^ this.startDate >>> 32);
        result = 31 * result + this.maxNodes;
        result = 31 * result + this.version;
        return result;
    }

    private static long parseDate(XContentParser parser, String description, boolean endOfTheDay) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            return parser.longValue();
        }
        try {
            if (endOfTheDay) {
                return DateUtils.endOfTheDay(parser.text());
            }
            return DateUtils.beginningOfTheDay(parser.text());
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticsearchParseException("invalid " + description + " date format " + parser.text(), new Object[0]);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int version = 4;
        private String uid;
        private String issuer;
        private String issuedTo;
        private long issueDate = -1L;
        private String type;
        private String subscriptionType;
        private String feature;
        private String signature;
        private long expiryDate = -1L;
        private long startDate = -1L;
        private int maxNodes = -1;

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder issuedTo(String issuedTo) {
            this.issuedTo = issuedTo;
            return this;
        }

        public Builder issueDate(long issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        public Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public Builder expiryDate(long expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder maxNodes(int maxNodes) {
            this.maxNodes = maxNodes;
            return this;
        }

        public Builder signature(String signature) {
            if (signature != null) {
                this.signature = signature;
            }
            return this;
        }

        public Builder startDate(long startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder fromLicenseSpec(License license, String signature) {
            return this.uid(license.uid()).version(license.version()).issuedTo(license.issuedTo()).issueDate(license.issueDate()).startDate(license.startDate()).type(license.type()).subscriptionType(license.subscriptionType).feature(license.feature).maxNodes(license.maxNodes()).expiryDate(license.expiryDate()).issuer(license.issuer()).signature(signature);
        }

        public Builder fromPre20LicenseSpec(License pre20License) {
            return this.uid(pre20License.uid()).issuedTo(pre20License.issuedTo()).issueDate(pre20License.issueDate()).maxNodes(pre20License.maxNodes()).expiryDate(pre20License.expiryDate());
        }

        public License build() {
            return new License(this.version, this.uid, this.issuer, this.issuedTo, this.issueDate, this.type, this.subscriptionType, this.feature, this.signature, this.expiryDate, this.maxNodes, this.startDate);
        }

        public Builder validate() {
            if (this.issuer == null) {
                throw new IllegalStateException("issuer can not be null");
            }
            if (this.issuedTo == null) {
                throw new IllegalStateException("issuedTo can not be null");
            }
            if (this.issueDate == -1L) {
                throw new IllegalStateException("issueDate has to be set");
            }
            if (this.type == null) {
                throw new IllegalStateException("type can not be null");
            }
            if (this.uid == null) {
                throw new IllegalStateException("uid can not be null");
            }
            if (this.signature == null) {
                throw new IllegalStateException("signature can not be null");
            }
            if (this.maxNodes == -1) {
                throw new IllegalStateException("maxNodes has to be set");
            }
            if (this.expiryDate == -1L) {
                throw new IllegalStateException("expiryDate has to be set");
            }
            return this;
        }
    }

    public static final class Fields {
        public static final String STATUS = "status";
        public static final String UID = "uid";
        public static final String TYPE = "type";
        public static final String SUBSCRIPTION_TYPE = "subscription_type";
        public static final String ISSUE_DATE_IN_MILLIS = "issue_date_in_millis";
        public static final String ISSUE_DATE = "issue_date";
        public static final String FEATURE = "feature";
        public static final String EXPIRY_DATE_IN_MILLIS = "expiry_date_in_millis";
        public static final String EXPIRY_DATE = "expiry_date";
        public static final String START_DATE_IN_MILLIS = "start_date_in_millis";
        public static final String START_DATE = "start_date";
        public static final String MAX_NODES = "max_nodes";
        public static final String ISSUED_TO = "issued_to";
        public static final String ISSUER = "issuer";
        public static final String VERSION = "version";
        public static final String SIGNATURE = "signature";
        public static final String LICENSES = "licenses";
        public static final String LICENSE = "license";
    }

    public static enum OperationMode {
        MISSING(0),
        TRIAL(1),
        BASIC(2),
        STANDARD(3),
        GOLD(4),
        PLATINUM(5);

        private final byte id;

        private OperationMode(byte id) {
            this.id = id;
        }

        public static int compare(OperationMode opMode1, OperationMode opMode2) {
            return Integer.compare(opMode1.id, opMode2.id);
        }

        public static OperationMode resolve(String type) {
            switch (type.toLowerCase(Locale.ROOT)) {
                case "missing": {
                    return MISSING;
                }
                case "trial": 
                case "none": 
                case "dev": 
                case "development": {
                    return TRIAL;
                }
                case "basic": {
                    return BASIC;
                }
                case "standard": {
                    return STANDARD;
                }
                case "silver": 
                case "gold": {
                    return GOLD;
                }
                case "platinum": 
                case "cloud_internal": 
                case "internal": {
                    return PLATINUM;
                }
            }
            throw new IllegalArgumentException("unknown type [" + type + "]");
        }

        public String description() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

