/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.service;

import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.watcher.WatcherMetaData;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;

public class TransportWatcherServiceAction
extends TransportMasterNodeAction<WatcherServiceRequest, AcknowledgedResponse> {
    private AckedRequest ackedRequest = new AckedRequest(){

        public TimeValue ackTimeout() {
            return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
        }

        public TimeValue masterNodeTimeout() {
            return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
        }
    };

    @Inject
    public TransportWatcherServiceAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/watcher/service", transportService, clusterService, threadPool, actionFilters, WatcherServiceRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "management";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void masterOperation(WatcherServiceRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        switch (request.getCommand()) {
            case STOP: {
                this.setWatcherMetaDataAndWait(true, listener);
                break;
            }
            case START: {
                this.setWatcherMetaDataAndWait(false, listener);
            }
        }
    }

    private void setWatcherMetaDataAndWait(final boolean manuallyStopped, final ActionListener<AcknowledgedResponse> listener) {
        String source = manuallyStopped ? "update_watcher_manually_stopped" : "update_watcher_manually_started";
        this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<AcknowledgedResponse>(this.ackedRequest, listener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }

            public ClusterState execute(ClusterState clusterState) {
                XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
                WatcherMetaData newWatcherMetaData = new WatcherMetaData(manuallyStopped);
                WatcherMetaData currentMetaData = (WatcherMetaData)clusterState.metaData().custom("watcher");
                if (newWatcherMetaData.equals((Object)currentMetaData)) {
                    return clusterState;
                }
                ClusterState.Builder builder = new ClusterState.Builder(clusterState);
                builder.metaData(MetaData.builder((MetaData)clusterState.getMetaData()).putCustom("watcher", (MetaData.Custom)newWatcherMetaData));
                return builder.build();
            }

            public void onFailure(String source, Exception e) {
                TransportWatcherServiceAction.this.logger.error((Message)new ParameterizedMessage("could not update watcher stopped status to [{}], source [{}]", (Object)manuallyStopped, (Object)source), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(WatcherServiceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

