/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.flattened;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.flattened.FlattenedFeatureSetUsage;

public class FlattenedFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public FlattenedFeatureSet(Settings settings, XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.FLATTENED_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "flattened";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isFlattenedAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new FlattenedFeatureSetUsage(this.available(), this.enabled()));
    }
}

