/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.nio.Config;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioChannel;
import org.elasticsearch.nio.NioChannelHandler;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.nio.WriteOperation;
import org.elasticsearch.xpack.security.transport.nio.SSLDriver;
import org.elasticsearch.xpack.security.transport.nio.SSLOutboundBuffer;

public final class SSLChannelContext
extends SocketChannelContext {
    private static final long CLOSE_TIMEOUT_NANOS = new TimeValue(10L, TimeUnit.SECONDS).nanos();
    private static final Runnable DEFAULT_TIMEOUT_CANCELLER = () -> {};
    private final SSLDriver sslDriver;
    private final InboundChannelBuffer networkReadBuffer;
    private final LinkedList<FlushOperation> encryptedFlushes = new LinkedList();
    private Runnable closeTimeoutCanceller = DEFAULT_TIMEOUT_CANCELLER;

    SSLChannelContext(NioSocketChannel channel, NioSelector selector, Config.Socket socketConfig, Consumer<Exception> exceptionHandler, SSLDriver sslDriver, NioChannelHandler readWriteHandler, InboundChannelBuffer applicationBuffer) {
        this(channel, selector, socketConfig, exceptionHandler, sslDriver, readWriteHandler, InboundChannelBuffer.allocatingInstance(), applicationBuffer);
    }

    SSLChannelContext(NioSocketChannel channel, NioSelector selector, Config.Socket socketConfig, Consumer<Exception> exceptionHandler, SSLDriver sslDriver, NioChannelHandler readWriteHandler, InboundChannelBuffer networkReadBuffer, InboundChannelBuffer channelBuffer) {
        super(channel, selector, socketConfig, exceptionHandler, readWriteHandler, channelBuffer);
        this.sslDriver = sslDriver;
        this.networkReadBuffer = networkReadBuffer;
    }

    protected void channelActive() throws IOException {
        super.channelActive();
        this.sslDriver.init();
        SSLOutboundBuffer outboundBuffer = this.sslDriver.getOutboundBuffer();
        if (outboundBuffer.hasEncryptedBytesToFlush()) {
            this.encryptedFlushes.addLast(outboundBuffer.buildNetworkFlushOperation());
        }
    }

    public void queueWriteOperation(WriteOperation writeOperation) {
        this.getSelector().assertOnSelectorThread();
        if (writeOperation instanceof CloseNotifyOperation) {
            try {
                this.sslDriver.initiateClose();
                SSLOutboundBuffer outboundBuffer = this.sslDriver.getOutboundBuffer();
                if (outboundBuffer.hasEncryptedBytesToFlush()) {
                    this.encryptedFlushes.addLast(outboundBuffer.buildNetworkFlushOperation());
                }
                long relativeNanos = CLOSE_TIMEOUT_NANOS + System.nanoTime();
                this.closeTimeoutCanceller = this.getSelector().getTaskScheduler().scheduleAtRelativeTime(this::channelCloseTimeout, relativeNanos);
            }
            catch (SSLException e) {
                this.handleException(e);
            }
        } else {
            super.queueWriteOperation(writeOperation);
        }
    }

    public void flushChannel() throws IOException {
        FlushOperation unencryptedFlush;
        if (this.closeNow()) {
            return;
        }
        if (this.pendingChannelFlush()) {
            this.flushEncryptedOperation();
            if (this.pendingChannelFlush()) {
                return;
            }
        }
        while (!this.pendingChannelFlush() && (unencryptedFlush = this.getPendingFlush()) != null) {
            if (unencryptedFlush.isFullyFlushed()) {
                this.currentFlushOperationComplete();
                continue;
            }
            try {
                this.sslDriver.write(unencryptedFlush);
                SSLOutboundBuffer outboundBuffer = this.sslDriver.getOutboundBuffer();
                if (!outboundBuffer.hasEncryptedBytesToFlush()) break;
                this.encryptedFlushes.addLast(outboundBuffer.buildNetworkFlushOperation());
                this.flushEncryptedOperation();
            }
            catch (IOException e) {
                this.currentFlushOperationFailed(e);
                throw e;
            }
        }
    }

    private void flushEncryptedOperation() throws IOException {
        try {
            FlushOperation encryptedFlush = this.encryptedFlushes.getFirst();
            this.flushToChannel(encryptedFlush);
            if (encryptedFlush.isFullyFlushed()) {
                this.getSelector().executeListener(encryptedFlush.getListener(), null);
                this.encryptedFlushes.removeFirst();
            }
        }
        catch (IOException e) {
            this.getSelector().executeFailedListener(this.encryptedFlushes.removeFirst().getListener(), (Exception)e);
            throw e;
        }
    }

    public boolean readyForFlush() {
        this.getSelector().assertOnSelectorThread();
        if (this.sslDriver.readyForApplicationData()) {
            return this.pendingChannelFlush() || super.readyForFlush();
        }
        return this.pendingChannelFlush();
    }

    public int read() throws IOException {
        int bytesRead = 0;
        if (this.closeNow()) {
            return bytesRead;
        }
        bytesRead = this.readFromChannel(this.networkReadBuffer);
        if (bytesRead == 0) {
            return bytesRead;
        }
        this.sslDriver.read(this.networkReadBuffer, this.channelBuffer);
        this.handleReadBytes();
        SSLOutboundBuffer outboundBuffer = this.sslDriver.getOutboundBuffer();
        if (outboundBuffer.hasEncryptedBytesToFlush()) {
            this.encryptedFlushes.addLast(outboundBuffer.buildNetworkFlushOperation());
        }
        return bytesRead;
    }

    public boolean selectorShouldClose() {
        return this.closeNow() || this.sslDriver.isClosed() && !this.pendingChannelFlush();
    }

    public void closeChannel() {
        if (this.isClosing.compareAndSet(false, true)) {
            if (this.getSelectionKey() == null) {
                this.getSelector().queueChannelClose((NioChannel)this.channel);
            } else {
                CloseNotifyOperation writeOperation = new CloseNotifyOperation(this);
                this.getSelector().queueWrite((WriteOperation)writeOperation);
            }
        }
    }

    public void closeFromSelector() throws IOException {
        this.getSelector().assertOnSelectorThread();
        if (this.channel.isOpen()) {
            this.closeTimeoutCanceller.run();
            for (FlushOperation encryptedFlush : this.encryptedFlushes) {
                this.getSelector().executeFailedListener(encryptedFlush.getListener(), (Exception)new ClosedChannelException());
            }
            this.encryptedFlushes.clear();
            Closeable[] closeableArray = new Closeable[3];
            closeableArray[0] = () -> super.closeFromSelector();
            closeableArray[1] = () -> ((InboundChannelBuffer)this.networkReadBuffer).close();
            closeableArray[2] = this.sslDriver::close;
            IOUtils.close((Closeable[])closeableArray);
        }
    }

    public SSLEngine getSSLEngine() {
        return this.sslDriver.getSSLEngine();
    }

    private void channelCloseTimeout() {
        this.closeTimeoutCanceller = DEFAULT_TIMEOUT_CANCELLER;
        this.setCloseNow();
        this.getSelector().queueChannelClose((NioChannel)this.channel);
    }

    private boolean pendingChannelFlush() {
        return !this.encryptedFlushes.isEmpty();
    }

    private static class CloseNotifyOperation
    implements WriteOperation {
        private static final BiConsumer<Void, Exception> LISTENER = (v, t) -> {};
        private static final Object WRITE_OBJECT = new Object();
        private final SocketChannelContext channelContext;

        private CloseNotifyOperation(SocketChannelContext channelContext) {
            this.channelContext = channelContext;
        }

        public BiConsumer<Void, Exception> getListener() {
            return LISTENER;
        }

        public SocketChannelContext getChannel() {
            return this.channelContext;
        }

        public Object getObject() {
            return WRITE_OBJECT;
        }
    }
}

