/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;

public class SecurityStatusChangeListener
implements LicenseStateListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final XPackLicenseState licenseState;
    private Boolean securityEnabled;

    public SecurityStatusChangeListener(XPackLicenseState licenseState) {
        this.licenseState = licenseState;
        this.securityEnabled = null;
    }

    public synchronized void licenseStateChanged() {
        boolean newState;
        boolean bl = newState = this.licenseState.isSecurityAvailable() && !this.licenseState.isSecurityDisabledByLicenseDefaults();
        if (!Objects.equals(newState, this.securityEnabled)) {
            this.logger.info("Active license is now [{}]; Security is {}", (Object)this.licenseState.getOperationMode(), (Object)(newState ? "enabled" : "disabled"));
            this.securityEnabled = newState;
        }
    }
}

