/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsResponse;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestGetRoleMappingsAction
extends SecurityBaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetRoleMappingsAction.class));

    public RestGetRoleMappingsAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_security/role_mapping/", (RestHandler)this, RestRequest.Method.GET, "/_xpack/security/role_mapping/", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_security/role_mapping/{name}", (RestHandler)this, RestRequest.Method.GET, "/_xpack/security/role_mapping/{name}", deprecationLogger);
    }

    public String getName() {
        return "security_get_role_mappings_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        final String[] names = request.paramAsStringArrayOrEmptyIfAll("name");
        return channel -> new SecurityClient((ElasticsearchClient)client).prepareGetRoleMappings(names).execute((ActionListener)new RestBuilderListener<GetRoleMappingsResponse>(channel){

            public RestResponse buildResponse(GetRoleMappingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (ExpressionRoleMapping mapping : response.mappings()) {
                    builder.field(mapping.getName(), (ToXContent)mapping);
                }
                builder.endObject();
                if (names.length != 0 && response.mappings().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

