/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationAction;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationRequest;
import org.elasticsearch.xpack.core.security.action.oidc.OpenIdConnectPrepareAuthenticationResponse;
import org.elasticsearch.xpack.security.rest.action.oidc.OpenIdConnectBaseRestHandler;

public class RestOpenIdConnectPrepareAuthenticationAction
extends OpenIdConnectBaseRestHandler {
    static final ObjectParser<OpenIdConnectPrepareAuthenticationRequest, Void> PARSER = new ObjectParser("oidc_prepare_authentication", OpenIdConnectPrepareAuthenticationRequest::new);

    public RestOpenIdConnectPrepareAuthenticationAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_security/oidc/prepare", (RestHandler)this);
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(final RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            OpenIdConnectPrepareAuthenticationRequest prepareAuthenticationRequest = (OpenIdConnectPrepareAuthenticationRequest)PARSER.parse(parser, null);
            this.logger.trace("OIDC Prepare Authentication: " + prepareAuthenticationRequest);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)OpenIdConnectPrepareAuthenticationAction.INSTANCE, (ActionRequest)prepareAuthenticationRequest, (ActionListener)new RestBuilderListener<OpenIdConnectPrepareAuthenticationResponse>(channel){

                public RestResponse buildResponse(OpenIdConnectPrepareAuthenticationResponse response, XContentBuilder builder) throws Exception {
                    RestOpenIdConnectPrepareAuthenticationAction.this.logger.trace("OIDC Prepare Authentication Response: " + response);
                    return new BytesRestResponse(RestStatus.OK, response.toXContent(builder, (ToXContent.Params)request));
                }
            });
            return restChannelConsumer;
        }
    }

    public String getName() {
        return "security_oidc_prepare_authentication_action";
    }

    static {
        PARSER.declareString(OpenIdConnectPrepareAuthenticationRequest::setRealmName, new ParseField("realm", new String[0]));
        PARSER.declareString(OpenIdConnectPrepareAuthenticationRequest::setIssuer, new ParseField("iss", new String[0]));
        PARSER.declareString(OpenIdConnectPrepareAuthenticationRequest::setLoginHint, new ParseField("login_hint", new String[0]));
        PARSER.declareString(OpenIdConnectPrepareAuthenticationRequest::setState, new ParseField("state", new String[0]));
        PARSER.declareString(OpenIdConnectPrepareAuthenticationRequest::setNonce, new ParseField("nonce", new String[0]));
    }
}

