/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oauth2;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenAction;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.InvalidateTokenResponse;
import org.elasticsearch.xpack.security.rest.action.oauth2.TokenBaseRestHandler;

public final class RestInvalidateTokenAction
extends TokenBaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestInvalidateTokenAction.class));
    static final ConstructingObjectParser<InvalidateTokenRequest, Void> PARSER = new ConstructingObjectParser("invalidate_token", a -> {
        String tokenType;
        String tokenString;
        String token = (String)a[0];
        String refreshToken = (String)a[1];
        if (Strings.hasLength((String)token) && Strings.hasLength((String)refreshToken)) {
            throw new IllegalArgumentException("only one of [token, refresh_token] may be sent per request");
        }
        if (Strings.hasLength((String)token)) {
            tokenString = token;
            tokenType = InvalidateTokenRequest.Type.ACCESS_TOKEN.getValue();
        } else if (Strings.hasLength((String)refreshToken)) {
            tokenString = refreshToken;
            tokenType = InvalidateTokenRequest.Type.REFRESH_TOKEN.getValue();
        } else {
            tokenString = null;
            tokenType = null;
        }
        return new InvalidateTokenRequest(tokenString, tokenType, (String)a[2], (String)a[3]);
    });

    public RestInvalidateTokenAction(Settings settings, RestController controller, XPackLicenseState xPackLicenseState) {
        super(settings, xPackLicenseState);
        controller.registerWithDeprecatedHandler(RestRequest.Method.DELETE, "/_security/oauth2/token", (RestHandler)this, RestRequest.Method.DELETE, "/_xpack/security/oauth2/token", deprecationLogger);
    }

    public String getName() {
        return "security_invalidate_token_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            InvalidateTokenRequest invalidateTokenRequest = (InvalidateTokenRequest)PARSER.parse(parser, null);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)InvalidateTokenAction.INSTANCE, (ActionRequest)invalidateTokenRequest, (ActionListener)new RestBuilderListener<InvalidateTokenResponse>(channel){

                public RestResponse buildResponse(InvalidateTokenResponse invalidateResp, XContentBuilder builder) throws Exception {
                    invalidateResp.toXContent(builder, (ToXContent.Params)this.channel.request());
                    return new BytesRestResponse(RestStatus.OK, builder);
                }
            });
            return restChannelConsumer;
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("token", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("refresh_token", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("realm_name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("username", new String[0]));
    }
}

