/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cli.EnvironmentAwareCommand;
import org.elasticsearch.cli.LoggingAwareMultiCommand;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.file.FileUserPasswdStore;
import org.elasticsearch.xpack.security.authc.file.FileUserRolesStore;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;

public class ESNativeRealmMigrateTool
extends LoggingAwareMultiCommand {
    public static void main(String[] args) throws Exception {
        ESNativeRealmMigrateTool.exit((int)new ESNativeRealmMigrateTool().main(args, Terminal.DEFAULT));
    }

    public ESNativeRealmMigrateTool() {
        super("Imports file-based users and roles to the native security realm");
        this.subcommands.put("native", this.newMigrateUserOrRoles());
    }

    protected MigrateUserOrRoles newMigrateUserOrRoles() {
        return new MigrateUserOrRoles();
    }

    static Logger getTerminalLogger(final Terminal terminal) {
        Logger logger = LogManager.getLogger(ESNativeRealmMigrateTool.class);
        Loggers.setLevel((Logger)logger, (Level)Level.ALL);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        AbstractAppender appender = new AbstractAppender(ESNativeRealmMigrateTool.class.getName(), null, (Layout)PatternLayout.newBuilder().withConfiguration(config).withPattern("%m").build()){

            public void append(LogEvent event) {
                switch (event.getLevel().getStandardLevel()) {
                    case FATAL: 
                    case ERROR: {
                        terminal.println(Terminal.Verbosity.NORMAL, event.getMessage().getFormattedMessage());
                        break;
                    }
                    case OFF: {
                        break;
                    }
                    default: {
                        terminal.println(Terminal.Verbosity.VERBOSE, event.getMessage().getFormattedMessage());
                    }
                }
            }
        };
        appender.start();
        LoggerConfig loggerConfig = config.getLoggerConfig(ESNativeRealmMigrateTool.class.getName());
        loggerConfig.setParent(null);
        loggerConfig.getAppenders().forEach((s, a) -> Loggers.removeAppender((Logger)logger, (Appender)a));
        Loggers.addAppender((Logger)logger, (Appender)appender);
        return logger;
    }

    public static class MigrateUserOrRoles
    extends EnvironmentAwareCommand {
        private final OptionSpec<String> username;
        private final OptionSpec<String> password;
        private final OptionSpec<String> url;
        private final OptionSpec<String> usersToMigrateCsv;
        private final OptionSpec<String> rolesToMigrateCsv;

        public MigrateUserOrRoles() {
            super("Migrates users or roles from file to native realm");
            this.username = this.parser.acceptsAll(Arrays.asList("u", "username"), "User used to authenticate with Elasticsearch").withRequiredArg().required();
            this.password = this.parser.acceptsAll(Arrays.asList("p", "password"), "Password used to authenticate with Elasticsearch").withRequiredArg().required();
            this.url = this.parser.acceptsAll(Arrays.asList("U", "url"), "URL of Elasticsearch host").withRequiredArg();
            this.usersToMigrateCsv = this.parser.acceptsAll(Arrays.asList("n", "users"), "Users to migrate from file to native realm").withRequiredArg();
            this.rolesToMigrateCsv = this.parser.acceptsAll(Arrays.asList("r", "roles"), "Roles to migrate from file to native realm").withRequiredArg();
        }

        public OptionParser getParser() {
            return this.parser;
        }

        protected void printAdditionalHelp(Terminal terminal) {
            terminal.println("This tool migrates file based users[1] and roles[2] to the native realm in");
            terminal.println("elasticsearch, saving the administrator from needing to manually transition");
            terminal.println("them from the file.");
        }

        public void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
            terminal.println("Warning: The migrate tool is deprecated. Use the native realm directly instead of file realms.");
            terminal.println("starting migration of users and roles...");
            this.importUsers(terminal, env, options);
            this.importRoles(terminal, env, options);
            terminal.println("users and roles imported.");
        }

        @SuppressForbidden(reason="We call connect in doPrivileged and provide SocketPermission")
        private String postURL(Settings settings, Environment env, String method, String urlString, OptionSet options, @Nullable String bodyString) throws Exception {
            HttpURLConnection conn;
            URI uri = new URI(urlString);
            URL url = uri.toURL();
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                SSLService sslService = new SSLService(settings, env);
                SSLConfiguration sslConfiguration = sslService.getSSLConfiguration("xpack.security.http.ssl");
                HttpsURLConnection httpsConn = (HttpsURLConnection)url.openConnection();
                AccessController.doPrivileged(() -> {
                    httpsConn.setSSLSocketFactory(sslService.sslSocketFactory(sslConfiguration));
                    return null;
                });
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            conn.setRequestMethod(method);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("Authorization", UsernamePasswordToken.basicAuthHeaderValue((String)((String)this.username.value(options)), (SecureString)new SecureString(((String)this.password.value(options)).toCharArray())));
            conn.setRequestProperty("Content-Type", XContentType.JSON.mediaType());
            conn.setDoOutput(true);
            SocketAccess.doPrivileged(conn::connect);
            if (bodyString != null) {
                try (OutputStream out = conn.getOutputStream();){
                    out.write(bodyString.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    try {
                        conn.disconnect();
                    }
                    catch (Exception sslConfiguration) {
                        // empty catch block
                    }
                    throw e;
                }
            }
            try {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                try {
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                    string = sb.toString();
                }
                catch (Throwable sb) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable line) {
                            sb.addSuppressed(line);
                        }
                        throw sb;
                    }
                    catch (IOException e) {
                        try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));){
                            StringBuilder sb2 = new StringBuilder();
                            String line = null;
                            while ((line = reader2.readLine()) != null) {
                                sb2.append(line);
                            }
                            throw new IOException(sb2.toString(), e);
                        }
                    }
                }
                return string;
            }
            finally {
                conn.disconnect();
            }
        }

        Set<String> getUsersThatExist(Terminal terminal, Settings settings, Environment env, OptionSet options) throws Exception {
            HashSet<String> existingUsers;
            block8: {
                existingUsers = new HashSet<String>();
                String allUsersJson = this.postURL(settings, env, "GET", (String)this.url.value(options) + "/_security/user/", options, null);
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, allUsersJson);){
                    XContentParser.Token token = parser.nextToken();
                    if (token == XContentParser.Token.START_OBJECT) {
                        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                            String userName = parser.currentName();
                            existingUsers.add(userName);
                            parser.nextToken();
                            parser.skipChildren();
                        }
                        break block8;
                    }
                    throw new ElasticsearchException("failed to retrieve users, expecting an object but got: " + token, new Object[0]);
                }
            }
            terminal.println("found existing users: " + existingUsers);
            return existingUsers;
        }

        static String createUserJson(String[] roles, char[] password) throws IOException {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.field("password_hash", new String(password));
            builder.startArray("roles");
            for (String role : roles) {
                builder.value(role);
            }
            builder.endArray();
            builder.endObject();
            return Strings.toString((XContentBuilder)builder);
        }

        void importUsers(Terminal terminal, Environment env, OptionSet options) throws FileNotFoundException {
            Set<String> existingUsers;
            String usersCsv = (String)this.usersToMigrateCsv.value(options);
            String[] usersToMigrate = usersCsv != null ? usersCsv.split(",") : Strings.EMPTY_ARRAY;
            Path usersFile = FileUserPasswdStore.resolveFile(env);
            Path usersRolesFile = FileUserRolesStore.resolveFile(env);
            if (!Files.exists(usersFile, new LinkOption[0])) {
                throw new FileNotFoundException("users file [" + usersFile + "] does not exist");
            }
            if (!Files.exists(usersRolesFile, new LinkOption[0])) {
                throw new FileNotFoundException("users_roles file [" + usersRolesFile + "] does not exist");
            }
            terminal.println("importing users from [" + usersFile + "]...");
            Logger logger = ESNativeRealmMigrateTool.getTerminalLogger(terminal);
            Map<String, char[]> userToHashedPW = FileUserPasswdStore.parseFile(usersFile, logger, env.settings());
            Map<String, String[]> userToRoles = FileUserRolesStore.parseFile(usersRolesFile, logger);
            try {
                existingUsers = this.getUsersThatExist(terminal, env.settings(), env, options);
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to get users that already exist, skipping user import", (Throwable)e, new Object[0]);
            }
            if (usersToMigrate.length == 0) {
                usersToMigrate = userToHashedPW.keySet().toArray(new String[userToHashedPW.size()]);
            }
            for (String user : usersToMigrate) {
                if (!userToHashedPW.containsKey(user)) {
                    terminal.println("user [" + user + "] was not found in files, skipping");
                    continue;
                }
                if (existingUsers.contains(user)) {
                    terminal.println("user [" + user + "] already exists, skipping");
                    continue;
                }
                terminal.println("migrating user [" + user + "]");
                String reqBody = "n/a";
                try {
                    reqBody = MigrateUserOrRoles.createUserJson(userToRoles.get(user), userToHashedPW.get(user));
                    String resp = this.postURL(env.settings(), env, "POST", (String)this.url.value(options) + "/_security/user/" + user, options, reqBody);
                    terminal.println(resp);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to migrate user [" + user + "] with body: " + reqBody, (Throwable)e, new Object[0]);
                }
            }
        }

        Set<String> getRolesThatExist(Terminal terminal, Settings settings, Environment env, OptionSet options) throws Exception {
            HashSet<String> existingRoles;
            block8: {
                existingRoles = new HashSet<String>();
                String allRolesJson = this.postURL(settings, env, "GET", (String)this.url.value(options) + "/_security/role/", options, null);
                try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, allRolesJson);){
                    XContentParser.Token token = parser.nextToken();
                    if (token == XContentParser.Token.START_OBJECT) {
                        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                            String roleName = parser.currentName();
                            existingRoles.add(roleName);
                            parser.nextToken();
                            parser.skipChildren();
                        }
                        break block8;
                    }
                    throw new ElasticsearchException("failed to retrieve roles, expecting an object but got: " + token, new Object[0]);
                }
            }
            terminal.println("found existing roles: " + existingRoles);
            return existingRoles;
        }

        static String createRoleJson(RoleDescriptor rd) throws IOException {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            rd.toXContent(builder, ToXContent.EMPTY_PARAMS, true);
            return Strings.toString((XContentBuilder)builder);
        }

        void importRoles(Terminal terminal, Environment env, OptionSet options) throws FileNotFoundException {
            Set<String> existingRoles;
            String rolesCsv = (String)this.rolesToMigrateCsv.value(options);
            String[] rolesToMigrate = rolesCsv != null ? rolesCsv.split(",") : Strings.EMPTY_ARRAY;
            Path rolesFile = FileRolesStore.resolveFile(env).toAbsolutePath();
            if (!Files.exists(rolesFile, new LinkOption[0])) {
                throw new FileNotFoundException("roles.yml file [" + rolesFile + "] does not exist");
            }
            terminal.println("importing roles from [" + rolesFile + "]...");
            Logger logger = ESNativeRealmMigrateTool.getTerminalLogger(terminal);
            Map<String, RoleDescriptor> roles = FileRolesStore.parseRoleDescriptors(rolesFile, logger, true, Settings.EMPTY);
            try {
                existingRoles = this.getRolesThatExist(terminal, env.settings(), env, options);
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to get roles that already exist, skipping role import", (Throwable)e, new Object[0]);
            }
            if (rolesToMigrate.length == 0) {
                rolesToMigrate = roles.keySet().toArray(new String[roles.size()]);
            }
            for (String roleName : rolesToMigrate) {
                if (!roles.containsKey(roleName)) {
                    terminal.println("no role [" + roleName + "] found, skipping");
                    continue;
                }
                if (existingRoles.contains(roleName)) {
                    terminal.println("role [" + roleName + "] already exists, skipping");
                    continue;
                }
                terminal.println("migrating role [" + roleName + "]");
                String reqBody = "n/a";
                try {
                    reqBody = MigrateUserOrRoles.createRoleJson(roles.get(roleName));
                    String resp = this.postURL(env.settings(), env, "POST", (String)this.url.value(options) + "/_security/role/" + roleName, options, reqBody);
                    terminal.println(resp);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to migrate role [" + roleName + "] with body: " + reqBody, (Throwable)e, new Object[0]);
                }
            }
        }
    }
}

