/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.transforms.pivot;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Aggregations {
    private static final String DYNAMIC = "_dynamic";
    private static final String SOURCE = "_source";
    private static Set<String> aggregationSupported = Stream.of(AggregationType.values()).map(Enum::name).collect(Collectors.toSet());

    private Aggregations() {
    }

    public static boolean isSupportedByDataframe(String aggregationType) {
        return aggregationSupported.contains(aggregationType.toUpperCase(Locale.ROOT));
    }

    public static boolean isDynamicMapping(String targetMapping) {
        return DYNAMIC.equals(targetMapping);
    }

    public static String resolveTargetMapping(String aggregationType, String sourceType) {
        AggregationType agg = AggregationType.valueOf(aggregationType.toUpperCase(Locale.ROOT));
        return agg.getTargetMapping().equals(SOURCE) ? sourceType : agg.getTargetMapping();
    }

    static enum AggregationType {
        AVG("avg", "double"),
        CARDINALITY("cardinality", "long"),
        VALUE_COUNT("value_count", "long"),
        MAX("max", "_source"),
        MIN("min", "_source"),
        SUM("sum", "double"),
        GEO_CENTROID("geo_centroid", "geo_point"),
        GEO_BOUNDS("geo_bounds", "geo_shape"),
        SCRIPTED_METRIC("scripted_metric", "_dynamic"),
        WEIGHTED_AVG("weighted_avg", "_dynamic"),
        BUCKET_SELECTOR("bucket_selector", "_dynamic"),
        BUCKET_SCRIPT("bucket_script", "_dynamic");

        private final String aggregationType;
        private final String targetMapping;

        private AggregationType(String name, String targetMapping) {
            this.aggregationType = name;
            this.targetMapping = targetMapping;
        }

        public String getName() {
            return this.aggregationType;
        }

        public String getTargetMapping() {
            return this.targetMapping;
        }
    }
}

