/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.action.StartDataFrameTransformAction;

public class RestStartDataFrameTransformAction
extends BaseRestHandler {
    public RestStartDataFrameTransformAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.POST, "/_data_frame/transforms/{id}/_start", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        String id = restRequest.param(DataFrameField.ID.getPreferredName());
        boolean force = restRequest.paramAsBoolean(DataFrameField.FORCE.getPreferredName(), false);
        StartDataFrameTransformAction.Request request = new StartDataFrameTransformAction.Request(id, force);
        request.timeout(restRequest.paramAsTime(DataFrameField.TIMEOUT.getPreferredName(), AcknowledgedRequest.DEFAULT_ACK_TIMEOUT));
        return channel -> client.execute((ActionType)StartDataFrameTransformAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "data_frame_start_transform_action";
    }
}

