/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.dataframe.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.dataframe.DataFrameField;
import org.elasticsearch.xpack.core.dataframe.action.GetDataFrameTransformsAction;

public class RestGetDataFrameTransformsAction
extends BaseRestHandler {
    public RestGetDataFrameTransformsAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_data_frame/transforms/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_data_frame/transforms/{id}/", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        GetDataFrameTransformsAction.Request request = new GetDataFrameTransformsAction.Request();
        String id = restRequest.param(DataFrameField.ID.getPreferredName());
        request.setResourceId(id);
        request.setAllowNoResources(restRequest.paramAsBoolean(DataFrameField.ALLOW_NO_MATCH.getPreferredName(), true));
        if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
        }
        return channel -> client.execute((ActionType)GetDataFrameTransformsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "data_frame_get_transforms_action";
    }
}

